/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Objects;
import org.assertj.core.annotation.CheckReturnValue;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Descriptable;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.ThrowableAssertAlternative;
import org.assertj.core.description.Description;
import org.assertj.core.util.VisibleForTesting;

public class ThrowableTypeAssert<T extends Throwable>
implements Descriptable<ThrowableTypeAssert<T>> {
    @VisibleForTesting
    protected final Class<? extends T> expectedThrowableType;
    protected Description description;

    public ThrowableTypeAssert(Class<? extends T> throwableType) {
        this.expectedThrowableType = Objects.requireNonNull(throwableType, "exceptionType");
    }

    public ThrowableAssertAlternative<T> isThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = ThrowableAssert.catchThrowable(throwingCallable);
        this.checkThrowableType(throwable);
        Throwable castThrowable = throwable;
        return this.buildThrowableTypeAssert(castThrowable).as(this.description);
    }

    protected void checkThrowableType(Throwable throwable) {
        ((AbstractAssert)((AbstractThrowableAssert)((AbstractObjectAssert)((Object)Assertions.assertThat(throwable))).as(this.description)).hasBeenThrown()).isInstanceOf((Class)this.expectedThrowableType);
    }

    protected ThrowableAssertAlternative<T> buildThrowableTypeAssert(T throwable) {
        return new ThrowableAssertAlternative<T>(throwable);
    }

    @Override
    @CheckReturnValue
    public ThrowableTypeAssert<T> describedAs(Description description) {
        this.description = description;
        return this;
    }
}

