/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.coercion;

import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import com.sun.ts.tests.el.common.util.TestNum;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DateTimeCoercionIT {
    private static final Map<Object, Instant> mapInputExpectedResult;

    @Test
    public void testCoercetoInstant() {
        for (Map.Entry<Object, Instant> entry : mapInputExpectedResult.entrySet()) {
            NameValuePair[] values = NameValuePair.buildUnaryNameValue(entry.getKey());
            Object result = ExprEval.evaluateValueExpression("${A}", values, Instant.class);
            if (entry.getValue() == null) {
                Assertions.assertNull((Object)result);
                continue;
            }
            Assertions.assertTrue((boolean)ExprEval.compareClass(result, Instant.class));
            Assertions.assertEquals((Object)result, (Object)entry.getValue());
        }
    }

    @Test
    public void testCoercetoDate() {
        for (Map.Entry<Object, Instant> entry : mapInputExpectedResult.entrySet()) {
            NameValuePair[] values = NameValuePair.buildUnaryNameValue(entry.getKey());
            Object result = ExprEval.evaluateValueExpression("${A}", values, Date.class);
            if (entry.getValue() == null) {
                Assertions.assertNull((Object)result);
                continue;
            }
            Assertions.assertTrue((boolean)ExprEval.compareClass(result, Date.class));
            Assertions.assertEquals((Object)result, entry.getValue() == null ? null : Date.from(entry.getValue()));
        }
    }

    static {
        LinkedHashMap<Object, Instant> map = new LinkedHashMap<Object, Instant>();
        map.put(null, null);
        for (Object obj : TestNum.getDateTimeList()) {
            map.put(obj, TestNum.DATE_REFERENCE);
        }
        mapInputExpectedResult = Collections.unmodifiableMap(map);
    }
}

