/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.impl.XWSSecurityRuntimeException;
import com.sun.xml.wss.impl.misc.DefaultRealmAuthenticationAdapter;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import com.sun.xml.wss.util.ServletContextUtil;
import com.sun.xml.wss.util.WSSServletContextFacade;
import java.net.URL;
import java.util.Map;
import javax.security.auth.Subject;

public abstract class RealmAuthenticationAdapter {
    public static final String UsernameAuthenticator = "com.sun.xml.xwss.RealmAuthenticator";

    protected RealmAuthenticationAdapter() {
    }

    public abstract boolean authenticate(Subject var1, String var2, String var3) throws XWSSecurityException;

    public boolean authenticate(Subject callerSubject, String username, String password, Map runtimeProps) throws XWSSecurityException {
        return this.authenticate(callerSubject, username, password);
    }

    public boolean authenticate(Subject callerSubject, String username, String passwordDigest, String nonce, String created) throws XWSSecurityException {
        throw new XWSSecurityException("Default Implementation : Override this authenticate method in your RealmAuthenticationAdapter");
    }

    public boolean authenticate(Subject callerSubject, String username, String passwordDigest, String nonce, String created, Map runtimeProps) throws XWSSecurityException {
        return this.authenticate(callerSubject, username, passwordDigest, nonce, created);
    }

    public static RealmAuthenticationAdapter newInstance(Object context) {
        WSSServletContextFacade ctxt = ServletContextUtil.wrap(context);
        URL url = ctxt == null ? SecurityUtil.loadFromClasspath("META-INF/services/com.sun.xml.xwss.RealmAuthenticator") : ctxt.getResource("/META-INF/services/com.sun.xml.xwss.RealmAuthenticator");
        if (url != null) {
            Object obj = SecurityUtil.loadSPIClass(url, UsernameAuthenticator);
            if (obj != null && !(obj instanceof RealmAuthenticationAdapter)) {
                throw new XWSSecurityRuntimeException("Class :" + obj.getClass().getName() + " is not a valid RealmAuthenticationProvider");
            }
            return (RealmAuthenticationAdapter)obj;
        }
        return new DefaultRealmAuthenticationAdapter();
    }
}

