/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.callback;

import com.sun.xml.wss.impl.PolicyTypeUtil;
import com.sun.xml.wss.impl.callback.XWSSCallback;
import com.sun.xml.wss.impl.policy.DynamicPolicyContext;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.StaticPolicyContext;
import javax.security.auth.callback.Callback;

public class DynamicPolicyCallback
extends XWSSCallback
implements Callback {
    boolean isDynamicSecurityPolicy = false;
    SecurityPolicy _policy;
    DynamicPolicyContext _ctx;

    public DynamicPolicyCallback(SecurityPolicy _policy, DynamicPolicyContext _ctx) throws PolicyGenerationException {
        this.checkType(_policy);
        this._policy = _policy;
        this._ctx = _ctx;
    }

    public SecurityPolicy getSecurityPolicy() {
        return this._policy;
    }

    public DynamicPolicyContext getDynamicContext() {
        return this._ctx;
    }

    public StaticPolicyContext getStaticContext() {
        return this._ctx.getStaticPolicyContext();
    }

    public void setSecurityPolicy(SecurityPolicy _policy) {
        if (this.isDynamicSecurityPolicy) {
            this.checkType0(_policy);
            this._policy = _policy;
        } else {
            if (!this._policy.getType().equals(_policy.getType())) {
                throw new UnsupportedOperationException("Can not change object instance for WSSPolicy");
            }
            this._policy = _policy;
        }
    }

    public boolean isDynamicSecurityPolicy() {
        return this.isDynamicSecurityPolicy;
    }

    private void checkType(SecurityPolicy policy) throws PolicyGenerationException {
        try {
            if (PolicyTypeUtil.dynamicSecurityPolicy(policy)) {
                this.isDynamicSecurityPolicy = true;
            } else if (!Class.forName("com.sun.xml.wss.impl.policy.mls.WSSPolicy").isAssignableFrom(policy.getClass())) {
                throw new PolicyGenerationException("Invalid SecurityPolicy type");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private void checkType0(SecurityPolicy policy) {
        if (!PolicyTypeUtil.messagePolicy(policy)) {
            throw new IllegalArgumentException("Invalid SecurityPolicy type " + String.valueOf(policy) + ", Expected MessagePolicy");
        }
    }
}

