/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.net;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivilegedExceptionAction;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.derby.shared.common.drda.NaiveTrustManager;

class OpenSocketAction
implements PrivilegedExceptionAction<Socket> {
    private String server_;
    private int port_;
    private int clientSSLMode_;

    OpenSocketAction(String string, int n, int n2) {
        this.server_ = string;
        this.port_ = n;
        this.clientSSLMode_ = n2;
    }

    @Override
    public Socket run() throws UnknownHostException, IOException, NoSuchAlgorithmException, KeyManagementException, NoSuchProviderException, KeyStoreException, UnrecoverableKeyException, CertificateException {
        SocketFactory socketFactory;
        Object object;
        switch (this.clientSSLMode_) {
            case 1: {
                object = this.getSSLProperties();
                socketFactory = NaiveTrustManager.getSocketFactory((Properties)object);
                break;
            }
            case 2: {
                socketFactory = SSLSocketFactory.getDefault();
                break;
            }
            case 0: {
                socketFactory = SocketFactory.getDefault();
                break;
            }
            default: {
                socketFactory = SocketFactory.getDefault();
            }
        }
        if (this.clientSSLMode_ == 1 || this.clientSSLMode_ == 2) {
            object = (SSLSocket)socketFactory.createSocket(this.server_, this.port_);
            String[] stringArray = ((SSLSocket)object).getEnabledProtocols();
            String[] stringArray2 = new String[stringArray.length];
            int n = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].toUpperCase().contains("SSLV3") || stringArray[i].toUpperCase().contains("SSLV2HELLO")) continue;
                stringArray2[n] = stringArray[i];
                ++n;
            }
            if (n < stringArray.length) {
                String[] stringArray3 = null;
                stringArray3 = new String[n];
                System.arraycopy(stringArray2, 0, stringArray3, 0, n);
                ((SSLSocket)object).setEnabledProtocols(stringArray3);
            }
            return object;
        }
        return socketFactory.createSocket(this.server_, this.port_);
    }

    private Properties getSSLProperties() {
        Properties properties = new Properties();
        String string = System.getProperty("javax.net.ssl.keyStore");
        if (string != null) {
            properties.setProperty("javax.net.ssl.keyStore", string);
        }
        String string2 = System.getProperty("javax.net.ssl.keyStorePassword");
        if (string != null) {
            properties.setProperty("javax.net.ssl.keyStorePassword", string2);
        }
        return properties;
    }
}

