/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.MetaConfig;
import io.helidon.config.spi.ChangeWatcher;
import io.helidon.config.spi.PollableSource;
import io.helidon.config.spi.PollingStrategy;
import io.helidon.config.spi.RetryPolicy;
import io.helidon.config.spi.Source;
import io.helidon.config.spi.WatchableSource;
import java.util.Optional;
import java.util.function.Supplier;

public abstract class AbstractSourceBuilder<B extends AbstractSourceBuilder<B, U>, U>
implements Source.Builder<B> {
    private PollingStrategy pollingStrategy;
    private RetryPolicy retryPolicy;
    private ChangeWatcher<U> changeWatcher;
    private boolean optional = false;
    private final B me = this;

    protected B config(Config metaConfig) {
        metaConfig.get("optional").asBoolean().ifPresent(bl -> this.optional((boolean)bl));
        metaConfig.get("polling-strategy").as(MetaConfig::pollingStrategy).ifPresent(this::pollingStrategy);
        metaConfig.get("change-watcher").as(MetaConfig::changeWatcher).ifPresent(it -> this.changeWatcher((ChangeWatcher<U>)it));
        metaConfig.get("retry-policy").as(MetaConfig::retryPolicy).ifPresent(supplier -> this.retryPolicy((Supplier)supplier));
        return this.me;
    }

    public B retryPolicy(Supplier<? extends RetryPolicy> policy) {
        this.retryPolicy = policy.get();
        return this.me;
    }

    public B optional(boolean optional) {
        this.optional = optional;
        return this.me;
    }

    protected B changeWatcher(ChangeWatcher<U> changeWatcher) {
        if (!(this instanceof WatchableSource.Builder)) {
            throw new ConfigException("You are attempting to configure a change watcher on a source builder that does not support it: " + this.getClass().getName());
        }
        this.changeWatcher = changeWatcher;
        return this.me;
    }

    protected B pollingStrategy(PollingStrategy pollingStrategy) {
        if (!(this instanceof PollableSource.Builder)) {
            throw new ConfigException("You are attempting to configure a polling strategy on a source builder that does not support it: " + this.getClass().getName());
        }
        this.pollingStrategy = pollingStrategy;
        return this.me;
    }

    Optional<PollingStrategy> pollingStrategy() {
        return Optional.ofNullable(this.pollingStrategy);
    }

    Optional<RetryPolicy> retryPolicy() {
        return Optional.ofNullable(this.retryPolicy);
    }

    Optional<ChangeWatcher<U>> changeWatcher() {
        return Optional.ofNullable(this.changeWatcher);
    }

    boolean isOptional() {
        return this.optional;
    }
}

