/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.binding.convert.impl;

import java.lang.annotation.Annotation;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.krazo.binding.convert.ConverterResult;
import org.eclipse.krazo.binding.convert.impl.NumberConverter;

public class DoubleConverter
extends NumberConverter<Double> {
    @Override
    public boolean supports(Class<Double> rawType, Annotation[] annotations) {
        return Double.class.equals(rawType) || Double.TYPE.equals(rawType);
    }

    @Override
    public ConverterResult<Double> convert(String value, Class<Double> rawType, Annotation[] annotations, Locale locale) {
        Double defaultValue = Double.TYPE.equals(rawType) ? Double.valueOf(0.0) : null;
        try {
            return ConverterResult.success(this.parseNumber(value, locale).map(Number::doubleValue).orElse(defaultValue));
        }
        catch (ParseException e) {
            return ConverterResult.failed(defaultValue, e.getMessage());
        }
    }
}

