/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc;

import antlr.ANTLRException;
import antlr.collections.AST;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.ErrorMsg;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLC;
import com.sun.jdo.spi.persistence.support.sqlstore.query.jqlc.JQLParser;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import org.glassfish.ejb.deployment.descriptor.QueryParser;
import org.glassfish.persistence.common.I18NHelper;

public class JDOQLParameterDeclarationParser
implements QueryParser {
    protected static final ResourceBundle messages = I18NHelper.loadBundle(JDOQLParameterDeclarationParser.class);

    public Iterator<String> parameterTypeIterator(String text) {
        return new ParameterTypeIterator(this.parse(text));
    }

    private AST parse(String text) {
        if (text == null) {
            return null;
        }
        AST paramsAST = null;
        ErrorMsg errorMsg = new ErrorMsg();
        JQLParser parser = JQLC.createStringParser(text, errorMsg);
        try {
            parser.parseParameters();
            paramsAST = parser.getAST();
        }
        catch (ANTLRException ex) {
            JQLParser.handleANTLRException(ex, errorMsg);
        }
        return paramsAST;
    }

    private static class ParameterTypeIterator
    implements Iterator<String> {
        private AST current;

        ParameterTypeIterator(AST ast) {
            this.current = ast;
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public String next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            if (this.current.getType() != 61) {
                throw new JDOFatalInternalException(I18NHelper.getMessage(messages, "jqlc.jdoqlparameterdeclarationparser.next.wrongtoken", this.current.getType()));
            }
            String typeRepr = this.getTypeRepr(this.current.getFirstChild());
            this.current = this.current.getNextSibling();
            return typeRepr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private String getTypeRepr(AST ast) {
            if (ast == null) {
                return "";
            }
            if (ast.getType() == 94) {
                AST left = ast.getFirstChild();
                AST right = left.getNextSibling();
                return this.getTypeRepr(left) + "." + this.getTypeRepr(right);
            }
            return ast.getText();
        }
    }
}

