/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.oa.toa;

import com.sun.corba.ee.impl.misc.ORBUtility;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedData;

@ManagedData
@Description(value="A single element mapping one ObjectId to a Servant")
final class Element {
    Object servant = null;
    Object servantData = null;
    int index = -1;
    int counter = 0;
    boolean valid = false;

    @ManagedAttribute
    @Description(value="The servant")
    private synchronized Object getServant() {
        return this.servant;
    }

    @ManagedAttribute
    @Description(value="The servant data")
    private synchronized Object getServantData() {
        return this.servantData;
    }

    @ManagedAttribute
    @Description(value="The reuse counter")
    private synchronized int getReuseCounter() {
        return this.counter;
    }

    @ManagedAttribute
    @Description(value="The index of this entry")
    private synchronized int getIndex() {
        return this.index;
    }

    Element(int i, Object next) {
        this.servant = next;
        this.index = i;
    }

    byte[] getKey(Object servant, Object servantData) {
        this.servant = servant;
        this.servantData = servantData;
        this.valid = true;
        return this.toBytes();
    }

    byte[] toBytes() {
        byte[] key = new byte[8];
        ORBUtility.intToBytes(this.index, key, 0);
        ORBUtility.intToBytes(this.counter, key, 4);
        return key;
    }

    void delete(Element freeList) {
        if (!this.valid) {
            return;
        }
        ++this.counter;
        this.servantData = null;
        this.valid = false;
        this.servant = freeList;
    }

    public String toString() {
        return "Element[" + this.index + ", " + this.counter + "]";
    }
}

