/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.impl;

import com.ibm.jbatch.container.IThreadRootController;
import com.ibm.jbatch.container.callback.IJobEndCallbackService;
import com.ibm.jbatch.container.exception.BatchContainerServiceException;
import com.ibm.jbatch.container.jobinstance.JobExecutionHelper;
import com.ibm.jbatch.container.jobinstance.RuntimeFlowInSplitExecution;
import com.ibm.jbatch.container.jobinstance.RuntimeJobExecution;
import com.ibm.jbatch.container.services.IBatchKernelService;
import com.ibm.jbatch.container.services.IJobExecution;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.services.impl.NoOpBatchSecurityHelper;
import com.ibm.jbatch.container.services.impl.RuntimeBatchJobUtil;
import com.ibm.jbatch.container.servicesmanager.ServicesManager;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerImpl;
import com.ibm.jbatch.container.util.BatchFlowInSplitWorkUnit;
import com.ibm.jbatch.container.util.BatchPartitionWorkUnit;
import com.ibm.jbatch.container.util.BatchWorkUnit;
import com.ibm.jbatch.container.util.FlowInSplitBuilderConfig;
import com.ibm.jbatch.container.util.PartitionsBuilderConfig;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.jbatch.spi.BatchJobUtil;
import com.ibm.jbatch.spi.BatchSPIManager;
import com.ibm.jbatch.spi.BatchSecurityHelper;
import com.ibm.jbatch.spi.services.IBatchConfig;
import com.ibm.jbatch.spi.services.IBatchThreadPoolService;
import com.ibm.jbatch.spi.services.ParallelTaskResult;
import jakarta.batch.operations.JobExecutionAlreadyCompleteException;
import jakarta.batch.operations.JobExecutionNotMostRecentException;
import jakarta.batch.operations.JobExecutionNotRunningException;
import jakarta.batch.operations.JobRestartException;
import jakarta.batch.operations.JobStartException;
import jakarta.batch.operations.NoSuchJobExecutionException;
import jakarta.batch.runtime.JobInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BatchKernelImpl
implements IBatchKernelService {
    private static final String sourceClass = BatchKernelImpl.class.getName();
    private static final Logger logger = Logger.getLogger(sourceClass);
    private Map<Long, IThreadRootController> executionId2jobControllerMap = new ConcurrentHashMap<Long, IThreadRootController>();
    private Set<Long> instanceIdExecutingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    ServicesManager servicesManager = ServicesManagerImpl.getInstance();
    private IBatchThreadPoolService executorService = this.servicesManager.getThreadPoolService();
    private IJobEndCallbackService callbackService = this.servicesManager.getJobCallbackService();
    private IPersistenceManagerService persistenceService = this.servicesManager.getPersistenceManagerService();
    private BatchSecurityHelper batchSecurity = null;
    private BatchJobUtil batchJobUtil = new RuntimeBatchJobUtil();

    public BatchKernelImpl() {
        BatchSPIManager.getInstance().registerBatchJobUtil(this.batchJobUtil);
    }

    @Override
    public BatchSecurityHelper getBatchSecurityHelper() {
        this.batchSecurity = BatchSPIManager.getInstance().getBatchSecurityHelper();
        if (this.batchSecurity == null) {
            this.batchSecurity = new NoOpBatchSecurityHelper();
        }
        return this.batchSecurity;
    }

    @Override
    public void init(IBatchConfig pgcConfig) throws BatchContainerServiceException {
    }

    @Override
    public void shutdown() throws BatchContainerServiceException {
    }

    @Override
    public IJobExecution startJob(String jobXML) throws JobStartException {
        return this.startJob(jobXML, null);
    }

    @Override
    public IJobExecution startJob(String jobXML, Properties jobParameters) throws JobStartException {
        String method = "startJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{jobXML, jobParameters != null ? jobParameters : "<null>"});
        }
        RuntimeJobExecution jobExecution = JobExecutionHelper.startJob(jobXML, jobParameters);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void stopJob(long executionId) throws NoSuchJobExecutionException, JobExecutionNotRunningException {
        IThreadRootController controller = this.executionId2jobControllerMap.get(executionId);
        if (controller == null) {
            String msg = "JobExecution with execution id of " + executionId + "is not running.";
            logger.warning("stopJob(): " + msg);
            throw new JobExecutionNotRunningException(msg);
        }
        controller.stop();
    }

    @Override
    public IJobExecution restartJob(long executionId) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        Properties dummyPropObj = new Properties();
        return this.restartJob(executionId, dummyPropObj);
    }

    @Override
    public IJobExecution restartJob(long executionId, Properties jobOverrideProps) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException, NoSuchJobExecutionException {
        String method = "restartJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method);
        }
        RuntimeJobExecution jobExecution = JobExecutionHelper.restartJob(executionId, jobOverrideProps);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchWorkUnit batchWork = new BatchWorkUnit(this, jobExecution);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        this.executorService.executeTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, jobExecution);
        }
        return jobExecution.getJobOperatorJobExecution();
    }

    @Override
    public void jobExecutionDone(RuntimeJobExecution jobExecution) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution done with batchStatus: " + jobExecution.getBatchStatus() + " , getting ready to invoke callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.callbackService.done(jobExecution.getExecutionId());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Done invoking callbacks for JobExecution: " + jobExecution.getExecutionId());
        }
        this.executionId2jobControllerMap.remove(jobExecution.getExecutionId());
        this.instanceIdExecutingSet.remove(jobExecution.getInstanceId());
    }

    @Override
    public IJobExecution getJobExecution(long executionId) throws NoSuchJobExecutionException {
        logger.finest("Entering " + sourceClass + ".getJobExecution(), executionId = " + executionId);
        IJobExecution retVal = JobExecutionHelper.getPersistedJobOperatorJobExecution(executionId);
        logger.finest("Exiting " + sourceClass + ".getJobExecution(), retVal = " + retVal);
        return retVal;
    }

    @Override
    public void startGeneratedJob(BatchWorkUnit batchWork) {
        String method = "startGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{batchWork});
        }
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, new Object[]{batchWork});
        }
    }

    @Override
    public int getJobInstanceCount(String jobName) {
        int jobInstanceCount = 0;
        jobInstanceCount = this.persistenceService.jobOperatorGetJobInstanceCount(jobName);
        return jobInstanceCount;
    }

    @Override
    public JobInstance getJobInstance(long executionId) {
        return JobExecutionHelper.getJobInstance(executionId);
    }

    @Override
    public List<BatchPartitionWorkUnit> buildNewParallelPartitions(PartitionsBuilderConfig config) throws JobRestartException, JobStartException {
        List<JSLJob> jobModels = config.getJobModels();
        Properties[] partitionPropertiesArray = config.getPartitionProperties();
        ArrayList<BatchPartitionWorkUnit> batchWorkUnits = new ArrayList<BatchPartitionWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps;
            Properties properties = partitionProps = partitionPropertiesArray == null ? null : partitionPropertiesArray[instance];
            if (logger.isLoggable(Level.FINER)) {
                logger.finer("Starting execution for jobModel = " + parallelJob.toString());
            }
            RuntimeJobExecution jobExecution = JobExecutionHelper.startPartition(parallelJob, partitionProps);
            jobExecution.setPartitionInstance(instance);
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("JobExecution constructed: " + jobExecution);
            }
            BatchPartitionWorkUnit batchWork = new BatchPartitionWorkUnit((IBatchKernelService)this, jobExecution, config);
            this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
            batchWorkUnits.add(batchWork);
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public List<BatchPartitionWorkUnit> buildOnRestartParallelPartitions(PartitionsBuilderConfig config) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        List<JSLJob> jobModels = config.getJobModels();
        Properties[] partitionProperties = config.getPartitionProperties();
        ArrayList<BatchPartitionWorkUnit> batchWorkUnits = new ArrayList<BatchPartitionWorkUnit>(jobModels.size());
        int instance = 0;
        for (JSLJob parallelJob : jobModels) {
            Properties partitionProps = partitionProperties == null ? null : partitionProperties[instance];
            try {
                long execId = this.getMostRecentSubJobExecutionId(parallelJob);
                RuntimeJobExecution jobExecution = null;
                try {
                    jobExecution = JobExecutionHelper.restartPartition(execId, parallelJob, partitionProps);
                    jobExecution.setPartitionInstance(instance);
                }
                catch (NoSuchJobExecutionException e) {
                    String errorMsg = "Caught NoSuchJobExecutionException but this is an internal JobExecution so this shouldn't have happened: execId =" + execId;
                    logger.severe(errorMsg);
                    throw new IllegalStateException(errorMsg, e);
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("JobExecution constructed: " + jobExecution);
                }
                BatchPartitionWorkUnit batchWork = new BatchPartitionWorkUnit((IBatchKernelService)this, jobExecution, config);
                this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
                batchWorkUnits.add(batchWork);
            }
            catch (JobExecutionAlreadyCompleteException e) {
                logger.fine("This execution already completed: " + parallelJob.getId());
            }
            ++instance;
        }
        return batchWorkUnits;
    }

    @Override
    public void restartGeneratedJob(BatchWorkUnit batchWork) throws JobRestartException {
        String method = "restartGeneratedJob";
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, new Object[]{batchWork});
        }
        ParallelTaskResult result = this.executorService.executeParallelTask(batchWork, null);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(sourceClass, method, batchWork);
        }
    }

    @Override
    public BatchFlowInSplitWorkUnit buildNewFlowInSplitWorkUnit(FlowInSplitBuilderConfig config) {
        JSLJob parallelJob = config.getJobModel();
        RuntimeFlowInSplitExecution execution = JobExecutionHelper.startFlowInSplit(parallelJob);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + execution);
        }
        BatchFlowInSplitWorkUnit batchWork = new BatchFlowInSplitWorkUnit((IBatchKernelService)this, execution, config);
        this.registerCurrentInstanceAndExecution(execution, batchWork.getController());
        return batchWork;
    }

    private long getMostRecentSubJobExecutionId(JSLJob jobModel) {
        List<Long> instanceIds = this.persistenceService.jobOperatorGetJobInstanceIds(jobModel.getId(), 0, 1);
        if (instanceIds.size() == 0) {
            String errorMsg = "Did not find an entry for job name = " + jobModel.getId();
            logger.severe(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        List<IJobExecution> subJobExecs = this.persistenceService.jobOperatorGetJobExecutions(instanceIds.get(0));
        Long execId = Long.MIN_VALUE;
        for (IJobExecution subJobExec : subJobExecs) {
            if (subJobExec.getExecutionId() <= execId) continue;
            execId = subJobExec.getExecutionId();
        }
        return execId;
    }

    @Override
    public BatchFlowInSplitWorkUnit buildOnRestartFlowInSplitWorkUnit(FlowInSplitBuilderConfig config) throws JobRestartException, JobExecutionAlreadyCompleteException, JobExecutionNotMostRecentException {
        String method = "buildOnRestartFlowInSplitWorkUnit";
        JSLJob jobModel = config.getJobModel();
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(sourceClass, method, jobModel);
        }
        long execId = this.getMostRecentSubJobExecutionId(jobModel);
        RuntimeFlowInSplitExecution jobExecution = null;
        try {
            jobExecution = JobExecutionHelper.restartFlowInSplit(execId, jobModel);
        }
        catch (NoSuchJobExecutionException e) {
            String errorMsg = "Caught NoSuchJobExecutionException but this is an internal JobExecution so this shouldn't have happened: execId =" + execId;
            logger.severe(errorMsg);
            throw new IllegalStateException(errorMsg, e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("JobExecution constructed: " + jobExecution);
        }
        BatchFlowInSplitWorkUnit batchWork = new BatchFlowInSplitWorkUnit((IBatchKernelService)this, jobExecution, config);
        this.registerCurrentInstanceAndExecution(jobExecution, batchWork.getController());
        return batchWork;
    }

    private void registerCurrentInstanceAndExecution(RuntimeJobExecution jobExecution, IThreadRootController controller) {
        long execId = jobExecution.getExecutionId();
        long instanceId = jobExecution.getInstanceId();
        String errorPrefix = "Tried to execute with Job executionId = " + execId + " and instanceId = " + instanceId + " ";
        if (this.executionId2jobControllerMap.get(execId) != null) {
            String errorMsg = errorPrefix + "but executionId is already currently executing.";
            logger.warning(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        if (this.instanceIdExecutingSet.contains(instanceId)) {
            String errorMsg = errorPrefix + "but another execution with this instanceId is already currently executing.";
            logger.warning(errorMsg);
            throw new IllegalStateException(errorMsg);
        }
        this.instanceIdExecutingSet.add(instanceId);
        this.executionId2jobControllerMap.put(jobExecution.getExecutionId(), controller);
    }

    @Override
    public boolean isExecutionRunning(long executionId) {
        return this.executionId2jobControllerMap.containsKey(executionId);
    }
}

