/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.auth.message.config;

import jakarta.security.auth.message.config.AuthConfigProvider;
import jakarta.security.auth.message.config.RegistrationListener;
import jakarta.security.auth.message.module.ServerAuthModule;
import java.security.Security;
import java.util.Map;

public abstract class AuthConfigFactory {
    private static AuthConfigFactory factory;
    public static final String DEFAULT_FACTORY_SECURITY_PROPERTY = "authconfigprovider.factory";

    public static synchronized AuthConfigFactory getFactory() {
        String className;
        if (factory == null && (className = Security.getProperty(DEFAULT_FACTORY_SECURITY_PROPERTY)) != null) {
            try {
                factory = (AuthConfigFactory)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException pae) {
                throw new SecurityException(pae);
            }
        }
        return factory;
    }

    public static synchronized void setFactory(AuthConfigFactory factory) {
        AuthConfigFactory.factory = factory;
    }

    public abstract AuthConfigProvider getConfigProvider(String var1, String var2, RegistrationListener var3);

    public abstract String registerConfigProvider(String var1, Map<String, String> var2, String var3, String var4, String var5);

    public abstract String registerConfigProvider(AuthConfigProvider var1, String var2, String var3, String var4);

    public abstract String registerServerAuthModule(ServerAuthModule var1, Object var2);

    public abstract void removeServerAuthModule(Object var1);

    public abstract boolean removeRegistration(String var1);

    public abstract String[] detachListener(RegistrationListener var1, String var2, String var3);

    public abstract String[] getRegistrationIDs(AuthConfigProvider var1);

    public abstract RegistrationContext getRegistrationContext(String var1);

    public abstract void refresh();

    public static interface RegistrationContext {
        public String getMessageLayer();

        public String getAppContext();

        public String getDescription();

        public boolean isPersistent();
    }
}

