/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.iiop;

import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.util.Hashtable;
import java.util.Vector;
import org.glassfish.rmic.iiop.BatchEnvironment;
import org.glassfish.rmic.iiop.ClassType;
import org.glassfish.rmic.iiop.CompoundType;
import org.glassfish.rmic.iiop.ContextStack;
import org.glassfish.rmic.iiop.InterfaceType;
import org.glassfish.rmic.iiop.Type;
import org.glassfish.rmic.tools.java.ClassDeclaration;
import org.glassfish.rmic.tools.java.ClassDefinition;
import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.MemberDefinition;

public class ValueType
extends ClassType {
    private boolean isCustom = false;

    public static ValueType forValue(ClassDefinition classDef, ContextStack stack, boolean quiet) {
        if (stack.anyErrors()) {
            return null;
        }
        org.glassfish.rmic.tools.java.Type theType = classDef.getType();
        String typeKey = theType.toString();
        Type existing = ValueType.getType(typeKey, stack);
        if (existing != null) {
            if (!(existing instanceof ValueType)) {
                return null;
            }
            return (ValueType)existing;
        }
        boolean javaLangClass = false;
        if (classDef.getClassDeclaration().getName() == idJavaLangClass) {
            javaLangClass = true;
            BatchEnvironment env = stack.getEnv();
            ClassDeclaration decl = env.getClassDeclaration(idClassDesc);
            ClassDefinition def = null;
            try {
                def = decl.getClassDefinition(env);
            }
            catch (ClassNotFound ex) {
                ValueType.classNotFound(stack, ex);
                return null;
            }
            classDef = def;
        }
        if (ValueType.couldBeValue(stack, classDef)) {
            ValueType it = new ValueType(classDef, stack, javaLangClass);
            ValueType.putType(typeKey, (Type)it, stack);
            stack.push(it);
            if (it.initialize(stack, quiet)) {
                stack.pop(true);
                return it;
            }
            ValueType.removeType(typeKey, stack);
            stack.pop(false);
            return null;
        }
        return null;
    }

    @Override
    public String getTypeDescription() {
        String result = this.addExceptionDescription("Value");
        if (this.isCustom) {
            result = "Custom " + result;
        }
        if (this.isIDLEntity) {
            result = result + " [IDLEntity]";
        }
        return result;
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    private ValueType(ClassDefinition classDef, ContextStack stack, boolean isMappedJavaLangClass) {
        super(stack, classDef, 0x6008000);
        if (isMappedJavaLangClass) {
            this.setNames(idJavaLangClass, IDL_CLASS_MODULE, "ClassDesc");
        }
    }

    private static boolean couldBeValue(ContextStack stack, ClassDefinition classDef) {
        boolean result = false;
        ClassDeclaration classDecl = classDef.getClassDeclaration();
        BatchEnvironment env = stack.getEnv();
        try {
            if (env.defRemote.implementedBy(env, classDecl)) {
                ValueType.failedConstraint(10, false, stack, classDef.getName());
            } else if (!env.defSerializable.implementedBy(env, classDecl)) {
                ValueType.failedConstraint(11, false, stack, classDef.getName());
            } else {
                result = true;
            }
        }
        catch (ClassNotFound e) {
            ValueType.classNotFound(stack, e);
        }
        return result;
    }

    private boolean initialize(ContextStack stack, boolean quiet) {
        ClassDefinition ourDef = this.getClassDefinition();
        ClassDeclaration ourDecl = this.getClassDeclaration();
        try {
            if (!this.initParents(stack)) {
                ValueType.failedConstraint(12, quiet, stack, this.getQualifiedName());
                return false;
            }
            Vector<InterfaceType> directInterfaces = new Vector<InterfaceType>();
            Vector<CompoundType.Method> directMethods = new Vector<CompoundType.Method>();
            Vector<CompoundType.Member> directMembers = new Vector<CompoundType.Member>();
            if (this.addNonRemoteInterfaces(directInterfaces, stack) != null && this.addAllMethods(ourDef, directMethods, false, false, stack) != null && this.updateParentClassMethods(ourDef, directMethods, false, stack) != null) {
                if (this.addAllMembers(directMembers, false, false, stack)) {
                    if (!this.initialize(directInterfaces, directMethods, directMembers, stack, quiet)) {
                        return false;
                    }
                    boolean externalizable = false;
                    if (!this.env.defExternalizable.implementedBy(this.env, ourDecl)) {
                        if (!this.checkPersistentFields(this.getClassInstance(), quiet)) {
                            return false;
                        }
                    } else {
                        externalizable = true;
                    }
                    if (externalizable) {
                        this.isCustom = true;
                    } else {
                        for (MemberDefinition member = ourDef.getFirstMember(); member != null; member = member.getNextMember()) {
                            org.glassfish.rmic.tools.java.Type[] args;
                            org.glassfish.rmic.tools.java.Type methodType;
                            org.glassfish.rmic.tools.java.Type rtnType;
                            if (!member.isMethod() || member.isInitializer() || !member.isPrivate() || !member.getName().toString().equals("writeObject") || (rtnType = (methodType = member.getType()).getReturnType()) != org.glassfish.rmic.tools.java.Type.tVoid || (args = methodType.getArgumentTypes()).length != 1 || !args[0].getTypeSignature().equals("Ljava/io/ObjectOutputStream;")) continue;
                            this.isCustom = true;
                        }
                    }
                }
                return true;
            }
        }
        catch (ClassNotFound e) {
            ValueType.classNotFound(stack, e);
        }
        return false;
    }

    private boolean checkPersistentFields(Class<?> clz, boolean quiet) {
        for (CompoundType.Method method : this.methods) {
            if (!method.getName().equals("writeObject") || method.getArguments().length != 1) continue;
            Type returnType = method.getReturnType();
            Type arg = method.getArguments()[0];
            String id = arg.getQualifiedName();
            if (!returnType.isType(1) || !id.equals("java.io.ObjectOutputStream")) continue;
            return true;
        }
        MemberDefinition spfDef = null;
        for (CompoundType.Member member1 : this.members) {
            CompoundType.Member member;
            Type type;
            Type elementType;
            if (!member1.getName().equals("serialPersistentFields") || (elementType = (type = (member = member1).getType()).getElementType()) == null || !elementType.getQualifiedName().equals("java.io.ObjectStreamField")) continue;
            if (member.isStatic() && member.isFinal() && member.isPrivate()) {
                spfDef = member.getMemberDefinition();
                continue;
            }
            ValueType.failedConstraint(4, quiet, this.stack, this.getQualifiedName());
            return false;
        }
        if (spfDef == null) {
            return true;
        }
        Hashtable<String, String> fields = this.getPersistentFields(clz);
        boolean result = true;
        for (CompoundType.Member member : this.members) {
            String fieldName = member.getName();
            String fieldType = member.getType().getSignature();
            String type = fields.get(fieldName);
            if (type == null) {
                member.setTransient();
                continue;
            }
            if (type.equals(fieldType)) {
                fields.remove(fieldName);
                continue;
            }
            result = false;
            ValueType.failedConstraint(2, quiet, this.stack, fieldName, this.getQualifiedName());
        }
        return result;
    }

    private Hashtable<String, String> getPersistentFields(Class<?> clz) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ObjectStreamClass osc = ObjectStreamClass.lookup(clz);
        if (osc != null) {
            ObjectStreamField[] fields;
            for (ObjectStreamField field : fields = osc.getFields()) {
                String typeSig;
                String typePrefix = String.valueOf(field.getTypeCode());
                if (field.isPrimitive()) {
                    typeSig = typePrefix;
                } else {
                    if (field.getTypeCode() == '[') {
                        typePrefix = "";
                    }
                    if ((typeSig = typePrefix + field.getType().getName().replace('.', '/')).endsWith(";")) {
                        typeSig = typeSig.substring(0, typeSig.length() - 1);
                    }
                }
                result.put(field.getName(), typeSig);
            }
        }
        return result;
    }
}

