/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionBroker;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.TransactionAckExistException;
import com.sun.messaging.jmq.util.UID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;

class TransactionInformation {
    int type = 0;
    ArrayList published;
    LinkedHashMap consumed;
    LinkedHashMap removedConsumedRBD;
    LinkedHashMap removedConsumedRRT;
    TransactionState state;
    HashMap cuidToStored;
    HashMap sysidToAddr;
    LinkedHashMap orphanedMessages;
    TransactionUID tid = null;
    boolean inROLLBACK = false;
    TransactionBroker[] brokers = null;
    boolean processed = false;
    private ReentrantLock takeoverLock = new ReentrantLock();

    TransactionInformation(TransactionUID tid, TransactionState state) {
        this.published = new ArrayList();
        this.consumed = new LinkedHashMap();
        this.removedConsumedRBD = new LinkedHashMap();
        this.removedConsumedRRT = new LinkedHashMap();
        this.cuidToStored = new HashMap();
        this.sysidToAddr = new HashMap();
        this.orphanedMessages = new LinkedHashMap();
        this.state = state;
        this.tid = tid;
        this.type = 1;
    }

    public void getTakeoverLock() {
        this.takeoverLock.lock();
    }

    public void releaseTakeoverLock() {
        this.takeoverLock.unlock();
    }

    public boolean isTakeoverLocked() {
        boolean isTakeoverLocked = this.takeoverLock.isLocked();
        if (isTakeoverLocked && this.takeoverLock.isHeldByCurrentThread()) {
            return false;
        }
        return isTakeoverLocked;
    }

    public synchronized int getType() {
        return this.type;
    }

    public synchronized boolean processed() {
        if (this.processed) {
            return true;
        }
        this.processed = true;
        return false;
    }

    public synchronized boolean isProcessed() {
        return this.processed;
    }

    public synchronized String toString() {
        if (this.type == 2) {
            StringBuilder buf = new StringBuilder();
            buf.append("TransactionInfo[").append(this.tid).append("]cluster - ");
            for (int i = 0; i < this.brokers.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.brokers[i]);
            }
            return buf.toString();
        }
        return "TransactionInfo[" + String.valueOf(this.tid) + "]local";
    }

    public synchronized void addOrphanAck(SysMessageID sysid, ConsumerUID sid) {
        this.addOrphanAck(sysid, sid, null);
    }

    public synchronized void addOrphanAck(SysMessageID sysid, ConsumerUID sid, ConsumerUID cid) {
        ArrayList<ConsumerUID> l;
        LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>> m = (LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>>)this.orphanedMessages.get(sysid);
        if (m == null) {
            m = new LinkedHashMap<ConsumerUID, ArrayList<ConsumerUID>>();
            this.orphanedMessages.put(sysid, m);
        }
        if ((l = (ArrayList<ConsumerUID>)m.get(sid)) == null) {
            l = new ArrayList<ConsumerUID>();
            m.put(sid, l);
        }
        if (cid != null) {
            l.add(cid);
        }
    }

    public synchronized void removeOrphanAck(SysMessageID sysid, ConsumerUID sid, ConsumerUID cid) {
        Map m = (Map)this.orphanedMessages.get(sysid);
        if (m == null) {
            return;
        }
        if (cid == null) {
            m.remove(sid);
            if (m.size() == 0) {
                this.orphanedMessages.remove(sysid);
            }
            return;
        }
        List l = (List)m.get(sid);
        if (l == null) {
            return;
        }
        l.remove(cid);
    }

    public synchronized Map getOrphanAck() {
        return this.orphanedMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getDebugState() {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        TransactionInformation transactionInformation = this;
        synchronized (transactionInformation) {
            Vector<String> v;
            int i;
            Vector<String> v2;
            ArrayList ids;
            String id;
            Hashtable<String, Object> m;
            ht.put("state", this.state.getDebugState());
            ht.put("inROLLBACK", this.inROLLBACK);
            ht.put("processed", String.valueOf(this.processed));
            ht.put("consumed#", this.consumed.size());
            ht.put("removedConsumedRBD#", this.removedConsumedRBD.size());
            ht.put("removedConsumedRRT#", this.removedConsumedRRT.size());
            ht.put("published#", this.published.size());
            ht.put("cuidToStored#", this.cuidToStored.size());
            if (this.cuidToStored.size() > 0) {
                Hashtable<String, String> cid = new Hashtable<String, String>();
                for (Map.Entry me : ht.entrySet()) {
                    cid.put(me.getKey().toString(), me.getValue().toString());
                }
                ht.put("cuidToStored", cid);
            }
            if (this.consumed.size() > 0) {
                m = new Hashtable<String, Object>();
                for (Map.Entry me : this.consumed.entrySet()) {
                    id = me.getKey().toString();
                    ids = (ArrayList)me.getValue();
                    if (ids.size() == 0) continue;
                    if (ids.size() == 1) {
                        m.put(id, ids.get(0).toString());
                        continue;
                    }
                    v2 = new Vector<String>();
                    for (i = 0; i < ids.size(); ++i) {
                        v2.add(ids.get(i).toString());
                    }
                    m.put(id, v2);
                }
                if (m.size() > 0) {
                    ht.put("consumed", m);
                }
            }
            if (this.removedConsumedRBD.size() > 0) {
                m = new Hashtable();
                for (Map.Entry me : this.removedConsumedRBD.entrySet()) {
                    id = me.getKey().toString();
                    ids = (ArrayList)me.getValue();
                    if (ids.size() == 0) continue;
                    if (ids.size() == 1) {
                        m.put(id, ids.get(0).toString());
                        continue;
                    }
                    v2 = new Vector();
                    for (i = 0; i < ids.size(); ++i) {
                        v2.add(ids.get(i).toString());
                    }
                    m.put(id, v2);
                }
                if (m.size() > 0) {
                    ht.put("removedConsumedRBD", m);
                }
            }
            if (this.removedConsumedRRT.size() > 0) {
                m = new Hashtable();
                for (Map.Entry me : this.removedConsumedRRT.entrySet()) {
                    id = me.getKey().toString();
                    ids = (ArrayList)me.getValue();
                    if (ids.size() == 0) continue;
                    if (ids.size() == 1) {
                        m.put(id, ids.get(0).toString());
                        continue;
                    }
                    v2 = new Vector();
                    for (i = 0; i < ids.size(); ++i) {
                        v2.add(ids.get(i).toString());
                    }
                    m.put(id, v2);
                }
                if (m.size() > 0) {
                    ht.put("removedConsumedRRT", m);
                }
            }
            if (this.published.size() > 0) {
                v = new Vector<String>();
                for (int i2 = 0; i2 < this.published.size(); ++i2) {
                    v.add(this.published.get(i2).toString());
                }
                ht.put("published", v);
            }
            if (this.type == 2) {
                v = new Vector();
                for (int i3 = 0; i3 < this.brokers.length; ++i3) {
                    v.add(this.brokers[i3].toString());
                }
                ht.put("brokers", v);
            }
        }
        return ht;
    }

    public synchronized List getPublishedMessages() {
        return this.published;
    }

    public synchronized int getNPublishedMessages() {
        if (this.published != null) {
            return this.published.size();
        }
        return 0;
    }

    public synchronized LinkedHashMap getConsumedMessages(boolean inrollback) {
        this.inROLLBACK = inrollback;
        return this.consumed;
    }

    public synchronized HashMap getStoredConsumerUIDs() {
        return this.cuidToStored;
    }

    public synchronized int getNConsumedMessages() {
        if (this.consumed != null) {
            return this.consumed.size();
        }
        return 0;
    }

    public synchronized TransactionState getState() {
        return this.state;
    }

    public synchronized void addPublishedMessage(SysMessageID id) throws BrokerException {
        if (this.published.size() >= TransactionList.defaultProducerMaxMsgCnt) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4303", TransactionList.defaultProducerMaxMsgCnt, this.tid), "B4303", null, 414);
        }
        this.published.add(id);
    }

    public synchronized boolean checkConsumedMessage(SysMessageID sysid, ConsumerUID id) {
        List l = (List)this.consumed.get(sysid);
        if (l == null) {
            return false;
        }
        return l.contains(id);
    }

    public synchronized boolean isConsumedMessage(SysMessageID sysid, ConsumerUID id) {
        if (this.state == null) {
            return false;
        }
        if (this.state.getState() == 7) {
            return false;
        }
        if (this.inROLLBACK) {
            return false;
        }
        List l = (List)this.consumed.get(sysid);
        if (l == null) {
            return false;
        }
        return l.contains(id);
    }

    public synchronized void addConsumedMessage(SysMessageID sysid, ConsumerUID id, ConsumerUID sid) throws BrokerException {
        ArrayList<ConsumerUID> l;
        if (this.consumed.size() < TransactionList.defaultConsumerMaxMsgCnt) {
            l = (ArrayList<ConsumerUID>)this.consumed.get(sysid);
            if (l == null) {
                l = new ArrayList<ConsumerUID>();
                this.consumed.put(sysid, l);
            } else if (l.contains(id)) {
                BrokerResources brokerResources = Globals.getBrokerResources();
                Globals.getBrokerResources();
                throw new TransactionAckExistException(brokerResources.getKString("B4273", "[" + String.valueOf(sysid) + ":" + String.valueOf(id) + "," + String.valueOf(sid) + "]", this.tid), 409);
            }
        } else {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4304", TransactionList.defaultConsumerMaxMsgCnt, this.tid), "B4304", null, 414);
        }
        l.add(id);
        this.cuidToStored.put(id, sid);
    }

    public synchronized void setAckBrokerAddress(SysMessageID sysid, ConsumerUID id, BrokerAddress addr) throws BrokerException {
        BrokerAddress ba = (BrokerAddress)this.sysidToAddr.get(sysid);
        if (!(ba == null || ba.equals(addr) && ba.getBrokerSessionUID().equals((Object)addr.getBrokerSessionUID()))) {
            BrokerException bex = new BrokerException("Message requeued:" + String.valueOf(sysid), 410);
            bex.setRemoteConsumerUIDs(String.valueOf(id.longValue()));
            bex.setRemote(true);
            throw bex;
        }
        this.sysidToAddr.put(sysid, addr);
    }

    public synchronized BrokerAddress getAckBrokerAddress(SysMessageID sysid, ConsumerUID id) {
        return (BrokerAddress)this.sysidToAddr.get(sysid);
    }

    public synchronized HashMap getAckBrokerAddresses() {
        return this.sysidToAddr;
    }

    public TransactionUID getTID() {
        return this.tid;
    }

    public synchronized ConsumerUID removeConsumedMessage(SysMessageID sysid, ConsumerUID id, boolean rerouted) throws BrokerException {
        List<ConsumerUID> l = (ArrayList<ConsumerUID>)this.consumed.get(sysid);
        if (l == null) {
            throw new BrokerException(Globals.getBrokerResources().getKString("B4302", "[" + String.valueOf(sysid) + "," + String.valueOf(id) + "]", this.tid.toString()));
        }
        l.remove(id);
        if (l.size() == 0) {
            this.consumed.remove(sysid);
        }
        if (!rerouted) {
            l = (List)this.removedConsumedRBD.get(sysid);
            if (l == null) {
                l = new ArrayList<ConsumerUID>();
                this.removedConsumedRBD.put(sysid, l);
            }
            l.add(id);
        } else {
            l = (List)this.removedConsumedRRT.get(sysid);
            if (l == null) {
                l = new ArrayList();
                this.removedConsumedRRT.put(sysid, l);
            }
            l.add(id);
        }
        return (ConsumerUID)this.cuidToStored.get(id);
    }

    public synchronized LinkedHashMap getRemovedConsumedMessages(boolean rerouted) {
        if (!rerouted) {
            return this.removedConsumedRBD;
        }
        return this.removedConsumedRRT;
    }

    public synchronized void setClusterTransactionBrokers(TransactionBroker[] brokers) {
        this.brokers = brokers;
        this.type = 2;
    }

    public synchronized TransactionBroker[] getClusterTransactionBrokers() {
        return this.brokers;
    }

    public synchronized boolean isClusterTransactionBrokersCompleted() {
        boolean completed = true;
        for (int j = 0; j < this.brokers.length; ++j) {
            if (this.brokers[j].isCompleted()) continue;
            completed = false;
            break;
        }
        return completed;
    }

    public synchronized TransactionBroker getClusterTransactionBroker(BrokerAddress b) {
        if (this.brokers == null) {
            return null;
        }
        TransactionBroker tba = new TransactionBroker(b);
        for (int i = 0; i < this.brokers.length; ++i) {
            if (!this.brokers[i].equals(tba)) continue;
            return this.brokers[i];
        }
        return null;
    }

    public synchronized boolean isClusterTransactionBroker(UID ssid) {
        if (this.brokers == null) {
            return false;
        }
        for (int i = 0; i < this.brokers.length; ++i) {
            if (!this.brokers[i].isSame(ssid)) continue;
            return true;
        }
        return false;
    }
}

