/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.DataExpression;
import org.eclipse.persistence.internal.expressions.ExpressionNormalizer;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;

public class TableExpression
extends DataExpression {
    protected DatabaseTable table;

    public TableExpression() {
    }

    public TableExpression(DatabaseTable table) {
        this.table = table;
    }

    @Override
    protected void assignAlias(DatabaseTable alias, DatabaseTable table) {
        if (this.baseExpression.isQueryKeyExpression()) {
            QueryKeyExpression qkExpression = (QueryKeyExpression)this.baseExpression;
            if (!qkExpression.hasQueryKey && qkExpression.getTableAliases() != null && qkExpression.getTableAliases().keyAtValue(table) != null) {
                return;
            }
        }
        super.assignAlias(alias, table);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TableExpression expression = (TableExpression)object;
        return Objects.equals(this.table, expression.table);
    }

    @Override
    public int computeHashCode() {
        int hashCode = super.computeHashCode();
        if (this.getTable() != null) {
            hashCode += this.getTable().hashCode();
        }
        return hashCode;
    }

    @Override
    public String descriptionOfNodeType() {
        return "Table";
    }

    @Override
    public Expression getField(String fieldName) {
        DatabaseField field = new DatabaseField(fieldName);
        if (!field.hasTableName()) {
            field.setTable(this.getTable());
        }
        return this.getField(field);
    }

    @Override
    public List<DatabaseTable> getOwnedTables() {
        ArrayList<DatabaseTable> result = new ArrayList<DatabaseTable>(1);
        result.add(this.getTable());
        return result;
    }

    public DatabaseTable getTable() {
        return this.table;
    }

    @Override
    public boolean isTableExpression() {
        return true;
    }

    @Override
    public Expression normalize(ExpressionNormalizer normalizer) {
        if (this.hasBeenNormalized) {
            return this;
        }
        if (this.getTable().getTableQualifier().isEmpty() && !normalizer.getSession().getDatasourceLogin().getTableQualifier().isEmpty()) {
            this.getTable().setTableQualifier(normalizer.getSession().getDatasourceLogin().getTableQualifier());
        }
        return super.normalize(normalizer);
    }

    @Override
    public Expression rebuildOn(Expression newBase) {
        Expression newLocalBase = this.getBaseExpression().rebuildOn(newBase);
        return newLocalBase.getTable(this.getTable());
    }

    public void setTable(DatabaseTable table) {
        this.table = table;
    }

    @Override
    public Expression twistedForBaseAndContext(Expression newBase, Expression context, Expression oldBase) {
        Expression twistedBase = this.getBaseExpression().twistedForBaseAndContext(newBase, context, oldBase);
        return twistedBase.getTable(this.getTable());
    }

    @Override
    public void writeDescriptionOn(BufferedWriter writer) throws IOException {
        writer.write(this.getTable().toString());
        writer.write(this.tableAliasesDescription());
    }
}

