/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.jpql;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.jpa.jpql.Declaration;
import org.eclipse.persistence.internal.jpa.jpql.DeclarationResolver;
import org.eclipse.persistence.internal.jpa.jpql.JPQLQueryContext;
import org.eclipse.persistence.jpa.jpql.ExpressionTools;
import org.eclipse.persistence.jpa.jpql.ITypeHelper;
import org.eclipse.persistence.jpa.jpql.JPQLQueryDeclaration;
import org.eclipse.persistence.jpa.jpql.SemanticValidatorHelper;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.IdentificationVariable;
import org.eclipse.persistence.jpa.jpql.parser.JPQLGrammar;
import org.eclipse.persistence.jpa.jpql.parser.SimpleSelectStatement;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.EmbeddableMapping;
import org.eclipse.persistence.mappings.querykeys.QueryKey;

final class EclipseLinkSemanticValidatorHelper
implements SemanticValidatorHelper {
    private final JPQLQueryContext queryContext;

    EclipseLinkSemanticValidatorHelper(JPQLQueryContext queryContext) {
        this.queryContext = queryContext;
    }

    private void addIdentificationVariable(IdentificationVariable identificationVariable, Map<String, List<IdentificationVariable>> identificationVariables) {
        String variableName;
        String string = variableName = identificationVariable != null ? identificationVariable.getVariableName() : null;
        if (ExpressionTools.stringIsNotEmpty((CharSequence)variableName)) {
            List variables = identificationVariables.computeIfAbsent(variableName, k -> new ArrayList());
            variables.add(identificationVariable);
        }
    }

    public void collectAllDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        for (JPQLQueryContext currentContext = this.queryContext.getCurrentContext(); currentContext != null; currentContext = currentContext.getActualParent()) {
            this.collectLocalDeclarationIdentificationVariables(currentContext, identificationVariables);
        }
    }

    private void collectLocalDeclarationIdentificationVariables(JPQLQueryContext queryContext, Map<String, List<IdentificationVariable>> identificationVariables) {
        DeclarationResolver declarationResolver = queryContext.getDeclarationResolverImp();
        for (Declaration declaration : declarationResolver.getDeclarations()) {
            IdentificationVariable identificationVariable = declaration.identificationVariable;
            this.addIdentificationVariable(identificationVariable, identificationVariables);
        }
        for (IdentificationVariable identificationVariable : declarationResolver.getResultVariables()) {
            this.addIdentificationVariable(identificationVariable, identificationVariables);
        }
    }

    public void collectLocalDeclarationIdentificationVariables(Map<String, List<IdentificationVariable>> identificationVariables) {
        this.collectLocalDeclarationIdentificationVariables(this.queryContext, identificationVariables);
    }

    public void disposeSubqueryContext() {
        this.queryContext.disposeSubqueryContext();
    }

    public String[] entityNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (ClassDescriptor descriptor : this.queryContext.getSession().getDescriptors().values()) {
            if (descriptor.isAggregateDescriptor()) continue;
            String name = descriptor.getAlias();
            if (ExpressionTools.stringIsEmpty((CharSequence)name)) {
                name = descriptor.getJavaClass().getSimpleName();
            }
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    public List<JPQLQueryDeclaration> getAllDeclarations() {
        ArrayList<JPQLQueryDeclaration> declarations = new ArrayList<JPQLQueryDeclaration>();
        for (JPQLQueryContext context = this.queryContext.getCurrentContext(); context != null; context = context.getActualParent()) {
            declarations.addAll(context.getDeclarationResolverImp().getDeclarations());
        }
        return declarations;
    }

    public Object[] getConstructors(Object type) {
        return type != null ? ((Class)type).getDeclaredConstructors() : ExpressionTools.EMPTY_ARRAY;
    }

    public List<? extends JPQLQueryDeclaration> getDeclarations() {
        return this.queryContext.getDeclarations();
    }

    public ClassDescriptor getEmbeddable(Object type) {
        ClassDescriptor descriptor = this.queryContext.getDescriptor((Class)type);
        if (descriptor != null && descriptor.isAggregateDescriptor()) {
            return descriptor;
        }
        return null;
    }

    public ClassDescriptor getEntityNamed(String entityName) {
        return this.queryContext.getDescriptor(entityName);
    }

    public String[] getEnumConstants(Object type) {
        Enum[] constants = (Enum[])((Class)type).getEnumConstants();
        String[] names = new String[constants.length];
        int index = constants.length;
        while (--index >= 0) {
            names[index] = constants[index].name();
        }
        return names;
    }

    public JPQLGrammar getGrammar() {
        return this.queryContext.getGrammar();
    }

    public Object getManagedType(Expression expression) {
        return this.queryContext.resolveDescriptor(expression);
    }

    public Object getReferenceManagedType(Object mapping) {
        if (mapping == null) {
            return null;
        }
        return ((DatabaseMapping)mapping).getReferenceDescriptor();
    }

    public Object getMappingNamed(Object entity, String name) {
        ClassDescriptor descriptor = (ClassDescriptor)entity;
        Cloneable mapping = descriptor.getObjectBuilder().getMappingForAttributeName(name);
        if (mapping == null) {
            mapping = descriptor.getQueryKeyNamed(name);
        }
        return mapping;
    }

    public Class<?> getMappingType(Object mapping) {
        if (mapping == null) {
            return null;
        }
        try {
            return this.queryContext.calculateMappingType((DatabaseMapping)mapping);
        }
        catch (ClassCastException e) {
            return this.queryContext.calculateQueryKeyType((QueryKey)mapping);
        }
    }

    public Type[] getMethodParameterTypeDeclarations(Object constructor) {
        return ((Constructor)constructor).getGenericParameterTypes();
    }

    public Class<?> getType(Expression expression) {
        return this.queryContext.getType(expression);
    }

    public Object getType(Object typeDeclaration) {
        return null;
    }

    public Class<?> getType(String className) {
        return this.queryContext.getType(className);
    }

    public Object getTypeDeclaration(Expression expression) {
        return null;
    }

    public ITypeHelper getTypeHelper() {
        return null;
    }

    public String getTypeName(Object type) {
        return ((Class)type).getName();
    }

    public boolean isAssignableTo(Object type1, Object type2) {
        return ((Class)type2).isAssignableFrom((Class)type1);
    }

    public boolean isCollectionIdentificationVariable(String variableName) {
        return this.queryContext.isCollectionIdentificationVariable(variableName);
    }

    public boolean isCollectionMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        try {
            return ((DatabaseMapping)mapping).isCollectionMapping();
        }
        catch (ClassCastException e) {
            return ((QueryKey)mapping).isCollectionQueryKey();
        }
    }

    public boolean isEmbeddableMapping(Object mapping) {
        return mapping instanceof EmbeddableMapping;
    }

    public boolean isEnumType(Object type) {
        return type != null && ((Class)type).isEnum();
    }

    public boolean isIdentificationVariableValidInComparison(IdentificationVariable expression) {
        Declaration declaration = this.queryContext.findDeclaration(expression.getVariableName());
        if (declaration == null) {
            return false;
        }
        DatabaseMapping mapping = declaration.getMapping();
        if (mapping == null) {
            return false;
        }
        return mapping.isDirectCollectionMapping() || mapping.isAbstractCompositeDirectCollectionMapping();
    }

    public boolean isManagedTypeResolvable(Object managedType) {
        return managedType != null;
    }

    public boolean isPropertyMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        try {
            return ((DatabaseMapping)mapping).isDirectToFieldMapping();
        }
        catch (ClassCastException e) {
            return ((QueryKey)mapping).isDirectQueryKey();
        }
    }

    public boolean isRelationshipMapping(Object mapping) {
        if (mapping == null) {
            return false;
        }
        if (mapping instanceof DatabaseMapping) {
            DatabaseMapping databaseMapping = (DatabaseMapping)mapping;
            return databaseMapping.isForeignReferenceMapping() || databaseMapping.isAbstractCompositeCollectionMapping() || databaseMapping.isAbstractCompositeDirectCollectionMapping();
        }
        return ((QueryKey)mapping).isForeignReferenceQueryKey();
    }

    public boolean isResultVariable(String variableName) {
        return this.queryContext.isResultVariable(variableName);
    }

    public boolean isTransient(Object mapping) {
        return mapping == null;
    }

    public boolean isTypeDeclarationAssignableTo(Object typeDeclaration1, Object typeDeclaration2) {
        return false;
    }

    public boolean isTypeResolvable(Object type) {
        return type != null;
    }

    public void newSubqueryContext(SimpleSelectStatement expression) {
        this.queryContext.newSubQueryContext((Expression)expression, null);
    }

    public Object resolveMapping(Expression expression) {
        return this.queryContext.resolveMappingObject(expression);
    }

    public Object resolveMapping(String variableName, String name) {
        Declaration declaration = this.queryContext.findDeclaration(variableName);
        if (declaration == null) {
            return null;
        }
        ClassDescriptor descriptor = declaration.getDescriptor();
        if (descriptor == null) {
            return null;
        }
        Cloneable mapping = descriptor.getObjectBuilder().getMappingForAttributeName(name);
        if (mapping == null) {
            mapping = descriptor.getQueryKeyNamed(name);
        }
        return mapping;
    }
}

