/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.util.ArrayUtil;

abstract class WriteCursorConstantAction
implements ConstantAction,
Formatable {
    long conglomId;
    StaticCompiledOpenConglomInfo heapSCOCI;
    IndexRowGenerator[] irgs;
    long[] indexCIDS;
    StaticCompiledOpenConglomInfo[] indexSCOCIs;
    String[] indexNames;
    boolean deferred;
    private Properties targetProperties;
    UUID targetUUID;
    int lockMode;
    private FKInfo[] fkInfo;
    private TriggerInfo triggerInfo;
    private FormatableBitSet baseRowReadList;
    private int[] baseRowReadMap;
    private int[] streamStorableHeapColIds;
    boolean singleRowSource;
    private boolean underMerge;

    public WriteCursorConstantAction() {
    }

    public WriteCursorConstantAction(long l, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl, Properties properties, UUID uUID, int n, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, FormatableBitSet formatableBitSet, int[] nArray, int[] nArray2, boolean bl2, boolean bl3) {
        this.conglomId = l;
        this.heapSCOCI = staticCompiledOpenConglomInfo;
        this.irgs = indexRowGeneratorArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.indexCIDS = lArray;
        this.indexSCOCIs = staticCompiledOpenConglomInfoArray;
        this.deferred = bl;
        this.targetProperties = properties;
        this.targetUUID = uUID;
        this.lockMode = n;
        this.fkInfo = fKInfoArray;
        this.triggerInfo = triggerInfo;
        this.baseRowReadList = formatableBitSet;
        this.baseRowReadMap = nArray;
        this.streamStorableHeapColIds = nArray2;
        this.singleRowSource = bl2;
        this.indexNames = stringArray;
        this.underMerge = bl3;
    }

    final FKInfo[] getFKInfo() {
        return this.fkInfo;
    }

    TriggerInfo getTriggerInfo() {
        return this.triggerInfo;
    }

    @Override
    public final void executeConstantAction(Activation activation) throws StandardException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.conglomId = objectInput.readLong();
        this.heapSCOCI = (StaticCompiledOpenConglomInfo)objectInput.readObject();
        this.irgs = new IndexRowGenerator[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.irgs);
        this.indexCIDS = ArrayUtil.readLongArray(objectInput);
        this.indexSCOCIs = new StaticCompiledOpenConglomInfo[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.indexSCOCIs);
        this.deferred = objectInput.readBoolean();
        this.targetProperties = (Properties)objectInput.readObject();
        this.targetUUID = (UUID)objectInput.readObject();
        this.lockMode = objectInput.readInt();
        this.fkInfo = new FKInfo[ArrayUtil.readArrayLength(objectInput)];
        ArrayUtil.readArrayItems(objectInput, this.fkInfo);
        this.triggerInfo = (TriggerInfo)objectInput.readObject();
        this.baseRowReadList = (FormatableBitSet)objectInput.readObject();
        this.baseRowReadMap = ArrayUtil.readIntArray(objectInput);
        this.streamStorableHeapColIds = ArrayUtil.readIntArray(objectInput);
        this.singleRowSource = objectInput.readBoolean();
        this.indexNames = ArrayUtil.readStringArray(objectInput);
        this.underMerge = objectInput.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.conglomId);
        objectOutput.writeObject(this.heapSCOCI);
        ArrayUtil.writeArray(objectOutput, this.irgs);
        ArrayUtil.writeLongArray(objectOutput, this.indexCIDS);
        ArrayUtil.writeArray(objectOutput, this.indexSCOCIs);
        objectOutput.writeBoolean(this.deferred);
        objectOutput.writeObject(this.targetProperties);
        objectOutput.writeObject(this.targetUUID);
        objectOutput.writeInt(this.lockMode);
        ArrayUtil.writeArray(objectOutput, this.fkInfo);
        objectOutput.writeObject(this.triggerInfo);
        objectOutput.writeObject(this.baseRowReadList);
        ArrayUtil.writeIntArray(objectOutput, this.baseRowReadMap);
        ArrayUtil.writeIntArray(objectOutput, this.streamStorableHeapColIds);
        objectOutput.writeBoolean(this.singleRowSource);
        ArrayUtil.writeArray(objectOutput, this.indexNames);
        objectOutput.writeBoolean(this.underMerge);
    }

    public boolean underMerge() {
        return this.underMerge;
    }

    public long getConglomerateId() {
        return this.conglomId;
    }

    public Properties getTargetProperties() {
        return this.targetProperties;
    }

    public String getProperty(String string) {
        return this.targetProperties == null ? null : this.targetProperties.getProperty(string);
    }

    public FormatableBitSet getBaseRowReadList() {
        return this.baseRowReadList;
    }

    public int[] getBaseRowReadMap() {
        return this.baseRowReadMap;
    }

    public int[] getStreamStorableHeapColIds() {
        return this.streamStorableHeapColIds;
    }

    public String getIndexNameFromCID(long l) {
        int n = this.indexCIDS.length;
        if (this.indexNames == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            if (this.indexCIDS[i] != l) continue;
            return this.indexNames[i];
        }
        return null;
    }

    public String[] getIndexNames() {
        return this.indexNames;
    }
}

