/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.ant;

import com.sun.tools.ws.processor.modeler.annotation.WebServiceAp;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;

public class AnnotationProcessingTask
extends Javac {
    private boolean procOnly = false;
    private File sourceDestDir;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^\\D+(\\d+(\\.?\\d+)?)$");

    public File getSourceDestDir() {
        return this.sourceDestDir;
    }

    public void setSourceDestDir(File sourceDestDir) {
        this.sourceDestDir = sourceDestDir;
    }

    public boolean isProcOnly() {
        return this.procOnly;
    }

    public void setProcOnly(boolean procOnly) {
        this.procOnly = procOnly;
    }

    protected void checkParameters() throws BuildException {
        super.checkParameters();
        if (this.sourceDestDir == null) {
            throw new BuildException("destination source directory must be set", this.getLocation());
        }
        if (!this.sourceDestDir.isDirectory()) {
            throw new BuildException("destination source directory \"" + String.valueOf(this.sourceDestDir) + "\" does not exist or is not a directory", this.getLocation());
        }
        try {
            float version;
            Matcher matcher = VERSION_PATTERN.matcher(super.getCompilerVersion());
            if (matcher.find() && (double)(version = Float.parseFloat(matcher.group(1))) < 1.6) {
                throw new BuildException("Annotation processing task requires Java 1.6+", this.getLocation());
            }
        }
        catch (NullPointerException | NumberFormatException e) {
            this.log("Can't check version for annotation processing task");
        }
    }

    public void execute() throws BuildException {
        Javac.ImplementationSpecificArgument argument = super.createCompilerArg();
        argument.setLine("-processor " + WebServiceAp.class.getName());
        argument = super.createCompilerArg();
        argument.setLine("-s " + String.valueOf(this.sourceDestDir));
        if (this.procOnly) {
            argument = super.createCompilerArg();
            argument.setLine("-proc:only");
        }
        super.execute();
    }
}

