/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.tcp.util;

public final class TCPSettings {
    private static final TCPSettings instance = new TCPSettings();
    private static final String ENCODING_MODE_PROPERTY = "com.sun.xml.ws.transport.tcp.encodingMode";
    private static final String OUTPUT_BUFFER_GROWING_PROPERTY = "com.sun.xml.ws.transport.tcp.output.bufferGrow";
    private static final String OUTPUT_BUFFER_GROWING_LIMIT_PROPERTY = "com.sun.xml.ws.transport.tcp.output.bufferGrowLimit";
    private EncodingMode encodingMode;
    private boolean isOutputBufferGrow;
    private int outputBufferGrowLimit;

    private TCPSettings() {
        this.gatherSettings();
    }

    public static TCPSettings getInstance() {
        return instance;
    }

    public EncodingMode getEncodingMode() {
        return this.encodingMode;
    }

    public boolean isOutputBufferGrow() {
        return this.isOutputBufferGrow;
    }

    public int getOutputBufferGrowLimit() {
        return this.outputBufferGrowLimit;
    }

    private void gatherSettings() {
        String encodingModeS;
        this.encodingMode = System.getProperty(ENCODING_MODE_PROPERTY) != null ? ("xml".equalsIgnoreCase(encodingModeS = System.getProperty(ENCODING_MODE_PROPERTY)) ? EncodingMode.XML : ("FIStateless".equalsIgnoreCase(encodingModeS) ? EncodingMode.FI_STATELESS : EncodingMode.FI_STATEFUL)) : EncodingMode.FI_STATEFUL;
        this.isOutputBufferGrow = System.getProperty(OUTPUT_BUFFER_GROWING_PROPERTY) == null || Boolean.getBoolean(OUTPUT_BUFFER_GROWING_PROPERTY);
        this.outputBufferGrowLimit = Integer.getInteger(OUTPUT_BUFFER_GROWING_LIMIT_PROPERTY, 65536);
    }

    public static enum EncodingMode {
        XML,
        FI_STATELESS,
        FI_STATEFUL,
        FI_ALL;

    }
}

