/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.component;

import com.sun.webui.jsf.component.Hyperlink;
import com.sun.webui.jsf.component.IconHyperlink;
import com.sun.webui.jsf.component.ImageComponent;
import com.sun.webui.jsf.component.ImageHyperlink;
import com.sun.webui.jsf.component.Tree;
import com.sun.webui.jsf.event.ToggleActionListener;
import com.sun.webui.jsf.util.ComponentUtilities;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.el.MethodExpression;
import jakarta.el.ValueExpression;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.context.FacesContext;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import jakarta.faces.event.FacesEvent;
import jakarta.faces.event.FacesListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class TreeNode
extends UIComponentBase
implements NamingContainer,
Serializable {
    private static final long serialVersionUID = -4316201329117848574L;
    private static final Map<String, String> TOP_LINE_IMAGE_MAPPING = new HashMap<String, String>(6);
    public static final String IMAGE_FACET_KEY = "image";
    public static final String CONTENT_FACET_KEY = "content";
    private MethodExpression actionExpression = null;
    private MethodExpression actionListenerExpression;
    private boolean expanded = false;
    private boolean expandedSet = false;
    private String imageURL = null;
    private String style = null;
    private String styleClass = null;
    private String target = null;
    private String text = null;
    private String toolTip = null;
    private String url = null;
    private boolean visible = false;
    private boolean visibleSet = false;

    public TreeNode() {
        this.setRendererType("com.sun.webui.jsf.TreeNode");
    }

    public String getFamily() {
        return "com.sun.webui.jsf.TreeNode";
    }

    public void setId(String id) {
        super.setId(id);
    }

    public void setRendered(boolean rendered) {
        super.setRendered(rendered);
    }

    public MethodExpression getActionExpression() {
        if (this.actionExpression != null) {
            return this.actionExpression;
        }
        ValueExpression vb = this.getValueExpression("actionExpression");
        if (vb != null) {
            return (MethodExpression)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setActionExpression(MethodExpression newActionExpression) {
        this.actionExpression = newActionExpression;
    }

    public MethodExpression getActionListenerExpression() {
        return this.actionListenerExpression;
    }

    public void setActionListenerExpression(MethodExpression newActionListenerExpression) {
        this.actionListenerExpression = newActionListenerExpression;
    }

    public boolean isExpanded() {
        if (this.expandedSet) {
            return this.expanded;
        }
        ValueExpression vb = this.getValueExpression("expanded");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return false;
    }

    public void setExpanded(boolean newExpanded) {
        this.expanded = newExpanded;
        this.expandedSet = true;
        ImageHyperlink toggleLink = this.getNodeImageHyperlink();
        Map attributes = toggleLink.getAttributes();
        attributes.put("icon", this.getHandleIcon((String)attributes.get("icon")));
    }

    public String getImageURL() {
        if (this.imageURL != null) {
            return this.imageURL;
        }
        ValueExpression vb = this.getValueExpression("imageURL");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setImageURL(String newImageURL) {
        this.imageURL = newImageURL;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueExpression vb = this.getValueExpression("style");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyle(String newStyle) {
        this.style = newStyle;
    }

    public String getStyleClass() {
        if (this.styleClass != null) {
            return this.styleClass;
        }
        ValueExpression vb = this.getValueExpression("styleClass");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setStyleClass(String newStyleClass) {
        this.styleClass = newStyleClass;
    }

    public String getTarget() {
        if (this.target != null) {
            return this.target;
        }
        ValueExpression vb = this.getValueExpression("target");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setTarget(String newTarget) {
        this.target = newTarget;
    }

    public String getText() {
        if (this.text != null) {
            return this.text;
        }
        ValueExpression vb = this.getValueExpression("text");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public String getToolTip() {
        if (this.toolTip != null) {
            return this.toolTip;
        }
        ValueExpression vb = this.getValueExpression("toolTip");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setToolTip(String newToolTip) {
        this.toolTip = newToolTip;
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        ValueExpression vb = this.getValueExpression("url");
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext().getELContext());
        }
        return null;
    }

    public void setUrl(String newUrl) {
        this.url = newUrl;
    }

    public boolean isVisible() {
        if (this.visibleSet) {
            return this.visible;
        }
        ValueExpression vb = this.getValueExpression("visible");
        if (vb != null) {
            Object result = vb.getValue(this.getFacesContext().getELContext());
            if (result == null) {
                return false;
            }
            return (Boolean)result;
        }
        return true;
    }

    public void setVisible(boolean newVisible) {
        this.visible = newVisible;
        this.visibleSet = true;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        MethodExpression mex = this.getActionListenerExpression();
        boolean expandToggleIcon = true;
        if (mex != null) {
            try {
                if (event instanceof ActionEvent) {
                    Object[] objArray = new Object[]{(ActionEvent)event};
                    mex.invoke(FacesContext.getCurrentInstance().getELContext(), objArray);
                }
            }
            catch (Exception e) {
                expandToggleIcon = false;
                LogUtil.warning(e.getMessage(), e);
            }
        }
        if (expandToggleIcon) {
            this.setExpanded(!this.isExpanded());
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public List getImageKeys() {
        String imageIcon;
        TreeNode prevNode;
        Stack<String> stack = new Stack<String>();
        Stack<Object> tempStack = new Stack<Object>();
        boolean first = true;
        boolean bottomNode = false;
        int count = 1;
        TreeNode node = prevNode = TreeNode.getParentTreeNode((UIComponent)this);
        while (node != null) {
            ImageComponent ic;
            String id;
            int len;
            TreeNode[] peerList = TreeNode.getChildTreeNodes((UIComponent)node);
            TreeNode thisNode = peerList[(len = peerList.length) - 1];
            if (thisNode == this) {
                bottomNode = true;
            }
            if (first) {
                String imageIcon2;
                first = false;
                TreeNode[] list = TreeNode.getChildTreeNodes((UIComponent)this);
                if (list != null && list.length > 0) {
                    imageIcon2 = ((Boolean)this.getAttributes().get("expanded")).booleanValue() ? (bottomNode ? "TREE_HANDLE_DOWN_LAST" : "TREE_HANDLE_DOWN_MIDDLE") : (bottomNode ? "TREE_HANDLE_RIGHT_LAST" : "TREE_HANDLE_RIGHT_MIDDLE");
                    stack.push(imageIcon2);
                    IconHyperlink ihl = this.getTurnerImageHyperlink();
                    ihl.setIcon(imageIcon2);
                    ihl.setToolTip("Toggle " + this.getText() + " node");
                    ihl.setAlt("Toggle " + this.getText() + " node icon");
                    Tree rootNode = TreeNode.getAbsoluteRoot((UIComponent)this);
                    if (rootNode != null && rootNode.isClientSide()) {
                        ihl.setOnClick("return false;");
                    }
                    ihl.setBorder(0);
                    tempStack.push(ihl);
                } else {
                    imageIcon2 = bottomNode ? "TREE_LINE_LAST_NODE" : "TREE_LINE_MIDDLE_NODE";
                    stack.push(imageIcon2);
                    id = "icon" + count++;
                    ic = (ImageComponent)ComponentUtilities.getChild((UIComponent)this, id);
                    if (ic == null) {
                        ic = new ImageComponent();
                        ic.setId(id);
                        ic.setToolTip(this.getText() + " node");
                        ic.setAlt(this.getText() + " node icon");
                        this.getFacets().put(id, ic);
                    }
                    ic.setIcon(imageIcon2);
                    tempStack.push((Object)ic);
                }
            } else {
                Object value = node.getAttributes().get("lastChild");
                TreeNode[] list = TreeNode.getChildTreeNodes((UIComponent)node);
                boolean last = value == null ? false : value.toString().equals("true");
                imageIcon = !last && list != null && list.length > 0 ? "TREE_LINE_VERTICAL" : "TREE_BLANK";
                stack.push(imageIcon);
                id = "icon" + count++;
                ic = (ImageComponent)ComponentUtilities.getChild((UIComponent)this, id);
                if (ic == null) {
                    ic = new ImageComponent();
                    ic.setIcon(imageIcon);
                    ic.setToolTip(prevNode.getText() + " child");
                    ic.setAlt(prevNode.getText() + " child icon");
                    ic.setId(id);
                    this.getFacets().put(id, ic);
                }
                tempStack.push((Object)ic);
            }
            prevNode = node;
            node = TreeNode.getParentTreeNode((UIComponent)node);
        }
        TreeNode parent = TreeNode.getParentTreeNode((UIComponent)this);
        if (parent instanceof Tree) {
            for (Object child : parent.getChildren()) {
                String imgURL;
                if (!(child instanceof TreeNode)) continue;
                if (child != this || (imgURL = parent.getImageURL()) != null && !imgURL.equals("") || parent.getFacet(IMAGE_FACET_KEY) != null) break;
                imageIcon = TOP_LINE_IMAGE_MAPPING.get(stack.pop());
                Object topmost = tempStack.pop();
                if (topmost instanceof ImageComponent) {
                    ((ImageComponent)((Object)topmost)).setIcon(imageIcon);
                } else if (topmost instanceof IconHyperlink) {
                    ((IconHyperlink)topmost).setIcon(imageIcon);
                }
                stack.push(imageIcon);
                tempStack.push((UIComponent)topmost);
                break;
            }
        }
        ArrayList<UIComponent> list = new ArrayList<UIComponent>();
        while (!tempStack.empty()) {
            list.add((UIComponent)tempStack.pop());
        }
        return list;
    }

    public TreeNode getChildNode(String id) {
        String thisID = this.getId();
        if (thisID != null && thisID.equals(id)) {
            return this;
        }
        if (this.getChildCount() == 0) {
            return null;
        }
        for (UIComponent kid : this.getChildren()) {
            if (!(kid instanceof TreeNode)) continue;
            String kidId = kid.getId();
            if (kidId != null && kidId.equals(id)) {
                return (TreeNode)kid;
            }
            TreeNode node = (TreeNode)kid;
            TreeNode foo = node.getChildNode(id);
            if (foo == null) continue;
            return foo;
        }
        return null;
    }

    public static TreeNode getParentTreeNode(UIComponent node) {
        UIComponent n;
        if (node == null) {
            return null;
        }
        for (n = node.getParent(); n != null && !(n instanceof TreeNode); n = n.getParent()) {
        }
        return (TreeNode)n;
    }

    public static Tree getAbsoluteRoot(UIComponent node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Tree) {
            return (Tree)node;
        }
        if (node instanceof TreeNode) {
            UIComponent n;
            for (n = node.getParent(); n != null && !(n instanceof Tree); n = n.getParent()) {
            }
            if (n != null) {
                return (Tree)n;
            }
            return null;
        }
        return null;
    }

    public static TreeNode[] getChildTreeNodes(UIComponent node) {
        if (node == null) {
            return null;
        }
        if (node instanceof TreeNode) {
            Iterator nodeList = node.getChildren().iterator();
            ArrayList<TreeNode> childNodeList = new ArrayList<TreeNode>();
            while (nodeList.hasNext()) {
                UIComponent comp = (UIComponent)nodeList.next();
                if (!(comp instanceof TreeNode)) continue;
                childNodeList.add((TreeNode)comp);
            }
            TreeNode[] arr = new TreeNode[childNodeList.size()];
            for (int i = 0; i < childNodeList.size(); ++i) {
                arr[i] = (TreeNode)childNodeList.get(i);
            }
            return arr;
        }
        return null;
    }

    public void addActionListener(ActionListener listener) {
        this.addFacesListener((FacesListener)listener);
    }

    public ActionListener[] getActionListeners() {
        ActionListener[] al = (ActionListener[])this.getFacesListeners(ActionListener.class);
        return al;
    }

    public void removeActionListener(ActionListener listener) {
        this.removeFacesListener((FacesListener)listener);
    }

    public String getHandleIcon(String value) {
        if (this.isExpanded()) {
            return "TREE_HANDLE_DOWN_TOP_NOSIBLING";
        }
        return "TREE_HANDLE_RIGHT_TOP_NOSIBLING";
    }

    public Hyperlink getContentHyperlink() {
        ActionListener[] nodeListeners;
        Hyperlink child = (Hyperlink)ComponentUtilities.getPrivateFacet((UIComponent)this, "link", true);
        if (child == null) {
            child = new Hyperlink();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, "link"));
            child.addActionListener(new ToggleActionListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, "link", (UIComponent)child);
        }
        child.setText(this.getText());
        child.setUrl(this.getUrl());
        if (this.getTarget() != null) {
            child.setTarget(this.getTarget());
        }
        if (this.getActionExpression() != null) {
            child.setActionExpression(this.getActionExpression());
        }
        if ((nodeListeners = this.getActionListeners()) != null && nodeListeners.length > 0) {
            for (ActionListener nodeListener : nodeListeners) {
                child.addActionListener(nodeListener);
            }
        }
        if (this.getToolTip() != null) {
            child.setToolTip(this.getToolTip());
        }
        return child;
    }

    public ImageHyperlink getNodeImageHyperlink() {
        ActionListener[] nodeListeners;
        ImageHyperlink child = (ImageHyperlink)ComponentUtilities.getPrivateFacet((UIComponent)this, IMAGE_FACET_KEY, true);
        if (child == null) {
            child = new ImageHyperlink();
            child.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, IMAGE_FACET_KEY));
            child.addActionListener(new ToggleActionListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, IMAGE_FACET_KEY, (UIComponent)child);
        }
        child.setImageURL(this.getImageURL());
        child.setUrl(this.getUrl());
        child.setBorder(0);
        if (this.getTarget() != null) {
            child.setTarget(this.getTarget());
        }
        if (this.getActionExpression() != null) {
            child.setActionExpression(this.getActionExpression());
        }
        if ((nodeListeners = this.getActionListeners()) != null && nodeListeners.length > 0) {
            for (ActionListener nodeListener : nodeListeners) {
                child.addActionListener(nodeListener);
            }
        }
        if (this.getToolTip() != null) {
            child.setToolTip(this.getToolTip());
        }
        return child;
    }

    public IconHyperlink getTurnerImageHyperlink() {
        IconHyperlink ihl = (IconHyperlink)ComponentUtilities.getPrivateFacet((UIComponent)this, "turner", true);
        if (ihl == null) {
            ihl = new IconHyperlink();
            ihl.setId(ComponentUtilities.createPrivateFacetId((UIComponent)this, "turner"));
            ihl.addActionListener(new ToggleActionListener());
            ComponentUtilities.putPrivateFacet((UIComponent)this, "turner", (UIComponent)ihl);
        }
        return ihl;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.actionExpression = (MethodExpression)TreeNode.restoreAttachedState((FacesContext)context, (Object)values[1]);
        this.actionListenerExpression = (MethodExpression)values[2];
        this.expanded = (Boolean)values[3];
        this.expandedSet = (Boolean)values[4];
        this.imageURL = (String)values[5];
        this.style = (String)values[6];
        this.styleClass = (String)values[7];
        this.target = (String)values[8];
        this.text = (String)values[9];
        this.toolTip = (String)values[10];
        this.url = (String)values[11];
        this.visible = (Boolean)values[12];
        this.visibleSet = (Boolean)values[13];
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), TreeNode.saveAttachedState((FacesContext)context, (Object)this.actionExpression), this.actionListenerExpression, this.expanded ? Boolean.TRUE : Boolean.FALSE, this.expandedSet ? Boolean.TRUE : Boolean.FALSE, this.imageURL, this.style, this.styleClass, this.target, this.text, this.toolTip, this.url, this.visible ? Boolean.TRUE : Boolean.FALSE, this.visibleSet ? Boolean.TRUE : Boolean.FALSE};
        return values;
    }

    static {
        TOP_LINE_IMAGE_MAPPING.put("TREE_HANDLE_DOWN_MIDDLE", "TREE_HANDLE_DOWN_TOP");
        TOP_LINE_IMAGE_MAPPING.put("TREE_HANDLE_DOWN_LAST", "TREE_HANDLE_DOWN_TOP_NOSIBLING");
        TOP_LINE_IMAGE_MAPPING.put("TREE_HANDLE_RIGHT_MIDDLE", "TREE_HANDLE_RIGHT_TOP");
        TOP_LINE_IMAGE_MAPPING.put("TREE_HANDLE_RIGHT_LAST", "TREE_HANDLE_RIGHT_TOP_NOSIBLING");
        TOP_LINE_IMAGE_MAPPING.put("TREE_LINE_MIDDLE_NODE", "TREE_LINE_FIRST_NODE");
        TOP_LINE_IMAGE_MAPPING.put("TREE_LINE_LAST_NODE", "TREE_BLANK");
    }
}

