/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.node.DeploymentDescriptorNode;
import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.util.net.URLPattern;
import jakarta.servlet.DispatcherType;
import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import org.glassfish.web.LogFacade;
import org.glassfish.web.deployment.descriptor.ServletFilterMappingDescriptor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FilterMappingNode
extends DeploymentDescriptorNode<ServletFilterMappingDescriptor> {
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();
    private ServletFilterMappingDescriptor descriptor;

    public ServletFilterMappingDescriptor getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new ServletFilterMappingDescriptor();
        }
        return this.descriptor;
    }

    protected Map<String, String> getDispatchTable() {
        Map table = super.getDispatchTable();
        table.put("filter-name", "setName");
        return table;
    }

    public void setElementValue(XMLElement element, String value) {
        if ("servlet-name".equals(element.getQName())) {
            this.descriptor.addServletName(value);
        } else if ("url-pattern".equals(element.getQName())) {
            if (!URLPattern.isValid((String)value)) {
                Object trimmedUrl = value.trim();
                Object parent = this.getParentNode().getDescriptor();
                if (parent instanceof WebBundleDescriptor && ((WebBundleDescriptor)parent).getSpecVersion().equals("2.2") && !((String)trimmedUrl).startsWith("/") && !((String)trimmedUrl).startsWith("*.")) {
                    trimmedUrl = "/" + (String)trimmedUrl;
                }
                if (URLPattern.isValid((String)trimmedUrl)) {
                    if (URLPattern.containsCRorLF((String)value)) {
                        DOLUtils.getDefaultLogger().log(Level.WARNING, "enterprise.deployment.backend.urlcontainscrlf", new Object[]{value});
                    }
                    value = trimmedUrl;
                } else {
                    throw new IllegalArgumentException(MessageFormat.format(rb.getString("AS-WEB-GLUE-00279"), value));
                }
            }
            this.descriptor.addURLPattern(value);
        } else if ("dispatcher".equals(element.getQName())) {
            this.descriptor.addDispatcher(value);
        } else {
            super.setElementValue(element, value);
        }
    }

    public Node writeDescriptor(Node parent, String nodeName, ServletFilterMappingDescriptor descriptor) {
        Element myNode = FilterMappingNode.appendChild((Node)parent, (String)nodeName);
        FilterMappingNode.appendTextChild((Node)myNode, (String)"filter-name", (String)descriptor.getName());
        for (String servletName : descriptor.getServletNames()) {
            FilterMappingNode.appendTextChild((Node)myNode, (String)"servlet-name", (String)servletName);
        }
        for (String urlPattern : descriptor.getUrlPatterns()) {
            FilterMappingNode.appendTextChild((Node)myNode, (String)"url-pattern", (String)urlPattern);
        }
        for (DispatcherType dispatcherType : descriptor.getDispatchers()) {
            FilterMappingNode.appendTextChild((Node)myNode, (String)"dispatcher", (String)dispatcherType.name());
        }
        return myNode;
    }
}

