/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.helper;

import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;

public class DeferredLockManager {
    protected Vector<ConcurrencyManager> deferredLocks = new Vector(1);
    protected Vector<ConcurrencyManager> activeLocks = new Vector(1);
    protected int threadDepth = 0;
    protected boolean isThreadComplete = false;
    public static boolean SHOULD_USE_DEFERRED_LOCKS = true;

    public void addActiveLock(Object manager) {
        this.getActiveLocks().addElement((ConcurrencyManager)manager);
    }

    public void addDeferredLock(Object manager) {
        this.getDeferredLocks().addElement((ConcurrencyManager)manager);
    }

    public void decrementDepth() {
        --this.threadDepth;
    }

    public Vector<ConcurrencyManager> getActiveLocks() {
        return this.activeLocks;
    }

    public Vector<ConcurrencyManager> getDeferredLocks() {
        return this.deferredLocks;
    }

    public int getThreadDepth() {
        return this.threadDepth;
    }

    public boolean hasDeferredLock() {
        return !this.getDeferredLocks().isEmpty();
    }

    public void incrementDepth() {
        ++this.threadDepth;
    }

    public boolean isThreadComplete() {
        return this.isThreadComplete;
    }

    public void releaseActiveLocksOnThread() {
        Vector<ConcurrencyManager> activeLocks = this.getActiveLocks();
        if (!activeLocks.isEmpty()) {
            Enumeration<ConcurrencyManager> activeLocksEnum = activeLocks.elements();
            while (activeLocksEnum.hasMoreElements()) {
                ConcurrencyManager manager = activeLocksEnum.nextElement();
                manager.release();
            }
        }
        this.setIsThreadComplete(true);
    }

    public void setActiveLocks(Vector<ConcurrencyManager> activeLocks) {
        this.activeLocks = activeLocks;
    }

    public void setDeferredLocks(Vector<ConcurrencyManager> deferredLocks) {
        this.deferredLocks = deferredLocks;
    }

    public void setIsThreadComplete(boolean isThreadComplete) {
        this.isThreadComplete = isThreadComplete;
    }
}

