/*
 * Decompiled with CFR 0.152.
 */
package jakarta.security.enterprise.identitystore;

import jakarta.security.enterprise.CallerPrincipal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class CredentialValidationResult {
    public static final CredentialValidationResult INVALID_RESULT = new CredentialValidationResult(Status.INVALID);
    public static final CredentialValidationResult NOT_VALIDATED_RESULT = new CredentialValidationResult(Status.NOT_VALIDATED);
    private final Status status;
    private final String storeId;
    private final String callerDn;
    private final String callerUniqueId;
    private final CallerPrincipal callerPrincipal;
    private final Set<String> groups;

    private CredentialValidationResult(Status status) {
        this(status, null, null, null, null, null);
    }

    public CredentialValidationResult(String callerName) {
        this(new CallerPrincipal(callerName), null);
    }

    public CredentialValidationResult(CallerPrincipal callerPrincipal) {
        this(callerPrincipal, null);
    }

    public CredentialValidationResult(String callerName, Set<String> groups) {
        this(new CallerPrincipal(callerName), groups);
    }

    public CredentialValidationResult(CallerPrincipal callerPrincipal, Set<String> groups) {
        this(null, callerPrincipal, null, null, groups);
    }

    public CredentialValidationResult(String storeId, String callerName, String callerDn, String callerUniqueId, Set<String> groups) {
        this(storeId, new CallerPrincipal(callerName), callerDn, callerUniqueId, groups);
    }

    public CredentialValidationResult(String storeId, CallerPrincipal callerPrincipal, String callerDn, String callerUniqueId, Set<String> groups) {
        this(Status.VALID, storeId, callerPrincipal, callerDn, callerUniqueId, groups);
    }

    private CredentialValidationResult(Status status, String storeId, CallerPrincipal callerPrincipal, String callerDn, String callerUniqueId, Set<String> groups) {
        if (status != Status.VALID && (storeId != null || callerPrincipal != null || callerDn != null || callerUniqueId != null || groups != null)) {
            throw new IllegalArgumentException("Bad status");
        }
        if (status == Status.VALID && (callerPrincipal == null || callerPrincipal.getName().trim().isEmpty())) {
            throw new IllegalArgumentException("Null or empty CallerPrincipal");
        }
        this.status = status;
        this.storeId = storeId;
        this.callerPrincipal = callerPrincipal;
        this.callerDn = callerDn;
        this.callerUniqueId = callerUniqueId;
        this.groups = groups != null ? Collections.unmodifiableSet(new HashSet<String>(groups)) : Collections.emptySet();
    }

    public Status getStatus() {
        return this.status;
    }

    public String getIdentityStoreId() {
        return this.storeId;
    }

    public CallerPrincipal getCallerPrincipal() {
        return this.callerPrincipal;
    }

    public String getCallerUniqueId() {
        return this.callerUniqueId;
    }

    public String getCallerDn() {
        return this.callerDn;
    }

    public Set<String> getCallerGroups() {
        return this.groups;
    }

    public static enum Status {
        NOT_VALIDATED,
        INVALID,
        VALID;

    }
}

