/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt;

import com.sun.enterprise.admin.servermgmt.FileValidator;
import com.sun.enterprise.admin.servermgmt.MasterPasswordFileManager;
import com.sun.enterprise.admin.servermgmt.RepositoryConfig;
import com.sun.enterprise.admin.servermgmt.RepositoryException;
import com.sun.enterprise.admin.servermgmt.RepositoryNameValidator;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.servermgmt.pe.PEFileLayout;
import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.security.store.PasswordAdapter;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class RepositoryManager
extends MasterPasswordFileManager {
    protected static final String CERTUTIL_CMD = System.getProperty("com.sun.aas.nssBin") + "/certutil";
    protected static final String NEW_LINE = System.getProperty("line.separator");
    private static final StringManager _strMgr = StringManager.getManager(RepositoryManager.class);
    protected RepositoryManagerMessages _messages = null;
    public static final String DEBUG = "Debug";

    public RepositoryManager() {
        this.setMessages(new RepositoryManagerMessages(StringManager.getManager(PEDomainsManager.class), "illegalDomainName", "domainName", "domainsRoot", "domainExists", "domainDoesntExist", "domainDirNotValid", "cannotDeleteDomainDir", "invalidDomainDir", "listDomainElement", "cannotDeleteInstance_invalidState", "instanceStartupException", "cannotStartInstance_invalidState", "startInstanceTimeOut", "portConflict", "startupFailed", "cannotStopInstance_invalidState", "cannotStopInstance", "timeoutStarting"));
    }

    protected void setMessages(RepositoryManagerMessages messages) {
        this._messages = messages;
    }

    protected RepositoryManagerMessages getMessages() {
        return this._messages;
    }

    protected void generateFromTemplate(TokenValueSet tokens, File template, File destinationFile) throws IOException {
        LineTokenReplacer replacer = new LineTokenReplacer(tokens);
        replacer.replace(template, destinationFile);
    }

    protected boolean repositoryExists(RepositoryConfig config) {
        return FileUtils.safeGetCanonicalFile((File)this.getRepositoryDir(config)).exists();
    }

    protected boolean isValidRepository(File f) {
        return new File(new File(f, "config"), "domain.xml").exists();
    }

    protected boolean isValidRepository(RepositoryConfig config) {
        return this.getFileLayout(config).getDomainConfigFile().exists();
    }

    protected File getRepositoryDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryDir();
    }

    protected File getRepositoryRootDir(RepositoryConfig config) {
        return this.getFileLayout(config).getRepositoryRootDir();
    }

    protected void checkRepository(RepositoryConfig config) throws RepositoryException {
        this.checkRepository(config, true, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository) throws RepositoryException {
        this.checkRepository(config, existingRepository, true);
    }

    public void checkRepository(RepositoryConfig config, boolean existingRepository, boolean checkRootDir) throws RepositoryException {
        String repositoryName = config.getDisplayName();
        new RepositoryNameValidator(this.getMessages().getRepositoryNameMessage()).validate(repositoryName);
        if (checkRootDir || existingRepository) {
            new FileValidator(this.getMessages().getRepositoryRootMessage(), "drw").validate(config.getRepositoryRoot());
        }
        new FileValidator(_strMgr.getString("installRoot"), "dr").validate(config.getInstallRoot());
        if (existingRepository) {
            if (!this.repositoryExists(config)) {
                if (Boolean.getBoolean(DEBUG)) {
                    throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getBigNoExistsMessage(config)));
                }
                throw new RepositoryException(this.getMessages().getNoExistsMessage(repositoryName, this.getRepositoryDir(config).getAbsolutePath()));
            }
            if (!this.isValidRepository(config)) {
                throw new RepositoryException(this.getMessages().getRepositoryNotValidMessage(this.getRepositoryDir(config).getAbsolutePath()));
            }
        } else if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getExistsMessage(repositoryName, this.getRepositoryRootDir(config).getAbsolutePath()));
        }
    }

    private String getBigNoExistsMessage(RepositoryConfig config) {
        File repdir = this.getRepositoryDir(config);
        File canrepdir = FileUtils.safeGetCanonicalFile((File)repdir);
        File canrepdirparent = canrepdir.getParentFile();
        Object s = "";
        s = (String)s + "\nRep. Dir:" + String.valueOf(repdir);
        s = (String)s + "\nDump of RepositoryConfig: " + config.toString();
        s = (String)s + "\nCanonical File: " + String.valueOf(canrepdir);
        s = (String)s + "\nParent File: " + String.valueOf(canrepdirparent);
        boolean regex = repdir.exists();
        boolean canex = canrepdir.exists();
        boolean parentex = canrepdirparent.exists();
        boolean regdir = repdir.isDirectory();
        boolean candir = canrepdir.isDirectory();
        boolean parentdir = canrepdirparent.isDirectory();
        s = (String)s + "\nrepdir exists: " + regex + ", canon exists: " + canex + ", parent exists: " + parentex + ", reg is dir: " + regdir + ", canon isdir: " + candir + ", parent is dir: " + parentdir;
        s = (String)s + "\nInstance root sys property (";
        s = (String)s + "com.sun.aas.instanceRoot";
        s = (String)s + "): ";
        s = (String)s + System.getProperty("com.sun.aas.instanceRoot");
        return s;
    }

    protected void setPermissions(RepositoryConfig repositoryConfig) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(repositoryConfig);
        File domainDir = layout.getRepositoryDir();
        try {
            this.chmod("-R 755", domainDir);
        }
        catch (Exception e) {
            throw new RepositoryException("Error setting permissions.", e);
        }
    }

    protected void deleteRepository(RepositoryConfig config) throws RepositoryException {
        this.deleteRepository(config, true);
    }

    protected void deleteRepository(RepositoryConfig config, boolean deleteJMSProvider) throws RepositoryException {
        this.checkRepository(config, true);
        File repository = this.getRepositoryDir(config);
        try {
            FileUtils.liquidate((File)repository);
        }
        catch (Exception e) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()), e);
        }
        if (this.repositoryExists(config)) {
            throw new RepositoryException(this.getMessages().getCannotDeleteMessage(repository.getAbsolutePath()));
        }
    }

    protected String[] listRepository(RepositoryConfig config) throws RepositoryException {
        String[] dirs;
        File repository = this.getRepositoryRootDir(config);
        try {
            File f = repository.getCanonicalFile();
            if (!f.isDirectory()) {
                throw new RepositoryException(this.getMessages().getInvalidPathMessage(f.getAbsolutePath()));
            }
            dirs = f.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    if (!f.isDirectory()) {
                        return false;
                    }
                    return RepositoryManager.this.isValidRepository(f);
                }
            });
            if (dirs == null) {
                dirs = new String[]{};
            }
        }
        catch (Exception e) {
            throw new RepositoryException(e);
        }
        return dirs;
    }

    protected RepositoryConfig getConfigForRepositoryStatus(RepositoryConfig config, String repository) {
        return new RepositoryConfig(repository, config.getRepositoryRoot());
    }

    public void validateMasterPassword(RepositoryConfig config, String password) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
        }
        catch (IOException ex) {
            throw new RepositoryException(_strMgr.getString("masterPasswordInvalid"));
        }
        catch (Exception ex) {
            throw new RepositoryException(_strMgr.getString("couldNotValidateMasterPassword", (Object)passwordAliases), ex);
        }
    }

    public String getClearPasswordForAlias(RepositoryConfig config, String password, String alias) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        try {
            PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), password.toCharArray());
            String clearPwd = p.getPasswordForAlias(alias);
            return clearPwd;
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected void changePasswordAliasKeystorePassword(RepositoryConfig config, String oldPassword, String newPassword) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File passwordAliases = layout.getPasswordAliasKeystore();
        if (passwordAliases.exists()) {
            try {
                PasswordAdapter p = new PasswordAdapter(passwordAliases.getAbsolutePath(), oldPassword.toCharArray());
                p.changePassword(newPassword.toCharArray());
            }
            catch (Exception ex) {
                throw new RepositoryException(_strMgr.getString("passwordAliasPasswordNotChanged", (Object)passwordAliases), ex);
            }
        }
    }

    protected void createTimerWal(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerWalTemplate();
        File dest = layout.getTimerWal();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerWalNotCreated"), ioe);
        }
    }

    protected void createTimerDbn(RepositoryConfig config) throws RepositoryException {
        PEFileLayout layout = this.getFileLayout(config);
        File src = layout.getTimerDbnTemplate();
        File dest = layout.getTimerDbn();
        try {
            FileUtils.copy((File)src, (File)dest);
        }
        catch (IOException ioe) {
            throw new RepositoryException(_strMgr.getString("timerDbnNotCreated"), ioe);
        }
    }

    protected String[] getInteractiveOptions(String user, String password, String masterPassword, HashMap<Object, Object> extraPasswords) {
        int numKeys = extraPasswords == null ? 0 : extraPasswords.size();
        String[] options = new String[3 + numKeys];
        options[0] = user;
        options[1] = password;
        options[2] = masterPassword;
        if (extraPasswords != null) {
            int i = 3;
            for (Map.Entry<Object, Object> me : extraPasswords.entrySet()) {
                options[i++] = (String)me.getKey() + "=" + (String)me.getValue();
            }
        }
        return options;
    }

    public static boolean isNSSSupportAvailable() {
        File certUtilFile = null;
        certUtilFile = OS.isWindows() ? new File(CERTUTIL_CMD + ".exe") : new File(CERTUTIL_CMD);
        return certUtilFile.exists();
    }

    protected static class RepositoryManagerMessages {
        private final StringManager _strMgr;
        private final String _badNameMessage;
        private final String _repositoryNameMessage;
        private final String _repositoryRootMessage;
        private final String _existsMessage;
        private final String _noExistsMessage;
        private final String _repositoryNotValidMessage;
        private final String _cannotDeleteMessage;
        private final String _invalidPathMessage;
        private final String _listRepositoryElementMessage;
        private final String _cannotDeleteInstance_invalidState;
        private final String _instanceStartupExceptionMessage;
        private final String _cannotStartInstance_invalidStateMessage;
        private final String _startInstanceTimeOutMessage;
        private final String _portConflictMessage;
        private final String _startupFailedMessage;
        private final String _cannotStopInstance_invalidStateMessage;
        private final String _cannotStopInstanceMessage;
        private final String _timeoutStartingMessage;
        private String _cannotDeleteJmsProviderInstance;

        public RepositoryManagerMessages(StringManager strMgr, String badNameMessage, String repositoryNameMessage, String repositoryRootMessage, String existsMessage, String noExistsMessage, String repositoryNotValidMessage, String cannotDeleteMessage, String invalidPathMessage, String listRepositoryElementMessage, String cannotDeleteInstance_invalidState, String instanceStartupExceptionMessage, String cannotStartInstance_invalidStateMessage, String startInstanceTimeOutMessage, String portConflictMessage, String startupFailedMessage, String cannotStopInstance_invalidStateMessage, String cannotStopInstanceMessage, String timeoutStartingMessage) {
            this._strMgr = strMgr;
            this._badNameMessage = badNameMessage;
            this._repositoryNameMessage = repositoryNameMessage;
            this._repositoryRootMessage = repositoryRootMessage;
            this._existsMessage = existsMessage;
            this._noExistsMessage = noExistsMessage;
            this._repositoryNotValidMessage = repositoryNotValidMessage;
            this._cannotDeleteMessage = cannotDeleteMessage;
            this._invalidPathMessage = invalidPathMessage;
            this._listRepositoryElementMessage = listRepositoryElementMessage;
            this._cannotDeleteInstance_invalidState = cannotDeleteInstance_invalidState;
            this._instanceStartupExceptionMessage = instanceStartupExceptionMessage;
            this._cannotStartInstance_invalidStateMessage = cannotStartInstance_invalidStateMessage;
            this._startInstanceTimeOutMessage = startInstanceTimeOutMessage;
            this._portConflictMessage = portConflictMessage;
            this._startupFailedMessage = startupFailedMessage;
            this._cannotStopInstance_invalidStateMessage = cannotStopInstance_invalidStateMessage;
            this._cannotStopInstanceMessage = cannotStopInstanceMessage;
            this._timeoutStartingMessage = timeoutStartingMessage;
        }

        public String getRepositoryNameMessage() {
            return this._strMgr.getString(this._repositoryNameMessage);
        }

        public String getBadNameMessage(String repositoryName) {
            return this._strMgr.getString(this._badNameMessage, (Object)repositoryName);
        }

        public String getRepositoryRootMessage() {
            return this._strMgr.getString(this._repositoryRootMessage);
        }

        public String getNoExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._noExistsMessage, (Object)repositoryName, (Object)repositoryLocation);
        }

        public String getExistsMessage(String repositoryName, String repositoryLocation) {
            return this._strMgr.getString(this._existsMessage, (Object)repositoryName, (Object)repositoryLocation);
        }

        public String getRepositoryNotValidMessage(String path) {
            return this._strMgr.getString(this._repositoryNotValidMessage, (Object)path);
        }

        public String getCannotDeleteMessage(String repositoryName) {
            return this._strMgr.getString(this._cannotDeleteMessage, (Object)repositoryName);
        }

        public String getInvalidPathMessage(String path) {
            return this._strMgr.getString(this._invalidPathMessage, (Object)path);
        }

        public String getListRepositoryElementMessage(String repositoryName, String repositoryStatus) {
            return this._strMgr.getString(this._listRepositoryElementMessage, (Object)repositoryName, (Object)repositoryStatus);
        }

        public String getCannotDeleteInstanceInvalidState(String name, String state) {
            return this._strMgr.getString(this._cannotDeleteInstance_invalidState, (Object)name, (Object)state);
        }

        public String getInstanceStartupExceptionMessage(String name) {
            return this._strMgr.getString(this._instanceStartupExceptionMessage, (Object)name);
        }

        public String getCannotStartInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStartInstance_invalidStateMessage, (Object)name, (Object)state);
        }

        public String getStartInstanceTimeOutMessage(String name) {
            return this._strMgr.getString(this._startInstanceTimeOutMessage, (Object)name);
        }

        public String getStartupFailedMessage(String name) {
            return this._strMgr.getString(this._startupFailedMessage, (Object)name);
        }

        public String getStartupFailedMessage(String name, int port) {
            if (port != 0) {
                return this._strMgr.getString(this._portConflictMessage, new Object[]{name, String.valueOf(port)});
            }
            return this._strMgr.getString(this._startupFailedMessage, (Object)name);
        }

        public String getCannotStopInstanceInvalidStateMessage(String name, String state) {
            return this._strMgr.getString(this._cannotStopInstance_invalidStateMessage, (Object)name, (Object)state);
        }

        public String getCannotStopInstanceMessage(String name) {
            return this._strMgr.getString(this._cannotStopInstanceMessage, (Object)name);
        }

        public String getTimeoutStartingMessage(String name) {
            return this._strMgr.getString(this._timeoutStartingMessage, (Object)name);
        }
    }
}

