/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Engine;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.SystemApplications;
import java.beans.PropertyVetoException;
import java.util.Arrays;
import java.util.List;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

class ConsoleConfigCode
implements ConfigCode {
    private final List<String> virtualServers;
    private final String contextRoot;

    ConsoleConfigCode(List<String> virtualServers, String contextRoot) {
        this.virtualServers = virtualServers;
        this.contextRoot = contextRoot;
    }

    public Object run(ConfigBeanProxy ... proxies) throws PropertyVetoException, TransactionFailure {
        SystemApplications systemApplications = (SystemApplications)proxies[0];
        Application application = (Application)systemApplications.createChild(Application.class);
        systemApplications.getModules().add(application);
        application.setName("__admingui");
        application.setEnabled(Boolean.TRUE.toString());
        application.setObjectType("system-admin");
        application.setDirectoryDeployed("true");
        application.setContextRoot(this.contextRoot);
        try {
            application.setLocation("${com.sun.aas.installRootURI}/lib/install/applications/__admingui");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Module consoleModule = (Module)application.createChild(Module.class);
        application.getModule().add(consoleModule);
        consoleModule.setName(application.getName());
        Engine webEngine = (Engine)consoleModule.createChild(Engine.class);
        webEngine.setSniffer("web");
        Engine weldEngine = (Engine)consoleModule.createChild(Engine.class);
        weldEngine.setSniffer("weld");
        Engine securityEngine = (Engine)consoleModule.createChild(Engine.class);
        securityEngine.setSniffer("security");
        consoleModule.getEngines().add(webEngine);
        consoleModule.getEngines().add(weldEngine);
        consoleModule.getEngines().add(securityEngine);
        Server server = (Server)proxies[1];
        ApplicationRef applicationRef = (ApplicationRef)server.createChild(ApplicationRef.class);
        applicationRef.setRef(application.getName());
        applicationRef.setEnabled(Boolean.TRUE.toString());
        applicationRef.setVirtualServers(this.getVirtualServerList());
        server.getApplicationRef().add(applicationRef);
        return true;
    }

    private String getVirtualServerList() {
        if (this.virtualServers == null) {
            return "";
        }
        String servers = Arrays.toString(this.virtualServers.toArray(String[]::new));
        if (servers.startsWith("[") && servers.endsWith("]")) {
            servers = servers.substring(1, servers.length() - 1);
        }
        return servers;
    }
}

