/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import jakarta.enterprise.context.RequestScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import jakarta.security.enterprise.identitystore.openid.OpenIdContext;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.Reader;
import java.io.StringReader;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;

@RequestScoped
public class UserInfoController {
    @Inject
    private OpenIdContext context;
    private static final String APPLICATION_JWT = "application/jwt";
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String BEARER_TYPE = "Bearer ";
    private static final Logger LOGGER = Logger.getLogger(UserInfoController.class.getName());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject getUserInfo(OpenIdConfiguration configuration, AccessToken accessToken) {
        JsonObject userInfo;
        LOGGER.finest("Sending the request to the userinfo endpoint");
        Client client = ClientBuilder.newClient();
        WebTarget target = client.target(configuration.getProviderMetadata().getUserinfoEndpoint());
        Response response = target.request().accept(new String[]{"application/json"}).header(AUTHORIZATION_HEADER, (Object)(BEARER_TYPE + accessToken)).get();
        String responseBody = (String)response.readEntity(String.class);
        String contentType = response.getHeaderString("Content-Type");
        if (response.getStatus() != Response.Status.OK.getStatusCode()) {
            JsonObject responseObject = Json.createReader((Reader)new StringReader(responseBody)).readObject();
            String error = responseObject.getString("error", "Unknown Error");
            String errorDescription = responseObject.getString("error_description", "Unknown");
            LOGGER.log(Level.WARNING, "Error occurred in fetching user info: {0} caused by {1}", new Object[]{error, errorDescription});
            throw new IllegalStateException("Error occurred in fetching user info");
        }
        if (Objects.nonNull(contentType) && contentType.contains("application/json")) {
            try (JsonReader reader = Json.createReader((Reader)new StringReader(responseBody));){
                userInfo = reader.readObject();
            }
        } else {
            if (Objects.nonNull(contentType) && contentType.contains(APPLICATION_JWT)) {
                throw new UnsupportedOperationException("application/jwt content-type not supported for userinfo endpoint");
            }
            throw new IllegalStateException("Invalid response received from userinfo endpoint with content-type : " + contentType);
        }
        this.validateUserInfoClaims(userInfo);
        return userInfo;
    }

    private void validateUserInfoClaims(JsonObject userInfo) {
        if (!this.context.getSubject().equals(userInfo.getString("sub"))) {
            throw new IllegalStateException("UserInfo Response is invalid as sub claim must match with the sub Claim in the ID Token");
        }
    }
}

