/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.util;

import com.sun.faces.RIConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Set;

public class HtmlUtils {
    private static final Set<String> UTF_CHARSET;
    private static final char NO_CHAR = '\uffff';
    private static final char[] AMP_CHARS;
    private static final char[] QUOT_CHARS;
    private static final char[] GT_CHARS;
    private static final char[] LT_CHARS;
    private static final char[] EURO_CHARS;
    private static final char[] DEC_REF_START;
    private static final int MAX_BYTES_PER_CHAR = 10;
    private static final BitSet DONT_ENCODE_SET;
    private static char[][] sISO8859_1_Entities;
    private static char _LAST_EMPTY_ELEMENT_START;
    private static String[][] emptyElementArr;
    private static String[] aNames;
    private static String[] bNames;
    private static String[] cNames;
    private static String[] fNames;
    private static String[] hNames;
    private static String[] iNames;
    private static String[] lNames;
    private static String[] mNames;
    private static String[] pNames;

    public static void writeText(Writer out, boolean escapeUnicode, boolean escapeIsocode, char[] buffer, char[] text, boolean forXml) throws IOException {
        HtmlUtils.writeText(out, escapeUnicode, escapeIsocode, buffer, text, 0, text.length, forXml);
    }

    public static void writeText(Writer out, boolean escapeUnicode, boolean escapeIsocode, char[] buff, char[] text, int start, int length, boolean forXml) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            buffIndex = HtmlUtils.writeTextChar(out, escapeUnicode, escapeIsocode, text, i, text[i], buffIndex, buff, buffLength, forXml);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    public static void writeText(Writer out, boolean escapeUnicode, boolean escapeIsocode, char[] buff, String text, char[] textBuff, boolean forXml) throws IOException {
        int length = text.length();
        if (length >= 16) {
            text.getChars(0, length, textBuff, 0);
            HtmlUtils.writeText(out, escapeUnicode, escapeIsocode, buff, textBuff, 0, length, forXml);
        } else {
            int buffLength = buff.length;
            int buffIndex = 0;
            for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                buffIndex = HtmlUtils.writeTextChar(out, escapeUnicode, escapeIsocode, text, i, ch, buffIndex, buff, buffLength, forXml);
            }
            HtmlUtils.flushBuffer(out, buff, buffIndex);
        }
    }

    private static int writeTextChar(Writer out, boolean escapeUnicode, boolean escapeIsocode, Object originalChars, int charIndex, char ch, int buffIndex, char[] buff, int buffLength, boolean forXml) throws IOException {
        int nextIndex;
        if (ch <= '\u001f' && !HtmlUtils.isPrintableControlChar(ch, forXml)) {
            return buffIndex;
        }
        if (ch < '\u00a0') {
            nextIndex = ch >= '?' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch) : (ch >= '\'' ? (ch < '<' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch) : (ch == '<' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, LT_CHARS) : (ch == '>' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, GT_CHARS) : HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch)))) : (ch == '&' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, AMP_CHARS) : (ch == '\"' ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, "\"".toCharArray()) : HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch))));
        } else if (ch <= '\u00ff') {
            nextIndex = escapeIsocode ? HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, sISO8859_1_Entities[ch - 160]) : HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
        } else if (escapeUnicode) {
            nextIndex = HtmlUtils._writeDecRef(out, buff, buffIndex, buffLength, ch);
        } else {
            if (forXml && !HtmlUtils.isAllowedXmlCharacter(ch) && !HtmlUtils.isAllowedSurrogateCharacter(ch, charIndex, originalChars)) {
                return buffIndex;
            }
            nextIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
        }
        return nextIndex;
    }

    public static void writeAttribute(Writer out, boolean escapeUnicode, boolean escapeIsocode, char[] buff, String text, char[] textBuff, boolean isScriptInAttributeValueEnabled, boolean forXml) throws IOException {
        int length = text.length();
        if (length >= 16) {
            if (length > textBuff.length) {
                textBuff = new char[length * 2];
            }
            text.getChars(0, length, textBuff, 0);
            HtmlUtils.writeAttribute(out, escapeUnicode, escapeIsocode, buff, textBuff, 0, length, isScriptInAttributeValueEnabled, forXml);
        } else {
            int buffLength = buff.length;
            int buffIndex = 0;
            for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                if (ch <= '\u001f' && !HtmlUtils.isPrintableControlChar(ch, forXml)) continue;
                if (ch < '\u00a0') {
                    if (ch >= '?') {
                        if (ch == 's' && !isScriptInAttributeValueEnabled && i + 6 < text.length() && 'c' == text.charAt(i + 1) && 'r' == text.charAt(i + 2) && 'i' == text.charAt(i + 3) && 'p' == text.charAt(i + 4) && 't' == text.charAt(i + 5) && ':' == text.charAt(i + 6)) {
                            return;
                        }
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch >= '\'') {
                        if (ch < '<') {
                            buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                            continue;
                        }
                        if (ch == '<') {
                            buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, LT_CHARS);
                            continue;
                        }
                        if (ch == '>') {
                            buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, GT_CHARS);
                            continue;
                        }
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '&') {
                        if (i + 1 < length && text.charAt(i + 1) == '{') {
                            buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                            continue;
                        }
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, AMP_CHARS);
                        continue;
                    }
                    if (ch == '\"') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, QUOT_CHARS);
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch <= '\u00ff') {
                    if (escapeIsocode) {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, sISO8859_1_Entities[ch - 160]);
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (escapeUnicode) {
                    buffIndex = HtmlUtils._writeDecRef(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (forXml && !HtmlUtils.isAllowedXmlCharacter(ch) && !HtmlUtils.isAllowedSurrogateCharacter(ch, i, text)) continue;
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
            }
            HtmlUtils.flushBuffer(out, buff, buffIndex);
        }
    }

    public static void writeAttribute(Writer out, boolean escapeUnicode, boolean escapeIsocode, char[] buff, char[] text, int start, int length, boolean isScriptInAttributeValueEnabled, boolean forXml) throws IOException {
        int buffLength = buff.length;
        int buffIndex = 0;
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = text[i];
            if (ch <= '\u001f' && !HtmlUtils.isPrintableControlChar(ch, forXml)) continue;
            if (ch < '\u00a0') {
                if (ch >= '?') {
                    if (ch == 's' && !isScriptInAttributeValueEnabled && i + 6 < text.length && 'c' == text[i + 1] && 'r' == text[i + 2] && 'i' == text[i + 3] && 'p' == text[i + 4] && 't' == text[i + 5] && ':' == text[i + 6]) {
                        return;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch >= '\'') {
                    if (ch < '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    if (ch == '<') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, LT_CHARS);
                        continue;
                    }
                    if (ch == '>') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, GT_CHARS);
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                    continue;
                }
                if (ch == '&') {
                    if (i + 1 < end && text[i + 1] == '{') {
                        buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                        continue;
                    }
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, AMP_CHARS);
                    continue;
                }
                if (ch == '\"') {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, QUOT_CHARS);
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (ch <= '\u00ff') {
                if (escapeIsocode) {
                    buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, sISO8859_1_Entities[ch - 160]);
                    continue;
                }
                buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (escapeUnicode) {
                buffIndex = HtmlUtils._writeDecRef(out, buff, buffIndex, buffLength, ch);
                continue;
            }
            if (forXml && !HtmlUtils.isAllowedXmlCharacter(ch) && !HtmlUtils.isAllowedSurrogateCharacter(ch, i, text)) continue;
            buffIndex = HtmlUtils.addToBuffer(out, buff, buffIndex, buffLength, ch);
        }
        HtmlUtils.flushBuffer(out, buff, buffIndex);
    }

    private static boolean isPrintableControlChar(char ch, boolean forXml) {
        return ch == '\t' || ch == '\n' || ch == '\f' && !forXml || ch == '\r';
    }

    static boolean isAllowedXmlCharacter(char ch) {
        return ch < ' ' ? HtmlUtils.isPrintableControlChar(ch, true) : ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd';
    }

    private static boolean isAllowedSurrogateCharacter(char ch, int index, Object originalTextOrChars) {
        if (Character.isHighSurrogate(ch)) {
            return Character.isLowSurrogate(HtmlUtils.charAt(originalTextOrChars, index + 1));
        }
        if (Character.isLowSurrogate(ch)) {
            return Character.isHighSurrogate(HtmlUtils.charAt(originalTextOrChars, index - 1));
        }
        return false;
    }

    private static char charAt(Object originalTextOrChars, int index) {
        if (index < 0) {
            return '\uffff';
        }
        if (originalTextOrChars instanceof String) {
            String text = (String)originalTextOrChars;
            return index < text.length() ? text.charAt(index) : (char)'\uffff';
        }
        char[] chars = (char[])originalTextOrChars;
        return index < chars.length ? chars[index] : (char)'\uffff';
    }

    private static int _writeDecRef(Writer out, char[] buffer, int bufferIndex, int bufferLength, char ch) throws IOException {
        if (ch == 8364) {
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, EURO_CHARS);
            return bufferIndex;
        }
        bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, DEC_REF_START);
        int i = ch;
        if (i > 10000) {
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + i / 10000));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 10000) / 1000));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 1000) / 100));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 100) / 10));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 10)));
        } else if (i > 1000) {
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + i / 1000));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 1000) / 100));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 100) / 10));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 10)));
        } else {
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + i / 100));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 100) / 10));
            bufferIndex = HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, (char)(48 + (i %= 10)));
        }
        return HtmlUtils.addToBuffer(out, buffer, bufferIndex, bufferLength, ';');
    }

    private static int addToBuffer(Writer out, char[] buffer, int bufferIndex, int bufferLength, char ch) throws IOException {
        if (bufferIndex >= bufferLength) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        buffer[bufferIndex] = ch;
        return bufferIndex + 1;
    }

    private static int addToBuffer(Writer out, char[] buffer, int bufferIndex, int bufferLength, char[] toAdd) throws IOException {
        if (bufferIndex >= bufferLength || toAdd.length + bufferIndex >= bufferLength) {
            out.write(buffer, 0, bufferIndex);
            bufferIndex = 0;
        }
        System.arraycopy(toAdd, 0, buffer, bufferIndex, toAdd.length);
        return bufferIndex + toAdd.length;
    }

    private static int flushBuffer(Writer out, char[] buffer, int bufferIndex) throws IOException {
        if (bufferIndex > 0) {
            out.write(buffer, 0, bufferIndex);
        }
        return 0;
    }

    private HtmlUtils() {
    }

    public static void writeURL(Writer out, String text, char[] textBuff, String queryEncoding) throws IOException, UnsupportedEncodingException {
        int length = text.length();
        if (length >= 16) {
            text.getChars(0, length, textBuff, 0);
            HtmlUtils.writeURL(out, textBuff, 0, length, queryEncoding);
        } else {
            for (int i = 0; i < length; ++i) {
                char ch = text.charAt(i);
                if (ch < '!' || ch > '~') {
                    if (ch == ' ') {
                        out.write(43);
                        continue;
                    }
                    textBuff[i] = ch;
                    HtmlUtils.encodeURIString(out, textBuff, "UTF-8", i, i + 1);
                    continue;
                }
                if (ch == '\"') {
                    out.write("%22");
                    continue;
                }
                if (ch == '?') {
                    out.write(63);
                    HtmlUtils.encodeURIString(out, text, queryEncoding, i + 1);
                    return;
                }
                out.write(ch);
            }
        }
    }

    public static void writeURL(Writer out, char[] textBuff, int start, int len, String queryEncoding) throws IOException, UnsupportedEncodingException {
        int end = start + len;
        for (int i = start; i < end; ++i) {
            char ch = textBuff[i];
            if (ch < '!' || ch > '~') {
                HtmlUtils.encodeURIString(out, textBuff, "UTF-8", i, i + 1);
                continue;
            }
            if (ch == '\"') {
                out.write("%22");
                continue;
            }
            if (ch == '?') {
                out.write(63);
                HtmlUtils.encodeURIString(out, textBuff, queryEncoding, i + 1, end);
                return;
            }
            out.write(ch);
        }
    }

    public static void writeTextForXML(Writer out, String text, char[] outbuf) throws IOException {
        char[] textBuffer = new char[128];
        int len = text.length();
        if (textBuffer.length < len) {
            textBuffer = new char[len * 2];
        }
        HtmlUtils.writeText(out, true, true, outbuf, text, textBuffer, true);
    }

    public static void writeUnescapedTextForXML(Writer out, String text) throws IOException {
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char ch = text.charAt(i);
            if (!HtmlUtils.isAllowedXmlCharacter(ch) && !HtmlUtils.isAllowedSurrogateCharacter(ch, i, text)) continue;
            out.write(ch);
        }
    }

    private static void encodeURIString(Writer out, String text, String encoding, int start) throws IOException {
        MyByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        int length = text.length();
        for (int i = start; i < length; ++i) {
            char ch = text.charAt(i);
            if (DONT_ENCODE_SET.get(ch)) {
                if (ch == '&') {
                    if (i + 1 < length && HtmlUtils.isAmpEscaped(text, i + 1)) {
                        out.write(ch);
                        continue;
                    }
                    out.write(AMP_CHARS);
                    continue;
                }
                out.write(ch);
                continue;
            }
            if (buf == null) {
                buf = new MyByteArrayOutputStream(10);
                writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter((OutputStream)buf, RIConstants.CHAR_ENCODING);
                charArray = new char[1];
            }
            try {
                charArray[0] = ch;
                writer.write(charArray, 0, 1);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.getBuf();
            int size = buf.size();
            for (int j = 0; j < size; ++j) {
                HtmlUtils.writeURIDoubleHex(out, ba[j] + 256);
            }
            buf.reset();
        }
    }

    private static void encodeURIString(Writer out, char[] textBuff, String encoding, int start, int end) throws IOException {
        MyByteArrayOutputStream buf = null;
        OutputStreamWriter writer = null;
        char[] charArray = null;
        for (int i = start; i < end; ++i) {
            char ch = textBuff[i];
            if (DONT_ENCODE_SET.get(ch)) {
                if (ch == '&') {
                    if (i + 1 < end && HtmlUtils.isAmpEscaped(textBuff, i + 1)) {
                        out.write(ch);
                        continue;
                    }
                    out.write(AMP_CHARS);
                    continue;
                }
                out.write(ch);
                continue;
            }
            if (buf == null) {
                buf = new MyByteArrayOutputStream(10);
                writer = encoding != null ? new OutputStreamWriter((OutputStream)buf, encoding) : new OutputStreamWriter((OutputStream)buf, RIConstants.CHAR_ENCODING);
                charArray = new char[1];
            }
            try {
                charArray[0] = ch;
                writer.write(charArray, 0, 1);
                writer.flush();
            }
            catch (IOException e) {
                buf.reset();
                continue;
            }
            byte[] ba = buf.getBuf();
            int size = buf.size();
            for (int j = 0; j < size; ++j) {
                HtmlUtils.writeURIDoubleHex(out, ba[j] + 256);
            }
            buf.reset();
        }
    }

    private static boolean isAmpEscaped(String text, int idx) {
        int i = 1;
        int ix = idx;
        while (i < AMP_CHARS.length) {
            if (text.charAt(ix) != AMP_CHARS[i]) {
                return false;
            }
            ++i;
            ++ix;
        }
        return true;
    }

    private static boolean isAmpEscaped(char[] text, int idx) {
        int i = 1;
        int ix = idx;
        while (i < AMP_CHARS.length) {
            if (text[ix] != AMP_CHARS[i]) {
                return false;
            }
            ++i;
            ++ix;
        }
        return true;
    }

    private static void writeURIDoubleHex(Writer out, int i) throws IOException {
        out.write(37);
        out.write(HtmlUtils.intToHex((i >> 4) % 16));
        out.write(HtmlUtils.intToHex(i % 16));
    }

    private static char intToHex(int i) {
        if (i < 10) {
            return (char)(48 + i);
        }
        return (char)(65 + (i - 10));
    }

    public static boolean validateEncoding(String encoding) {
        return Charset.isSupported(encoding);
    }

    public static boolean isISO8859_1encoding(String encoding) {
        return "ISO-8859-1".equals(encoding);
    }

    public static boolean isUTFencoding(String encoding) {
        return UTF_CHARSET.contains(encoding);
    }

    public static boolean isEmptyElement(String name) {
        char firstChar = name.charAt(0);
        if (firstChar > _LAST_EMPTY_ELEMENT_START) {
            return false;
        }
        String[] array = emptyElementArr[firstChar];
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                if (!name.equalsIgnoreCase(array[i])) continue;
                return true;
            }
        }
        return false;
    }

    static {
        int i;
        UTF_CHARSET = new HashSet<String>(Arrays.asList("UTF-8", "UTF-16", "UTF-16BE", "UTF-16LE", "UTF-32", "UTF-32BE", "UTF-32LE", "x-UTF-16LE-BOM", "X-UTF-32BE-BOM", "X-UTF-32LE-BOM", ""));
        AMP_CHARS = "&amp;".toCharArray();
        QUOT_CHARS = "&quot;".toCharArray();
        GT_CHARS = "&gt;".toCharArray();
        LT_CHARS = "&lt;".toCharArray();
        EURO_CHARS = "&euro;".toCharArray();
        DEC_REF_START = "&#".toCharArray();
        DONT_ENCODE_SET = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            DONT_ENCODE_SET.set(i);
        }
        DONT_ENCODE_SET.set(37);
        DONT_ENCODE_SET.set(43);
        DONT_ENCODE_SET.set(35);
        DONT_ENCODE_SET.set(38);
        DONT_ENCODE_SET.set(61);
        DONT_ENCODE_SET.set(45);
        DONT_ENCODE_SET.set(95);
        DONT_ENCODE_SET.set(46);
        DONT_ENCODE_SET.set(42);
        DONT_ENCODE_SET.set(126);
        DONT_ENCODE_SET.set(47);
        DONT_ENCODE_SET.set(39);
        DONT_ENCODE_SET.set(33);
        DONT_ENCODE_SET.set(40);
        DONT_ENCODE_SET.set(41);
        DONT_ENCODE_SET.set(59);
        sISO8859_1_Entities = new char[][]{"&nbsp;".toCharArray(), "&iexcl;".toCharArray(), "&cent;".toCharArray(), "&pound;".toCharArray(), "&curren;".toCharArray(), "&yen;".toCharArray(), "&brvbar;".toCharArray(), "&sect;".toCharArray(), "&uml;".toCharArray(), "&copy;".toCharArray(), "&ordf;".toCharArray(), "&laquo;".toCharArray(), "&not;".toCharArray(), "&shy;".toCharArray(), "&reg;".toCharArray(), "&macr;".toCharArray(), "&deg;".toCharArray(), "&plusmn;".toCharArray(), "&sup2;".toCharArray(), "&sup3;".toCharArray(), "&acute;".toCharArray(), "&micro;".toCharArray(), "&para;".toCharArray(), "&middot;".toCharArray(), "&cedil;".toCharArray(), "&sup1;".toCharArray(), "&ordm;".toCharArray(), "&raquo;".toCharArray(), "&frac14;".toCharArray(), "&frac12;".toCharArray(), "&frac34;".toCharArray(), "&iquest;".toCharArray(), "&Agrave;".toCharArray(), "&Aacute;".toCharArray(), "&Acirc;".toCharArray(), "&Atilde;".toCharArray(), "&Auml;".toCharArray(), "&Aring;".toCharArray(), "&AElig;".toCharArray(), "&Ccedil;".toCharArray(), "&Egrave;".toCharArray(), "&Eacute;".toCharArray(), "&Ecirc;".toCharArray(), "&Euml;".toCharArray(), "&Igrave;".toCharArray(), "&Iacute;".toCharArray(), "&Icirc;".toCharArray(), "&Iuml;".toCharArray(), "&ETH;".toCharArray(), "&Ntilde;".toCharArray(), "&Ograve;".toCharArray(), "&Oacute;".toCharArray(), "&Ocirc;".toCharArray(), "&Otilde;".toCharArray(), "&Ouml;".toCharArray(), "&times;".toCharArray(), "&Oslash;".toCharArray(), "&Ugrave;".toCharArray(), "&Uacute;".toCharArray(), "&Ucirc;".toCharArray(), "&Uuml;".toCharArray(), "&Yacute;".toCharArray(), "&THORN;".toCharArray(), "&szlig;".toCharArray(), "&agrave;".toCharArray(), "&aacute;".toCharArray(), "&acirc;".toCharArray(), "&atilde;".toCharArray(), "&auml;".toCharArray(), "&aring;".toCharArray(), "&aelig;".toCharArray(), "&ccedil;".toCharArray(), "&egrave;".toCharArray(), "&eacute;".toCharArray(), "&ecirc;".toCharArray(), "&euml;".toCharArray(), "&igrave;".toCharArray(), "&iacute;".toCharArray(), "&icirc;".toCharArray(), "&iuml;".toCharArray(), "&eth;".toCharArray(), "&ntilde;".toCharArray(), "&ograve;".toCharArray(), "&oacute;".toCharArray(), "&ocirc;".toCharArray(), "&otilde;".toCharArray(), "&ouml;".toCharArray(), "&divide;".toCharArray(), "&oslash;".toCharArray(), "&ugrave;".toCharArray(), "&uacute;".toCharArray(), "&ucirc;".toCharArray(), "&uuml;".toCharArray(), "&yacute;".toCharArray(), "&thorn;".toCharArray(), "&yuml;".toCharArray()};
        _LAST_EMPTY_ELEMENT_START = (char)112;
        emptyElementArr = new String[_LAST_EMPTY_ELEMENT_START + '\u0001'][];
        aNames = new String[]{"area"};
        bNames = new String[]{"br", "base", "basefont"};
        cNames = new String[]{"col"};
        fNames = new String[]{"frame"};
        hNames = new String[]{"hr"};
        iNames = new String[]{"img", "input", "isindex"};
        lNames = new String[]{"link"};
        mNames = new String[]{"meta"};
        pNames = new String[]{"param"};
        HtmlUtils.emptyElementArr[97] = aNames;
        HtmlUtils.emptyElementArr[65] = aNames;
        HtmlUtils.emptyElementArr[98] = bNames;
        HtmlUtils.emptyElementArr[66] = bNames;
        HtmlUtils.emptyElementArr[99] = cNames;
        HtmlUtils.emptyElementArr[67] = cNames;
        HtmlUtils.emptyElementArr[102] = fNames;
        HtmlUtils.emptyElementArr[70] = fNames;
        HtmlUtils.emptyElementArr[104] = hNames;
        HtmlUtils.emptyElementArr[72] = hNames;
        HtmlUtils.emptyElementArr[105] = iNames;
        HtmlUtils.emptyElementArr[73] = iNames;
        HtmlUtils.emptyElementArr[108] = lNames;
        HtmlUtils.emptyElementArr[76] = lNames;
        HtmlUtils.emptyElementArr[109] = mNames;
        HtmlUtils.emptyElementArr[77] = mNames;
        HtmlUtils.emptyElementArr[112] = pNames;
        HtmlUtils.emptyElementArr[80] = pNames;
    }

    private static class MyByteArrayOutputStream
    extends ByteArrayOutputStream {
        public MyByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        public byte[] getBuf() {
            return this.buf;
        }
    }
}

