/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.modules.locked;

import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyContext;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebResourcePermission;
import jakarta.security.jacc.WebRoleRefPermission;
import jakarta.security.jacc.WebUserDataPermission;
import java.security.CodeSource;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.text.MessageFormat;
import javax.management.MBeanPermission;
import org.glassfish.exousia.modules.locked.SimplePolicyConfiguration;

public class SimplePolicyProvider
extends Policy {
    private static final System.Logger LOG = System.getLogger(SimplePolicyProvider.class.getName());
    private static final String REUSE = "java.security.Policy.supportsReuse";
    private Policy basePolicy = Policy.getPolicy();
    private static ThreadLocal<Object> reentrancyStatus = new ThreadLocal<Object>(){

        @Override
        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };

    public SimplePolicyProvider() {
        if (this.basePolicy == null) {
            try {
                this.basePolicy = Policy.getInstance("JavaPolicy", null);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(codesource);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, codesource);
        }
        catch (PolicyContextException e) {
            LOG.log(System.Logger.Level.INFO, () -> MessageFormat.format("getPermissions call failed for the policy context ID {0} and {1}", PolicyContext.getContextID(), codesource), (Throwable)e);
        }
        return permissionCollection;
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        PermissionCollection permissionCollection = this.basePolicy.getPermissions(domain);
        try {
            permissionCollection = SimplePolicyConfiguration.getPermissions(permissionCollection, domain);
        }
        catch (PolicyContextException e) {
            LOG.log(System.Logger.Level.INFO, () -> MessageFormat.format("getPermissions call failed for the policy context ID {0} and {1}", PolicyContext.getContextID(), domain), (Throwable)e);
        }
        return permissionCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (alreadyCalled[0] == 1) {
            return true;
        }
        alreadyCalled[0] = 1;
        try {
            boolean bl = this.doImplies(domain, permission);
            return bl;
        }
        finally {
            alreadyCalled[0] = 0;
        }
    }

    private boolean doImplies(ProtectionDomain domain, Permission permission) {
        int implies = 1;
        try {
            implies = SimplePolicyConfiguration.implies(domain, permission);
            if (implies > 0) {
                LOG.log(System.Logger.Level.TRACE, "SimplePolicyConfiguration returned implies = {0}, returning true.", implies);
                return true;
            }
        }
        catch (PolicyContextException e) {
            LOG.log(System.Logger.Level.TRACE, "SimplePolicyConfiguration.implies failed.", (Throwable)e);
        }
        boolean doImplies = false;
        if (implies == 0) {
            doImplies = this.basePolicy.implies(domain, permission);
        }
        LOG.log(System.Logger.Level.TRACE, "Result - implies = {0}, doImplies = {1}", implies, doImplies);
        if (!doImplies && SimplePolicyProvider.permissionShouldBeLogged(permission)) {
            LOG.log(System.Logger.Level.DEBUG, "Access refused for the policy context id {0}, permission {1} and protection domain {2}.", PolicyContext.getContextID(), permission, domain);
        }
        return doImplies;
    }

    @Override
    public void refresh() {
        this.basePolicy.refresh();
        try {
            boolean supportsReuse;
            String propValue = System.getProperty(REUSE);
            boolean bl = supportsReuse = propValue == null ? true : Boolean.parseBoolean(propValue);
            if (supportsReuse && PolicyContext.getHandlerKeys().contains(REUSE)) {
                PolicyContext.getContext((String)REUSE);
            }
            SimplePolicyConfiguration.refresh();
        }
        catch (PolicyContextException pce) {
            throw new IllegalStateException("Refresh failed", pce);
        }
    }

    private static boolean permissionShouldBeLogged(Permission permission) {
        return !(permission instanceof WebResourcePermission) && !(permission instanceof WebUserDataPermission) && !(permission instanceof MBeanPermission) && !(permission instanceof WebRoleRefPermission) && !(permission instanceof EJBRoleRefPermission);
    }
}

