/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.jcraft.jsch.ChannelSftp;
import com.sun.enterprise.admin.cli.cluster.Constants;
import com.sun.enterprise.admin.cli.cluster.InstallNodeBaseCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.util.SystemPropertyConstants;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.launcher.SSHException;
import org.glassfish.cluster.ssh.launcher.SSHLauncher;
import org.glassfish.cluster.ssh.launcher.SSHSession;
import org.glassfish.cluster.ssh.sftp.SFTPClient;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.cluster.ssh.util.SSHUtil;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="install-node-ssh")
@PerLookup
public class InstallNodeSshCommand
extends InstallNodeBaseCommand {
    private static final String GF_DIR_NAME = "glassfish";
    private static final SFTPPath PATH_REL_DOMAINS = SFTPPath.ofRelativePath((String[])new String[]{"glassfish", "domains"});
    private static final SFTPPath PATH_REL_NODES = SFTPPath.ofRelativePath((String[])new String[]{"glassfish", "nodes"});
    @Param(name="sshuser", optional=true, defaultValue="${user.name}")
    private String user;
    @Param(optional=true, defaultValue="22", name="sshport")
    int port;
    @Param(optional=true)
    String sshkeyfile;
    private final Map<String, char[]> sshPasswords = new HashMap<String, char[]>();

    @Override
    String getRawRemoteUser() {
        return this.user;
    }

    @Override
    int getRawRemotePort() {
        return this.port;
    }

    @Override
    String getSshKeyFile() {
        return this.sshkeyfile;
    }

    @Override
    protected void validate() throws CommandException {
        super.validate();
        if (this.sshkeyfile == null) {
            File existingKey = SSHUtil.getExistingKeyFile();
            if (existingKey == null) {
                this.promptPass = true;
            } else {
                this.sshkeyfile = existingKey.getAbsolutePath();
            }
        } else {
            this.validateKey(this.sshkeyfile);
        }
        if (this.sshkeyfile != null && SSHUtil.isEncryptedKey((File)new File(this.sshkeyfile))) {
            this.sshkeypassphrase = this.getSSHPassphrase(true);
        }
    }

    @Override
    void copyToHosts(File zipFile, List<SFTPPath> binDirFiles) throws CommandException {
        try {
            this.copyToHostsInternal(zipFile, binDirFiles);
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (SSHException e) {
            logger.log(Level.SEVERE, "Failed to copy zip file " + String.valueOf(zipFile) + " and to make binary files " + String.valueOf(binDirFiles) + " executable.", e);
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    private void copyToHostsInternal(File zipFile, List<SFTPPath> binDirFiles) throws SSHException, CommandException {
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            File keyFile = this.getSshKeyFile() == null ? null : new File(this.getSshKeyFile());
            SSHLauncher sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, keyFile, this.sshkeypassphrase);
            if (this.getSshKeyFile() != null && !sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = this.sshPasswords.containsKey(host) ? String.valueOf(this.sshPasswords.get(host)) : this.getSSHPassword(host);
                sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), sshpass, keyFile, this.sshkeypassphrase);
                prompt = false;
            }
            SFTPPath sshInstallDir = SFTPPath.of((File)new File(this.getInstallDir()));
            try (SSHSession session = sshLauncher.openSession();
                 SFTPClient sftp = session.createSFTPClient();){
                SFTPPath backupDir;
                if (sftp.exists(sshInstallDir)) {
                    backupDir = this.createBackup(sftp, sshInstallDir);
                    sftp.rmDir(sshInstallDir, true, new SFTPPath[0]);
                } else {
                    backupDir = null;
                }
                sftp.mkdirs(sshInstallDir);
                if (sshLauncher.getCapabilities().isChmodSupported()) {
                    sftp.chmod(sshInstallDir, 493);
                }
                SFTPPath remoteZipFile = sshInstallDir.resolve(zipFile.getName());
                logger.info(() -> "Copying " + String.valueOf(zipFile) + " (" + zipFile.length() + " bytes) to " + host + ":" + String.valueOf(remoteZipFile));
                sftp.put(zipFile, remoteZipFile);
                logger.finer(() -> "Copied " + String.valueOf(zipFile) + " to " + host + ":" + String.valueOf(remoteZipFile));
                logger.info(() -> "Unpacking " + String.valueOf(remoteZipFile) + " on " + host + " to " + String.valueOf(sshInstallDir));
                session.unzip(remoteZipFile, (Path)sshInstallDir);
                logger.finer(() -> "Unpacked " + this.getArchiveName() + " into " + host + ":" + String.valueOf(sshInstallDir));
                logger.info(() -> "Removing " + host + ":" + String.valueOf(remoteZipFile));
                sftp.rm(remoteZipFile);
                logger.finer(() -> "Removed " + host + ":" + String.valueOf(remoteZipFile));
                if (sshLauncher.getCapabilities().isChmodSupported()) {
                    logger.info(() -> "Fixing file permissions of all bin files under " + host + ":" + String.valueOf(sshInstallDir));
                    if (binDirFiles.isEmpty()) {
                        this.searchAndFixBinDirectoryFiles(sshInstallDir, sftp);
                    } else {
                        for (SFTPPath binDirFile : binDirFiles) {
                            sftp.chmod(sshInstallDir.resolve((Path)binDirFile), 493);
                        }
                    }
                    logger.finer(() -> "Fixed file permissions of all bin files under " + host + ":" + String.valueOf(sshInstallDir));
                }
                if (backupDir == null) continue;
                List dirs = sftp.ls(backupDir, e -> e.getAttrs().isDir());
                for (String dirName : dirs) {
                    SFTPPath target = sshInstallDir.resolve((Path)SFTPPath.ofRelativePath((String[])new String[]{GF_DIR_NAME, dirName}));
                    sftp.mv(backupDir.resolve(dirName), target);
                }
                sftp.rmDir(backupDir, false, new SFTPPath[0]);
                logger.log(Level.INFO, "Successfuly restored domains and nodes from previous installation.");
            }
        }
    }

    private SFTPPath createBackup(SFTPClient sftp, SFTPPath sshInstallDir) throws SSHException {
        SFTPPath origDomainsPath = sshInstallDir.resolve((Path)PATH_REL_DOMAINS);
        SFTPPath origNodesPath = sshInstallDir.resolve((Path)PATH_REL_NODES);
        boolean origDomainsExist = sftp.existsDirectory(origDomainsPath);
        boolean origNodesExist = sftp.existsDirectory(origNodesPath);
        if (!origDomainsExist && !origNodesExist) {
            return null;
        }
        SFTPPath backupDir = sshInstallDir.getParent().resolve("tmp-upgrade-backup");
        logger.log(Level.INFO, "Creating backup, domains: {0}, nodes: {1} into {2}", new Object[]{origDomainsExist, origNodesExist, backupDir});
        if (sftp.existsDirectory(backupDir)) {
            throw new SSHException("The backup directory already exists, probably some failed previous upgrade?");
        }
        sftp.mkdirs(backupDir);
        if (origDomainsExist) {
            sftp.mv(origDomainsPath, backupDir.resolve("domains"));
        }
        if (origNodesExist) {
            sftp.mv(origNodesPath, backupDir.resolve("nodes"));
        }
        return backupDir;
    }

    private void searchAndFixBinDirectoryFiles(SFTPPath dir, SFTPClient sftpClient) throws SSHException {
        for (ChannelSftp.LsEntry entry : sftpClient.lsDetails(dir, e -> true)) {
            SFTPPath subPath = dir.resolve(entry.getFilename());
            if (entry.getAttrs().isDir()) {
                if (entry.getFilename().equals("bin")) {
                    this.fixFilePermissions(subPath, sftpClient);
                    continue;
                }
                this.searchAndFixBinDirectoryFiles(subPath, sftpClient);
                continue;
            }
            if (!"nadmin".equals(entry.getFilename())) continue;
            sftpClient.chmod(subPath, 493);
        }
    }

    private void fixFilePermissions(SFTPPath binDir, SFTPClient sftpClient) throws SSHException {
        for (String directoryEntry : sftpClient.ls(binDir, entry -> !entry.getAttrs().isDir())) {
            sftpClient.chmod(binDir.resolve(directoryEntry), 493);
        }
    }

    @Override
    final void precopy() throws CommandException {
        if (this.getForce()) {
            return;
        }
        boolean prompt = this.promptPass;
        for (String host : this.hosts) {
            File keyFile = this.getSshKeyFile() == null ? null : new File(this.getSshKeyFile());
            SSHLauncher sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), this.sshpassword, keyFile, this.sshkeypassphrase);
            if (keyFile != null && !sshLauncher.checkConnection()) {
                prompt = true;
            }
            if (prompt) {
                String sshpass = this.getSSHPassword(host);
                this.sshPasswords.put(host, sshpass.toCharArray());
                sshLauncher = new SSHLauncher(this.getRemoteUser(), host, this.getRemotePort(), sshpass, keyFile, this.sshkeypassphrase);
                prompt = false;
            }
            SFTPPath sshInstallDir = SFTPPath.of((String)this.getInstallDir());
            try (SSHSession session = sshLauncher.openSession();
                 SFTPClient sftpClient = session.createSFTPClient();){
                if (!sftpClient.exists(sshInstallDir)) continue;
                this.checkIfAlreadyInstalled(session, host, (Path)sshInstallDir);
            }
            catch (IOException ex) {
                throw new CommandException((Throwable)ex);
            }
        }
    }

    private void checkIfAlreadyInstalled(SSHSession session, String host, Path sshInstallDir) throws CommandException, SSHException {
        String asadmin = Constants.v4 ? "/lib/nadmin" : "/bin/asadmin";
        String cmd = "\"" + String.valueOf(sshInstallDir) + "/" + SystemPropertyConstants.getComponentName() + asadmin + "\" version --local --terse";
        int status = session.exec(cmd);
        if (status == 0) {
            throw new CommandException(Strings.get("install.dir.exists", sshInstallDir));
        }
    }
}

