/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.event;

import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.component.TextField;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.component.UIComponent;
import jakarta.faces.event.AbortProcessingException;
import jakarta.faces.event.ActionEvent;
import jakarta.faces.event.ActionListener;
import java.util.Iterator;

public final class TablePaginationActionListener
implements ActionListener {
    public void processAction(ActionEvent event) throws AbortProcessingException {
        if (event != null) {
            UIComponent source = (UIComponent)event.getSource();
            TablePaginationActionListener.processTable(TablePaginationActionListener.getTableAncestor(source), source.getId());
        } else {
            TablePaginationActionListener.log("processAction", "Cannot process action, ActionEvent source is null");
        }
    }

    private static void processTable(Table component, String id) throws AbortProcessingException {
        if (component == null) {
            TablePaginationActionListener.log("processTable", "Cannot process Table action, Table is null");
            return;
        }
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            if (id.equals("_paginationFirstButton")) {
                TablePaginationActionListener.setFirst(group);
                continue;
            }
            if (id.equals("_paginationLastButton")) {
                TablePaginationActionListener.setLast(group);
                continue;
            }
            if (id.equals("_paginationNextButton")) {
                TablePaginationActionListener.setNext(group);
                continue;
            }
            if (id.equals("_paginateButton")) {
                TablePaginationActionListener.setPaginated(group);
                continue;
            }
            if (id.equals("_paginationPrevButton")) {
                TablePaginationActionListener.setPrev(group);
                continue;
            }
            if (!id.equals("_paginationSubmitButton")) continue;
            try {
                TablePaginationActionListener.setPage(group, TablePaginationActionListener.getPage(component));
            }
            catch (NumberFormatException e) {
                TablePaginationActionListener.log("processTable", "Cannot obtain page field value");
                return;
            }
        }
    }

    private static Table getTableAncestor(UIComponent component) {
        if (component == null) {
            TablePaginationActionListener.log("getTableAncestor", "Cannot obtain Table ancestor, UIComponent is null");
            return null;
        }
        if (component instanceof Table) {
            return (Table)component;
        }
        return TablePaginationActionListener.getTableAncestor(component.getParent());
    }

    private static int getPage(Table component) {
        UIComponent actions = component.getFacet("_tableActionsBottom");
        UIComponent field = actions != null ? actions.getFacet("_paginationPageField") : null;
        String value = null;
        if (field instanceof TextField) {
            value = ConversionUtilities.convertValueToString(field, ((TextField)field).getValue());
        } else {
            TablePaginationActionListener.log("getPage", "Cannot obtain page text field value, not TextField instance");
        }
        if (value != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    private static void setPage(TableRowGroup component, int page) {
        if (component == null) {
            TablePaginationActionListener.log("setPage", "Cannot set page, TableRowGroup is null");
            return;
        }
        component.setPage(page);
    }

    private static void setFirst(TableRowGroup component) {
        if (component == null) {
            TablePaginationActionListener.log("setFirst", "Canot set first row, TableRowGroup is null");
            return;
        }
        component.setPage(1);
    }

    private static void setLast(TableRowGroup component) {
        if (component == null) {
            TablePaginationActionListener.log("setLast", "Cannot set last row, TableRowGroup is null");
            return;
        }
        component.setPage(component.getPages());
    }

    private static void setNext(TableRowGroup component) {
        if (component == null) {
            TablePaginationActionListener.log("setNext", "Cannot set next row, TableRowGroup is null");
            return;
        }
        component.setPage(component.getPage() + 1);
    }

    private static void setPaginated(TableRowGroup component) {
        if (component == null) {
            TablePaginationActionListener.log("setPaginated", "Cannot set paginated, TableRowGroup is null");
            return;
        }
        component.setPaginated(!component.isPaginated());
    }

    private static void setPrev(TableRowGroup component) {
        if (component == null) {
            TablePaginationActionListener.log("setPrev", "Cannot set previous row, TableRowGroup is null");
            return;
        }
        component.setPage(component.getPage() - 1);
    }

    private static void log(String method, String message) {
        Class<TablePaginationActionListener> clazz = TablePaginationActionListener.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + message);
        }
    }
}

