/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.NamedDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReference;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.util.Objects;
import org.glassfish.api.naming.SimpleJndiName;

public class ResourceEnvReferenceDescriptor
extends EnvironmentProperty
implements NamedDescriptor,
ResourceEnvReference {
    private static final long serialVersionUID = 1L;
    private static final String SESSION_CTX_TYPE = "jakarta.ejb.SessionContext";
    private static final String MDB_CTX_TYPE = "jakarta.ejb.MessageDrivenContext";
    private static final String EJB_CTX_TYPE = "jakarta.ejb.EJBContext";
    private static final String EJB_TIMER_SERVICE_TYPE = "jakarta.ejb.TimerService";
    private static final String VALIDATION_VALIDATOR = "jakarta.validation.Validator";
    private static final String VALIDATION_VALIDATOR_FACTORY = "jakarta.validation.ValidatorFactory";
    private static final String CDI_BEAN_MANAGER_TYPE = "jakarta.enterprise.inject.spi.BeanManager";
    private String refType;
    private boolean isManagedBean;
    private ManagedBeanDescriptor managedBeanDesc;

    public ResourceEnvReferenceDescriptor() {
    }

    public ResourceEnvReferenceDescriptor(String name, String description, String refType) {
        super(name, "", description);
        this.refType = refType;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public String getRefType() {
        return this.refType;
    }

    @Override
    public String getInjectResourceType() {
        return this.getRefType();
    }

    @Override
    public void setInjectResourceType(String refType) {
        this.setRefType(refType);
    }

    public void setIsManagedBean(boolean flag) {
        this.isManagedBean = flag;
    }

    public boolean isManagedBean() {
        return this.isManagedBean;
    }

    public void setManagedBeanDescriptor(ManagedBeanDescriptor desc) {
        this.managedBeanDesc = desc;
    }

    public ManagedBeanDescriptor getManagedBeanDescriptor() {
        return this.managedBeanDesc;
    }

    @Override
    public SimpleJndiName getJndiName() {
        String jndiName = this.getValue();
        if (!jndiName.isEmpty()) {
            return new SimpleJndiName(jndiName);
        }
        if (this.mappedName != null && !this.mappedName.isEmpty()) {
            return this.mappedName;
        }
        return this.lookupName;
    }

    @Override
    public void setJndiName(SimpleJndiName jndiName) {
        this.setValue(jndiName == null ? null : jndiName.toString());
    }

    public boolean isEJBContext() {
        return this.getRefType().equals(SESSION_CTX_TYPE) || this.getRefType().equals(MDB_CTX_TYPE) || this.getRefType().equals(EJB_CTX_TYPE) || this.getRefType().equals(EJB_TIMER_SERVICE_TYPE);
    }

    public boolean isValidator() {
        return this.getRefType().equals(VALIDATION_VALIDATOR);
    }

    public boolean isValidatorFactory() {
        return this.getRefType().equals(VALIDATION_VALIDATOR_FACTORY);
    }

    public boolean isCDIBeanManager() {
        return this.getRefType().equals(CDI_BEAN_MANAGER_TYPE);
    }

    public boolean isConflict(ResourceReferenceDescriptor other) {
        return this.getName().equals(other.getName()) && (!DOLUtils.equals(this.getType(), other.getType()) || this.isConflictResourceGroup(other));
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ResourceEnvReference) {
            ResourceEnvReference destReference = (ResourceEnvReference)object;
            return destReference.getName().equals(this.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getName());
    }

    public void checkType() {
        block5: {
            if (this.refType == null) {
                if (ResourceEnvReferenceDescriptor.isBoundsChecking()) {
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{"null"}));
                }
            } else {
                try {
                    Class.forName(this.refType, true, Thread.currentThread().getContextClassLoader());
                }
                catch (Throwable t) {
                    if (!ResourceEnvReferenceDescriptor.isBoundsChecking()) break block5;
                    throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptiontypenotallowedpropertytype", "{0} is not an allowed property value type", new Object[]{this.refType}));
                }
            }
        }
    }
}

