/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.resources.admin;

import com.sun.enterprise.admin.remote.ParamsWithPayload;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.collections.ManifestUtils;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.uuid.UuidGenerator;
import com.sun.enterprise.util.uuid.UuidGeneratorImpl;
import com.sun.enterprise.v3.admin.AdminCommandJob;
import com.sun.enterprise.v3.admin.AsyncAdminCommandInvoker;
import com.sun.enterprise.v3.common.ActionReporter;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import com.sun.enterprise.v3.common.PropsFileActionReporter;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.CookieParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import javax.security.auth.Subject;
import org.glassfish.admin.rest.RestLogging;
import org.glassfish.admin.rest.utils.DetachedSseAdminCommandInvoker;
import org.glassfish.admin.rest.utils.SseAdminCommandInvoker;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.CommandInvocation;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.glassfish.jersey.internal.util.collection.Ref;

@Path(value="/")
public class CommandResource {
    private static final LocalStringManagerImpl strings = new LocalStringManagerImpl(CommandResource.class);
    private static final String SESSION_COOKIE_NAME = "JSESSIONID";
    private static final int MAX_AGE = 86400;
    private static UuidGenerator uuidGenerator = new UuidGeneratorImpl();
    private static volatile String serverName;
    private CommandRunner<AdminCommandJob> commandRunner;
    @Inject
    private Ref<Subject> subjectRef;

    @GET
    @Path(value="/{command:.*}/")
    @Produces(value={"application/json", "application/x-javascript"})
    public Response getCommandModel(@PathParam(value="command") String command) throws WebApplicationException {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "getCommandModel({0})", commandName);
        CommandModel model = this.getCommandModel(commandName);
        String eTag = CachedCommandModel.computeETag((CommandModel)model);
        return Response.ok((Object)model).tag(new EntityTag(eTag, true)).build();
    }

    @OPTIONS
    @Path(value="/{command:.*}/")
    @Produces(value={"application/json", "application/x-javascript"})
    public Response optionsCommandModel(@PathParam(value="command") String commandName) throws WebApplicationException {
        return this.getCommandModel(commandName);
    }

    @GET
    @Path(value="/{command:.*}/manpage")
    @Produces(value={"text/html"})
    public String getManPageHtml(@PathParam(value="command") String command) throws IOException, WebApplicationException {
        String line;
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "getManPageHtml({0})", commandName);
        BufferedReader help = this.getManPageReader(commandName);
        if (help == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append("<html><body>");
        while ((line = help.readLine()) != null) {
            result.append(CommandResource.leadingSpacesToNbsp(StringUtils.escapeForHtml((String)line))).append("<br/>\n");
        }
        result.append("</body></html>");
        return result.toString();
    }

    @GET
    @Path(value="/{command:.*}/manpage")
    @Produces(value={"text/plain"})
    public String getManPageTxt(@PathParam(value="command") String command, @QueryParam(value="eol") String eol) throws IOException, WebApplicationException {
        String line;
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "getManPageTxt({0}, {1})", new Object[]{commandName, eol});
        BufferedReader help = this.getManPageReader(commandName);
        if (help == null) {
            return null;
        }
        if (!StringUtils.ok((String)eol)) {
            eol = ManifestUtils.EOL;
        }
        StringBuilder result = new StringBuilder();
        while ((line = help.readLine()) != null) {
            result.append(line).append(eol);
        }
        return result.toString();
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json", "application/x-javascript"})
    public Response execCommandSimpInSimpOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParameterMap data) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandSimpInSimpOut({0})", commandName);
        return this.executeCommand(commandName, null, data, false, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json", "application/x-javascript"})
    public Response execCommandMultInSimpOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParamsWithPayload pwp) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandMultInSimpOut({0})", commandName);
        ParameterMap data = null;
        RestPayloadImpl.Inbound inbound = null;
        if (pwp != null) {
            data = pwp.getParameters();
            inbound = pwp.getPayloadInbound();
        }
        return this.executeCommand(commandName, (Payload.Inbound)inbound, data, false, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Produces(value={"application/json", "application/x-javascript"})
    public Response execCommandEmptyInSimpOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandEmptyInSimpOut({0})", commandName);
        ParameterMap data = new ParameterMap();
        return this.executeCommand(commandName, null, data, false, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"multipart/mixed"})
    public Response execCommandSimpInMultOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParameterMap data) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandSimpInMultOut({0})", commandName);
        return this.executeCommand(commandName, null, data, true, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"multipart/mixed"})
    public Response execCommandMultInMultOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParamsWithPayload pwp) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandMultInMultOut({0})", commandName);
        ParameterMap data = null;
        RestPayloadImpl.Inbound inbound = null;
        if (pwp != null) {
            data = pwp.getParameters();
            inbound = pwp.getPayloadInbound();
        }
        return this.executeCommand(commandName, (Payload.Inbound)inbound, data, true, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Produces(value={"multipart/mixed"})
    public Response execCommandEmptyInMultOut(@PathParam(value="command") String command, @HeaderParam(value="X-Indent") String indent, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandEmptyInMultOut({0})", commandName);
        ParameterMap data = new ParameterMap();
        return this.executeCommand(commandName, null, data, true, indent, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/event-stream"})
    public Response execCommandSimpInSseOut(@PathParam(value="command") String command, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParameterMap data) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandSimpInSseOut({0})", commandName);
        return this.executeSseCommand(commandName, null, data, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"text/event-stream"})
    public Response execCommandMultInSseOut(@PathParam(value="command") String command, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId, ParamsWithPayload pwp) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandMultInMultOut({0})", commandName);
        ParameterMap data = null;
        if (pwp != null) {
            data = pwp.getParameters();
        }
        return this.executeSseCommand(commandName, null, data, modelETag, jSessionId);
    }

    @POST
    @Path(value="/{command:.*}/")
    @Produces(value={"text/event-stream"})
    public Response execCommandEmptyInSseOut(@PathParam(value="command") String command, @HeaderParam(value="X-If-Command-Model-Match") String modelETag, @CookieParam(value="JSESSIONID") Cookie jSessionId) {
        CommandName commandName = new CommandName(this.normalizeCommandName(command));
        RestLogging.restLogger.log(Level.FINEST, "execCommandEmptyInMultOut({0})", commandName);
        ParameterMap data = new ParameterMap();
        return this.executeSseCommand(commandName, null, data, modelETag, jSessionId);
    }

    private String normalizeCommandName(String str) {
        if (str == null) {
            return null;
        }
        if (str.endsWith("/")) {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    private void checkCommandModelETag(CommandModel model, String modelETag) throws WebApplicationException {
        CommandRunner<AdminCommandJob> cr = this.getCommandRunner();
        if (StringUtils.ok((String)modelETag) && !cr.validateCommandModelETag(model, modelETag)) {
            String message = strings.getLocalString("commandmodel.etag.invalid", "Cached command model for command {0} is invalid.", new Object[]{model.getCommandName()});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).type("text/plain").entity((Object)message).build());
        }
    }

    private Response executeSseCommand(CommandName commandName, Payload.Inbound inbound, ParameterMap params, String modelETag, Cookie jSessionId) throws WebApplicationException {
        RestLogging.restLogger.log(Level.FINEST, "executeSseCommand({0})", commandName);
        CommandModel model = this.getCommandModel(commandName);
        this.checkCommandModelETag(model, modelETag);
        boolean notify = params == null ? false : params.containsKey((Object)"notify");
        boolean detach = params == null ? false : params.containsKey((Object)"detach");
        CommandInvocation invocation = this.getCommandRunner().getCommandInvocation(commandName.getScope(), commandName.getName(), (ActionReport)new PropsFileActionReporter(), this.getSubject(), notify, detach);
        if (inbound != null) {
            invocation.inbound(inbound);
        }
        invocation.outbound((Payload.Outbound)new RestPayloadImpl.Outbound(false)).parameters(params);
        Response.ResponseBuilder builder = Response.status((int)200);
        if (CommandResource.isSingleInstanceCommand(model)) {
            builder.cookie(new NewCookie[]{this.getJSessionCookie(jSessionId)});
        }
        AsyncAdminCommandInvoker invoker = detach ? new DetachedSseAdminCommandInvoker((CommandInvocation<AdminCommandJob>)invocation, builder) : new SseAdminCommandInvoker((CommandInvocation<AdminCommandJob>)invocation, builder);
        return (Response)invoker.start();
    }

    private Response executeCommand(CommandName commandName, Payload.Inbound inbound, ParameterMap params, boolean supportsMultiparResult, String xIndentHeader, String modelETag, Cookie jSessionId) throws WebApplicationException {
        RestLogging.restLogger.log(Level.FINEST, "executeCommand({0})", commandName);
        CommandModel model = this.getCommandModel(commandName);
        this.checkCommandModelETag(model, modelETag);
        boolean notify = params == null ? false : params.containsKey((Object)"notify");
        boolean detach = params == null ? false : params.containsKey((Object)"detach");
        RestPayloadImpl.Outbound outbound = new RestPayloadImpl.Outbound(false);
        PropsFileActionReporter actionReporter = new PropsFileActionReporter();
        CommandInvocation commandInvocation = this.getCommandRunner().getCommandInvocation(commandName.getScope(), commandName.getName(), (ActionReport)actionReporter, this.getSubject(), notify, detach);
        if (inbound != null) {
            commandInvocation.inbound(inbound);
        }
        commandInvocation.outbound((Payload.Outbound)outbound).parameters(params).execute();
        this.fixActionReporterSpecialCases((ActionReporter)actionReporter);
        ActionReport.ExitCode exitCode = actionReporter.getActionExitCode();
        int status = 200;
        if (exitCode == ActionReport.ExitCode.FAILURE) {
            status = 500;
        }
        Response.ResponseBuilder rb = Response.status((int)status);
        if (xIndentHeader != null) {
            rb.header("X-Indent", (Object)xIndentHeader);
        }
        if (supportsMultiparResult && outbound.size() > 0) {
            ParamsWithPayload pwp = new ParamsWithPayload(outbound, (ActionReport)actionReporter);
            rb.entity((Object)pwp);
        } else {
            rb.type(MediaType.APPLICATION_JSON_TYPE);
            rb.entity((Object)actionReporter);
        }
        if (CommandResource.isSingleInstanceCommand(model)) {
            rb.cookie(new NewCookie[]{this.getJSessionCookie(jSessionId)});
        }
        return rb.build();
    }

    private void fixActionReporterSpecialCases(ActionReporter ar) {
        if (ar == null) {
            return;
        }
        if (ar instanceof PlainTextActionReporter) {
            PlainTextActionReporter par = (PlainTextActionReporter)ar;
            StringBuilder finalOutput = new StringBuilder();
            par.getCombinedMessages((ActionReporter)par, finalOutput);
            String outs = finalOutput.toString();
            if (!StringUtils.ok((String)outs)) {
                par.getTopMessagePart().setMessage(strings.getLocalString("get.mon.no.data", "No monitoring data to report.") + "\n");
            }
        }
    }

    public NewCookie getJSessionCookie(Cookie jSessionId) {
        Object value = jSessionId != null && this.isJSessionCookieOk(jSessionId.getValue()) ? jSessionId.getValue() : uuidGenerator.generateUuid() + "." + this.getServerName();
        NewCookie result = new NewCookie(SESSION_COOKIE_NAME, (String)value, "/command", null, null, 86400, false);
        return result;
    }

    private boolean isJSessionCookieOk(String value) {
        if (!StringUtils.ok((String)value)) {
            return false;
        }
        return value.endsWith("." + this.getServerName());
    }

    private static boolean isSingleInstanceCommand(CommandModel model) {
        ExecuteOn executeOn;
        return model != null && (executeOn = model.getClusteringAttributes()) != null && executeOn.value().length == 1 && executeOn.value()[0].equals((Object)RuntimeType.SINGLE_INSTANCE);
    }

    private static String leadingSpacesToNbsp(String str) {
        if (str == null) {
            return null;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            StringBuilder sb = new StringBuilder(i * 6 + (str.length() - i));
            for (int j = 0; j < i; ++j) {
                sb.append("&nbsp;");
            }
            sb.append(str.substring(i));
            return sb.toString();
        }
        return str;
    }

    private CommandModel getCommandModel(CommandName commandName) throws WebApplicationException {
        CommandRunner<AdminCommandJob> cr = this.getCommandRunner();
        CommandModel model = cr.getModel(commandName.getScope(), commandName.getName());
        if (model == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)strings.getLocalString("adapter.command.notfound", "Command {0} not found. \nCheck the entry of command name. This command may be provided by a package that is not installed.", new Object[]{commandName.getName()})).build());
        }
        return model;
    }

    private BufferedReader getManPageReader(CommandName commandName) throws WebApplicationException {
        CommandModel model = this.getCommandModel(commandName);
        return this.getCommandRunner().getHelp(model);
    }

    private CommandRunner<AdminCommandJob> getCommandRunner() {
        if (this.commandRunner == null) {
            this.commandRunner = (CommandRunner)this.getHabitat().getService(CommandRunner.class, new Annotation[0]);
        }
        return this.commandRunner;
    }

    private ServiceLocator getHabitat() {
        return Globals.getDefaultHabitat();
    }

    private String getServerName() {
        Server server;
        if (serverName == null && (server = (Server)this.getHabitat().getService(Server.class, "default-instance-name", new Annotation[0])) != null) {
            serverName = server.getName();
        }
        return serverName;
    }

    private Subject getSubject() {
        return (Subject)this.subjectRef.get();
    }

    private static class CommandName {
        private String scope;
        private String name;

        public CommandName(String fullName) {
            if (fullName == null) {
                return;
            }
            int ind = fullName.indexOf(47);
            if (ind > 0) {
                this.scope = fullName.substring(0, ind + 1);
                this.name = fullName.substring(ind + 1);
            } else {
                this.name = fullName;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getScope() {
            return this.scope;
        }

        public String toString() {
            if (this.scope == null) {
                return "CommandName[" + this.name + "]";
            }
            return "CommandName[" + this.scope + this.name + "]";
        }
    }
}

