/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.basic.concurrent;

import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.glassfish.pfl.basic.concurrent.WeakHashMapSafeReadLock;

public abstract class WeakCache<K, V> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<K, V> map = new WeakHashMapSafeReadLock();

    protected abstract V lookup(K var1);

    public V remove(K key) {
        this.lock.writeLock().lock();
        try {
            V v = this.map.remove(key);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        this.lock.readLock().lock();
        boolean readLocked = true;
        try {
            V value = this.map.get(key);
            if (value == null) {
                readLocked = false;
                this.lock.readLock().unlock();
                value = this.lookup(key);
                this.lock.writeLock().lock();
                try {
                    V current = this.map.get(key);
                    if (current == null) {
                        this.map.put(key, value);
                    } else {
                        value = current;
                    }
                }
                finally {
                    this.lock.writeLock().unlock();
                }
            }
            V v = value;
            return v;
        }
        finally {
            if (readLocked) {
                this.lock.readLock().unlock();
            }
        }
    }

    public void clear() {
        this.map.clear();
    }
}

