/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin.progress;

import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public class ProgressStatusEventCreateChild
extends ProgressStatusEvent {
    private String childId;
    private String name;
    private int allocatedSteps;
    private int totalSteps;

    public ProgressStatusEventCreateChild(String progressStatusId, String name, String childId, int allocatedSteps, int totalSteps) {
        super(progressStatusId);
        this.name = name;
        this.childId = childId;
        this.allocatedSteps = allocatedSteps;
        this.totalSteps = totalSteps;
    }

    public ProgressStatusEventCreateChild(String progressStatusId) {
        super(progressStatusId);
    }

    public String getChildId() {
        return this.childId;
    }

    public void setChildId(String childId) {
        this.childId = childId;
    }

    public int getAllocatedSteps() {
        return this.allocatedSteps;
    }

    public void setAllocatedSteps(int allocatedSteps) {
        this.allocatedSteps = allocatedSteps;
    }

    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ProgressStatus apply(ProgressStatus ps) {
        ProgressStatus chld;
        if (ps instanceof ProgressStatusBase) {
            ProgressStatusBase psb = (ProgressStatusBase)ps;
            chld = psb.createChild(this.name, this.allocatedSteps, this.totalSteps);
        } else {
            chld = ps.createChild(this.name, this.allocatedSteps);
            if (this.totalSteps >= 0) {
                chld.setTotalStepCount(this.totalSteps);
            }
        }
        return chld;
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.childId != null ? this.childId.hashCode() : 0);
        hash = 19 * hash + (this.name != null ? this.name.hashCode() : 0);
        hash = 19 * hash + this.allocatedSteps;
        hash = 19 * hash + this.totalSteps;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgressStatusEventCreateChild other = (ProgressStatusEventCreateChild)obj;
        if (this.childId == null ? other.childId != null : !this.childId.equals(other.childId)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.allocatedSteps != other.allocatedSteps) {
            return false;
        }
        return this.totalSteps == other.totalSteps;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getSourceId() + ", progress=" + this.getAllocatedSteps() + "/" + this.getTotalSteps() + "]";
    }
}

