/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.auth.realm;

import com.sun.enterprise.util.Utility;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class GroupMapper {
    private Map<String, List<String>> groupMappingTable = new HashMap<String, List<String>>();

    public void parse(String mappingStr) {
        StringTokenizer tokenizer = new StringTokenizer(mappingStr, ";");
        while (tokenizer.hasMoreElements()) {
            String mapping = tokenizer.nextToken();
            String[] mappingGroups = mapping.split(",");
            String mappedGroup = null;
            int indexOfArrow = mapping.indexOf("->");
            if (indexOfArrow > 0 && mappingGroups != null && mappingGroups.length > 0) {
                String tmpGroup = mapping.substring(indexOfArrow + 2);
                mappedGroup = tmpGroup.trim();
            }
            this.validate(mappedGroup, mappingGroups);
            for (String grp : mappingGroups) {
                int aIndex = grp.indexOf("->");
                String theGroup = null;
                if (aIndex > 0) {
                    String tGrp = grp.substring(0, aIndex);
                    theGroup = tGrp.trim();
                } else {
                    theGroup = grp.trim();
                }
                List<String> mappedGroupList = this.groupMappingTable.get(theGroup);
                if (mappedGroupList == null) {
                    mappedGroupList = new ArrayList<String>();
                }
                mappedGroupList.add(mappedGroup);
                this.groupMappingTable.put(theGroup, mappedGroupList);
            }
        }
    }

    public void getMappedGroups(String group, List<String> targetMappedGroups) {
        if (targetMappedGroups == null) {
            throw new RuntimeException("result argument cannot be NULL");
        }
        List<String> sourceMappedGroups = this.groupMappingTable.get(group);
        if (Utility.isEmpty(sourceMappedGroups)) {
            return;
        }
        this.addUnique(targetMappedGroups, sourceMappedGroups);
        ArrayList<String> result1 = new ArrayList<String>();
        for (String mappedGroup : sourceMappedGroups) {
            this.getMappedGroups(group, mappedGroup, result1);
        }
        this.addUnique(targetMappedGroups, result1);
    }

    private void addUnique(List<String> dest, List<String> src) {
        for (String str : src) {
            if (dest.contains(str)) continue;
            dest.add(str);
        }
    }

    private void getMappedGroups(String group, String str, List<String> result) {
        List<String> mappedGroups = this.groupMappingTable.get(str);
        if (Utility.isEmpty(mappedGroups)) {
            return;
        }
        if (mappedGroups.contains(group)) {
            throw new RuntimeException("Illegal Mapping: cycle detected with group'" + group);
        }
        this.addUnique(result, mappedGroups);
        for (String mappedGroup : mappedGroups) {
            this.getMappedGroups(group, mappedGroup, result);
        }
    }

    private void validate(String mappedGroup, String[] mappingGroups) {
        for (String mappingGroup : mappingGroups) {
            int aIndex = mappingGroup.indexOf("->");
            String theGroup = null;
            theGroup = aIndex > 0 ? mappingGroup.substring(0, aIndex) : mappingGroup;
            if (!theGroup.equals(mappedGroup)) continue;
            throw new RuntimeException("Illegal Mapping: Identity Mapping of group '" + theGroup + "' to '" + theGroup + "'");
        }
    }
}

