/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.cm.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.felix.cm.PersistenceManager;
import org.apache.felix.cm.impl.CaseInsensitiveDictionary;
import org.apache.felix.cm.impl.ConfigurationManager;
import org.apache.felix.cm.impl.Log;
import org.apache.felix.cm.impl.helper.TargetedPID;
import org.osgi.service.cm.Configuration;

public class ConfigurationImpl {
    private static final String CONFIGURATION_NEW = "_felix_.cm.newConfiguration";
    private static final String PROPERTY_LOCKED = ":org.apache.felix.configadmin.locked:";
    private static final String PROPERTY_REVISION = ":org.apache.felix.configadmin.revision:";
    private final TargetedPID factoryPID;
    private volatile String staticBundleLocation;
    private volatile String dynamicBundleLocation;
    private volatile CaseInsensitiveDictionary properties;
    private volatile boolean isDeleted;
    private volatile long revision;
    private volatile boolean locked;
    private final ConfigurationManager configurationManager;
    private final PersistenceManager persistenceManager;
    private final TargetedPID baseId;
    private static final String[] AUTO_PROPS = new String[]{"service.pid", "service.factoryPid", "service.bundleLocation", ":org.apache.felix.configadmin.locked:", ":org.apache.felix.configadmin.revision:"};

    public ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, Dictionary<String, Object> properties) {
        if (configurationManager == null) {
            throw new IllegalArgumentException("ConfigurationManager must not be null");
        }
        if (persistenceManager == null) {
            throw new IllegalArgumentException("PersistenceManager must not be null");
        }
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.baseId = new TargetedPID((String)properties.remove("service.pid"));
        String factoryPid = (String)properties.remove("service.factoryPid");
        this.factoryPID = factoryPid == null ? null : new TargetedPID(factoryPid);
        this.isDeleted = false;
        this.staticBundleLocation = (String)properties.remove("service.bundleLocation");
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.baseId.toString());
        this.configureFromPersistence(properties);
    }

    ConfigurationImpl(ConfigurationManager configurationManager, PersistenceManager persistenceManager, String pid, String factoryPid, String bundleLocation) throws IOException {
        if (configurationManager == null) {
            throw new IllegalArgumentException("ConfigurationManager must not be null");
        }
        if (persistenceManager == null) {
            throw new IllegalArgumentException("PersistenceManager must not be null");
        }
        this.configurationManager = configurationManager;
        this.persistenceManager = persistenceManager;
        this.baseId = new TargetedPID(pid);
        this.factoryPID = factoryPid == null ? null : new TargetedPID(factoryPid);
        this.isDeleted = false;
        this.staticBundleLocation = bundleLocation;
        this.dynamicBundleLocation = configurationManager.getDynamicBundleLocation(this.baseId.toString());
        this.properties = null;
        this.revision = 1L;
        if (factoryPid == null) {
            this.storeNewConfiguration();
        }
    }

    boolean isActive() {
        return this.configurationManager.isActive();
    }

    void storeSilently() {
        try {
            this.store();
        }
        catch (IOException ioe) {
            Log.logger.log(1, "Persisting ID {0} failed", new Object[]{this.baseId, ioe});
        }
    }

    protected static void replaceProperty(Dictionary<String, Object> properties, String key, String value) {
        if (value == null) {
            properties.remove(key);
        } else {
            properties.put(key, value);
        }
    }

    public void delete() throws IOException {
        this.isDeleted = true;
        this.persistenceManager.delete(this.getPidString());
        this.configurationManager.setDynamicBundleLocation(this.getPidString(), null);
        this.configurationManager.deleted(this);
    }

    public String getPidString() {
        return this.baseId.toString();
    }

    public TargetedPID getPid() {
        return this.baseId;
    }

    public String getFactoryPidString() {
        return this.factoryPID == null ? null : this.factoryPID.toString();
    }

    public TargetedPID getFactoryPid() {
        return this.factoryPID;
    }

    String getBundleLocation() {
        if (this.staticBundleLocation != null) {
            return this.staticBundleLocation;
        }
        return this.dynamicBundleLocation;
    }

    String getDynamicBundleLocation() {
        return this.dynamicBundleLocation;
    }

    String getStaticBundleLocation() {
        return this.staticBundleLocation;
    }

    void setStaticBundleLocation(String bundleLocation) {
        String oldBundleLocation = this.getBundleLocation();
        this.staticBundleLocation = bundleLocation;
        this.storeSilently();
        this.setDynamicBundleLocation(null, false);
        this.configurationManager.locationChanged(this, oldBundleLocation);
    }

    void setDynamicBundleLocation(String bundleLocation, boolean dispatchConfiguration) {
        String oldBundleLocation = this.getBundleLocation();
        this.dynamicBundleLocation = bundleLocation;
        this.configurationManager.setDynamicBundleLocation(this.getPidString(), bundleLocation);
        if (dispatchConfiguration) {
            this.configurationManager.locationChanged(this, oldBundleLocation);
        }
    }

    void tryBindLocation(String bundleLocation) {
        if (this.getBundleLocation() == null) {
            Log.logger.log(4, "Dynamically binding config {0} to {1}", new Object[]{this.getPidString(), bundleLocation});
            this.setDynamicBundleLocation(bundleLocation, true);
        }
    }

    public Dictionary<String, Object> getProperties(boolean deepCopy) {
        if (this.properties == null) {
            return null;
        }
        CaseInsensitiveDictionary props = new CaseInsensitiveDictionary(this.properties, deepCopy);
        this.setAutoProperties(props, false);
        return props;
    }

    public void update() throws IOException {
        if (this.persistenceManager.exists(this.getPidString())) {
            Dictionary properties = this.persistenceManager.load(this.getPidString());
            String servicePid = (String)properties.get("service.pid");
            if (servicePid != null && !this.getPidString().equals(servicePid)) {
                throw new IOException("PID of configuration file does match requested PID; expected " + this.getPidString() + ", got " + servicePid);
            }
            properties.put(PROPERTY_REVISION, this.getRevision());
            this.configureFromPersistence(properties);
        }
        this.configurationManager.updated(this, false);
    }

    public void update(Dictionary<String, ?> properties) throws IOException {
        CaseInsensitiveDictionary newProperties = new CaseInsensitiveDictionary(properties);
        Log.logger.log(4, "Updating config {0} with {1}", new Object[]{this.getPidString(), newProperties});
        this.setAutoProperties(newProperties, true);
        newProperties.put(PROPERTY_REVISION, (Object)this.getRevision());
        this.persistenceManager.store(this.getPidString(), newProperties);
        this.configure(newProperties);
        this.configurationManager.updated(this, true);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Configuration) {
            return this.getPidString().equals(((Configuration)obj).getPid());
        }
        return false;
    }

    public int hashCode() {
        return this.getPidString().hashCode();
    }

    public String toString() {
        return "Configuration PID=" + this.getPidString() + ", factoryPID=" + this.factoryPID + ", bundleLocation=" + this.getBundleLocation();
    }

    void ensureFactoryConfigPersisted() throws IOException {
        if (this.factoryPID != null && this.isNew() && !this.persistenceManager.exists(this.getPidString())) {
            this.storeNewConfiguration();
        }
    }

    private void storeNewConfiguration() throws IOException {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        this.setAutoProperties(props, true);
        ((Dictionary)props).put(CONFIGURATION_NEW, Boolean.TRUE);
        ((Dictionary)props).put(PROPERTY_REVISION, this.getRevision());
        this.persistenceManager.store(this.getPidString(), props);
    }

    void store() throws IOException {
        Dictionary<String, Object> props = this.getProperties(false);
        if (props == null) {
            props = new Hashtable<String, Object>();
            this.setAutoProperties(props, true);
        } else {
            ConfigurationImpl.replaceProperty(props, "service.bundleLocation", this.getStaticBundleLocation());
        }
        if (this.locked) {
            props.put(PROPERTY_LOCKED, this.locked);
        } else {
            props.remove(PROPERTY_LOCKED);
        }
        props.put(PROPERTY_REVISION, this.getRevision());
        this.persistenceManager.store(this.getPidString(), props);
    }

    public long getRevision() {
        return this.revision;
    }

    boolean isNew() {
        return this.properties == null;
    }

    boolean isDeleted() {
        return this.isDeleted;
    }

    private void configureFromPersistence(Dictionary<String, Object> properties) {
        if (properties.get(CONFIGURATION_NEW) == null) {
            this.configure(properties);
        } else {
            this.configure(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure(Dictionary<String, Object> properties) {
        CaseInsensitiveDictionary newProperties;
        Object lockedValue;
        Object revisionValue = properties == null ? null : properties.get(PROPERTY_REVISION);
        Object object = lockedValue = properties == null ? null : properties.get(PROPERTY_LOCKED);
        if (lockedValue != null) {
            this.locked = true;
        }
        if (properties == null) {
            newProperties = null;
        } else {
            ConfigurationImpl.clearAutoProperties(properties);
            newProperties = properties instanceof CaseInsensitiveDictionary ? (CaseInsensitiveDictionary)properties : new CaseInsensitiveDictionary(properties);
        }
        ConfigurationImpl configurationImpl = this;
        synchronized (configurationImpl) {
            this.properties = newProperties;
            this.revision = revisionValue != null ? 1L + (Long)revisionValue : (this.revision = this.revision + 1L);
        }
    }

    void setAutoProperties(Dictionary<String, Object> properties, boolean withBundleLocation) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", this.getPidString());
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", this.getFactoryPidString());
        if (withBundleLocation) {
            ConfigurationImpl.replaceProperty(properties, "service.bundleLocation", this.getStaticBundleLocation());
        } else {
            properties.remove("service.bundleLocation");
        }
        properties.remove(PROPERTY_LOCKED);
        properties.remove(PROPERTY_REVISION);
    }

    static void setAutoProperties(Dictionary<String, Object> properties, String pid, String factoryPid) {
        ConfigurationImpl.replaceProperty(properties, "service.pid", pid);
        ConfigurationImpl.replaceProperty(properties, "service.factoryPid", factoryPid);
        properties.remove("service.bundleLocation");
        properties.remove(PROPERTY_LOCKED);
        properties.remove(PROPERTY_REVISION);
    }

    static void clearAutoProperties(Dictionary<String, Object> properties) {
        for (String p : AUTO_PROPS) {
            properties.remove(p);
        }
    }

    public void setLocked(boolean flag) throws IOException {
        this.locked = flag;
        this.store();
    }

    static boolean equals(Dictionary<String, Object> props1, Dictionary<String, Object> props2) {
        int count2;
        if (props1 == null) {
            return props2 == null;
        }
        if (props2 == null) {
            return false;
        }
        int count1 = ConfigurationImpl.getCount(props1);
        if (count1 != (count2 = ConfigurationImpl.getCount(props2))) {
            return false;
        }
        Enumeration<String> keys = props1.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (ConfigurationImpl.isAutoProp(key)) continue;
            Object val1 = props1.get(key);
            Object val2 = props2.get(key);
            if (val1 == null) {
                if (val2 == null) continue;
                return false;
            }
            if (val2 == null) {
                return false;
            }
            if (val1.getClass().isArray()) {
                Object[] a2;
                if (!val2.getClass().isArray()) {
                    return false;
                }
                Object[] a1 = ConfigurationImpl.convertToObjectArray(val1);
                if (Arrays.equals(a1, a2 = ConfigurationImpl.convertToObjectArray(val2))) continue;
                return false;
            }
            if (val1.equals(val2)) continue;
            return false;
        }
        return true;
    }

    private static Object[] convertToObjectArray(Object value) {
        Object[] values;
        if (value instanceof long[]) {
            long[] a = (long[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof int[]) {
            int[] a = (int[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof double[]) {
            double[] a = (double[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof byte[]) {
            byte[] a = (byte[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof float[]) {
            float[] a = (float[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = Float.valueOf(a[i]);
            }
        } else if (value instanceof short[]) {
            short[] a = (short[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof boolean[]) {
            boolean[] a = (boolean[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = a[i];
            }
        } else if (value instanceof char[]) {
            char[] a = (char[])value;
            values = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                values[i] = Character.valueOf(a[i]);
            }
        } else {
            values = (Object[])value;
        }
        return values;
    }

    static boolean isAutoProp(String name) {
        for (String p : AUTO_PROPS) {
            if (!p.equals(name)) continue;
            return true;
        }
        return false;
    }

    static int getCount(Dictionary<String, Object> props) {
        int count;
        int n = count = props == null ? 0 : props.size();
        if (props != null) {
            for (String p : AUTO_PROPS) {
                if (props.get(p) == null) continue;
                --count;
            }
        }
        return count;
    }

    public boolean isLocked() {
        return this.locked;
    }

    final ConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }
}

