/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.lite.extension.translator;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.lang.model.types.PrimitiveType;
import java.lang.reflect.AnnotatedType;
import org.jboss.weld.lite.extension.translator.TypeImpl;
import org.jboss.weld.lite.extension.translator.logging.LiteExtensionTranslatorLogger;
import org.jboss.weld.lite.extension.translator.util.AnnotationOverrides;
import org.jboss.weld.lite.extension.translator.util.reflection.AnnotatedTypes;

class PrimitiveTypeImpl
extends TypeImpl<AnnotatedType>
implements PrimitiveType {
    final Class<?> clazz;

    PrimitiveTypeImpl(AnnotatedType primitiveType, BeanManager bm) {
        this(primitiveType, (AnnotationOverrides)null, bm);
    }

    PrimitiveTypeImpl(AnnotatedType primitiveType, AnnotationOverrides overrides, BeanManager bm) {
        super(primitiveType, overrides, bm);
        this.clazz = (Class)primitiveType.getType();
    }

    PrimitiveTypeImpl(Class<?> primitiveType, BeanManager bm) {
        this(primitiveType, (AnnotationOverrides)null, bm);
    }

    PrimitiveTypeImpl(Class<?> primitiveType, AnnotationOverrides overrides, BeanManager bm) {
        super(AnnotatedTypes.from(primitiveType), overrides, bm);
        this.clazz = primitiveType;
    }

    @Override
    public String name() {
        return ((AnnotatedType)this.reflection).getType().getTypeName();
    }

    @Override
    public PrimitiveType.PrimitiveKind primitiveKind() {
        if (this.clazz == Boolean.TYPE) {
            return PrimitiveType.PrimitiveKind.BOOLEAN;
        }
        if (this.clazz == Byte.TYPE) {
            return PrimitiveType.PrimitiveKind.BYTE;
        }
        if (this.clazz == Short.TYPE) {
            return PrimitiveType.PrimitiveKind.SHORT;
        }
        if (this.clazz == Integer.TYPE) {
            return PrimitiveType.PrimitiveKind.INT;
        }
        if (this.clazz == Long.TYPE) {
            return PrimitiveType.PrimitiveKind.LONG;
        }
        if (this.clazz == Float.TYPE) {
            return PrimitiveType.PrimitiveKind.FLOAT;
        }
        if (this.clazz == Double.TYPE) {
            return PrimitiveType.PrimitiveKind.DOUBLE;
        }
        if (this.clazz == Character.TYPE) {
            return PrimitiveType.PrimitiveKind.CHAR;
        }
        throw LiteExtensionTranslatorLogger.LOG.unknownPrimitiveType(this.clazz);
    }
}

