/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.admin.cli.CLIContainer;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.LineTokenReplacer;
import com.sun.enterprise.admin.util.TokenValue;
import com.sun.enterprise.admin.util.TokenValueSet;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import jakarta.inject.Inject;
import jakarta.inject.Scope;
import jakarta.inject.Singleton;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.glassfish.api.Param;
import org.glassfish.api.ParamDefaultCalculator;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.CommandModelImpl;
import org.glassfish.common.util.admin.ManPageFinder;
import org.glassfish.common.util.admin.MapInjectionResolver;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.InjectionManager;
import org.jvnet.hk2.config.InjectionResolver;
import org.jvnet.hk2.config.UnsatisfiedDependencyException;

@Contract
@PerLookup
public abstract class CLICommand
implements PostConstruct {
    public static final int ERROR = 1;
    public static final int CONNECTION_ERROR = 2;
    public static final int INVALID_COMMAND_ERROR = 3;
    public static final int SUCCESS = 0;
    public static final int WARNING = 4;
    private static final Set<String> unsupported;
    private static final String UNSUPPORTED_CMD_FILE_NAME = "unsupported-legacy-command-names";
    private static final LocalStringsImpl strings;
    private static final Map<String, String> systemProps;
    protected static final Logger logger;
    private static final InjectionManager injectionMgr;
    private static String commandScope;
    private static String[] manpageTokens;
    private final String[] manpageTokenValues = new String[manpageTokens.length];
    protected String name;
    @Inject
    protected ProgramOptions programOpts;
    @Inject
    protected Environment env;
    protected String[] argv;
    protected CommandModel commandModel;
    protected ParameterMap options;
    protected List<String> operands;
    protected Map<String, String> passwords;

    private static boolean useRest() {
        return true;
    }

    public static CLICommand getCommand(ServiceLocator serviceLocator, String name) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        ProgramOptions po = (ProgramOptions)serviceLocator.getService(ProgramOptions.class, new Annotation[0]);
        CLICommand cmd = (CLICommand)serviceLocator.getService(CLICommand.class, name, new Annotation[0]);
        if (cmd != null) {
            po.removeDetach();
            return cmd;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Assuming it's a remote command: " + name);
        }
        return CLICommand.getRemoteCommand(name, po, (Environment)serviceLocator.getService(Environment.class, new Annotation[0]));
    }

    public static CLICommand getCommand(CLIContainer cLIContainer, String name) throws CommandException {
        CLICommand.checkUnsupportedLegacyCommand(name);
        ProgramOptions po = cLIContainer.getProgramOptions();
        CLICommand cmd = cLIContainer.getLocalCommand(name);
        if (cmd != null) {
            po.removeDetach();
            return cmd;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Assuming it's a remote command: " + name);
        }
        return CLICommand.getRemoteCommand(name, po, cLIContainer.getEnvironment());
    }

    private static CLICommand getRemoteCommand(String name, ProgramOptions po, Environment env) throws CommandException {
        if (CLICommand.useRest()) {
            return new RemoteCLICommand(name, po, env);
        }
        return new RemoteCommand(name, po, env);
    }

    protected CLICommand() {
        Service service = this.getClass().getAnnotation(Service.class);
        this.name = service == null ? "unknown-command" : service.name();
    }

    public void postConstruct() {
        this.initializeLogger();
    }

    protected CLICommand(String name, ProgramOptions programOpts, Environment env) {
        this.name = name;
        this.programOpts = programOpts;
        this.env = env;
        this.initializeLogger();
    }

    public int execute(String ... argv) throws CommandException {
        this.argv = argv;
        this.checkSanity();
        this.initializePasswords();
        logger.finer("Prepare");
        this.prepare();
        logger.finer("Process program options");
        this.processProgramOptions();
        logger.finer("Parse command options");
        this.parse();
        if (this.checkHelp()) {
            return 0;
        }
        logger.finer("Prevalidate command options");
        this.prevalidate();
        logger.finer("Inject command options");
        this.inject();
        logger.finer("Validate command options");
        this.validate();
        if (this.programOpts.isEcho()) {
            logger.info(this.echoCommand());
            this.programOpts.setEcho(false);
        } else if (logger.isLoggable(Level.FINER)) {
            logger.finer(this.echoCommand());
        }
        logger.finer("Execute command");
        return this.executeCommand();
    }

    public String getName() {
        return this.name;
    }

    public static String getCommandScope() {
        return commandScope;
    }

    public static void setCommandScope(String ctx) {
        commandScope = ctx;
    }

    public ProgramOptions getProgramOptions() {
        return this.programOpts;
    }

    public BufferedReader getManPage() {
        String commandName = this.getName();
        if (commandName.isEmpty()) {
            throw new IllegalArgumentException("Command name cannot be empty");
        }
        if (commandName.equals("help")) {
            commandName = this.programOpts.getCommandName();
        }
        return ManPageFinder.getCommandManPage((String)commandName, (String)this.getClass().getName(), (Locale)Locale.getDefault(), (ClassLoader)this.getClass().getClassLoader(), (Logger)logger);
    }

    public BufferedReader expandManPage(Reader r) {
        this.manpageTokenValues[0] = this.programOpts.getCommandName();
        this.manpageTokenValues[1] = Environment.getPrefix();
        this.manpageTokenValues[2] = Version.getProductNameAbbreviation();
        TokenValueSet tvs = new TokenValueSet();
        for (int i = 0; i < manpageTokens.length; ++i) {
            tvs.add(new TokenValue(manpageTokens[i], this.manpageTokenValues[i], "{", "}"));
        }
        return new BufferedReader(new LineTokenReplacer(tvs).getReader(r));
    }

    public String getUsage() {
        String usage;
        if (this.commandModel != null && CLICommand.ok(usage = this.commandModel.getUsageText())) {
            StringBuilder usageText = new StringBuilder();
            usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.brief", new Object[]{this.programOpts.getCommandName()})}));
            usageText.append(" ");
            usageText.append(usage);
            return usageText.toString();
        }
        return this.generateUsageText();
    }

    private String generateUsageText() {
        String opname;
        StringBuilder usageText = new StringBuilder();
        usageText.append(strings.get("Usage", new Object[]{strings.get("Usage.brief", new Object[]{this.programOpts.getCommandName()})}));
        usageText.append(" ");
        usageText.append(this.getName());
        String lsep = System.lineSeparator();
        ArrayList<CommandModel.ParamModel> usageOptions = new ArrayList<CommandModel.ParamModel>(this.usageOptions());
        usageOptions.add(new NoValueModel("help", "?", true));
        List sorted = usageOptions.stream().sorted(new OptionComparator()).collect(Collectors.toList());
        for (CommandModel.ParamModel opt : sorted) {
            String optText = this.toLine(opt);
            if (optText == null) continue;
            usageText.append(lsep).append('\t');
            usageText.append(optText);
        }
        StringBuilder optText = new StringBuilder();
        CommandModel.ParamModel operandParam = this.getOperandModel();
        String string = opname = operandParam != null ? CLICommand.lc(operandParam.getName()) : null;
        if (!CLICommand.ok(opname)) {
            opname = "operand";
        }
        boolean operandMin = false;
        int operandMax = 0;
        if (operandParam != null) {
            operandMin = !operandParam.getParam().optional();
            int n = operandMax = operandParam.getParam().multiple() ? Integer.MAX_VALUE : 1;
        }
        if (operandMax > 0) {
            if (!operandMin) {
                optText.append("[").append(opname);
                if (operandMax > 1) {
                    optText.append(" ...");
                }
                optText.append("]");
            } else {
                optText.append(opname);
                if (operandMax > 1) {
                    optText.append(" ...");
                }
            }
        }
        usageText.append(lsep).append('\t');
        usageText.append((CharSequence)optText);
        return usageText.toString();
    }

    private String toLine(CommandModel.ParamModel opt) {
        String optName = CLICommand.lc(opt.getName());
        if (optName.equals("terse")) {
            return null;
        }
        if (optName.startsWith("_")) {
            return null;
        }
        if (opt.getParam().password()) {
            return null;
        }
        if (opt.getParam().obsolete()) {
            return null;
        }
        if (opt.getParam().primary()) {
            return null;
        }
        StringBuilder optText = new StringBuilder();
        boolean optional = opt.getParam().optional();
        String defValue = opt.getParam().defaultValue();
        if (optional) {
            optText.append("[");
        }
        optText.append("--").append(optName);
        String sn = opt.getParam().shortName();
        if (CLICommand.ok(sn)) {
            optText.append('|').append('-').append(sn);
        }
        if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
            defValue = CLICommand.ok(defValue) && Boolean.parseBoolean(defValue) ? "true" : "false";
            optText.append("[=<").append(optName);
            optText.append(strings.get("Usage.default", new Object[]{defValue}));
            optText.append(">]");
        } else if (opt.getType() != Void.class) {
            if (CLICommand.ok(defValue)) {
                optText.append(" <").append(optName);
                optText.append(strings.get("Usage.default", new Object[]{defValue}));
                optText.append('>');
            } else {
                optText.append(" <").append(optName).append('>');
            }
        }
        if (optional) {
            optText.append("]");
        }
        return optText.toString();
    }

    protected Collection<CommandModel.ParamModel> usageOptions() {
        return this.commandModel.getParameters();
    }

    public String getCommandUsage() {
        return strings.get("Usage.full", new Object[]{this.programOpts.getCommandName()});
    }

    public String getBriefCommandUsage() {
        return strings.get("Usage.brief", new Object[]{this.programOpts.getCommandName()});
    }

    public String toString() {
        return this.echoCommand();
    }

    private String echoCommand() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.programOpts.getCommandName());
        sb.append(' ');
        sb.append(this.programOpts.toString()).append(' ');
        sb.append(this.name).append(' ');
        if (this.options != null && this.operands != null) {
            for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                if (opt.getParam().password() || opt.getParam().primary()) continue;
                if (opt.getParam().multiple()) {
                    List<String> paramValues = this.getOptions(opt.getName());
                    for (String v : paramValues) {
                        this.appendEchoOption(sb, opt, v);
                    }
                    continue;
                }
                String value = this.getOption(opt.getName());
                if (value == null) continue;
                this.appendEchoOption(sb, opt, value);
            }
            for (String o : this.operands) {
                sb.append(CLICommand.quote(o)).append(' ');
            }
        } else if (this.argv != null) {
            for (String arg : this.argv) {
                sb.append(CLICommand.quote(arg)).append(' ');
            }
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    private void appendEchoOption(StringBuilder sb, CommandModel.ParamModel opt, String value) {
        sb.append("--").append(CLICommand.lc(opt.getName()));
        if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
            sb.append("=").append(Boolean.toString(Boolean.parseBoolean(value)));
        } else {
            sb.append(" ").append(CLICommand.quote(value));
        }
        sb.append(' ');
    }

    public static String quote(String value) {
        int len = value.length();
        if (len == 0) {
            return "\"\"";
        }
        boolean needQuoting = false;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '\"' || c == '\\' || c == '\r' || c == '\n') {
                StringBuilder sb = new StringBuilder(len + 3);
                sb.append('\"');
                sb.append(value.substring(0, i));
                int lastc = 0;
                for (int j = i; j < len; ++j) {
                    char cc = value.charAt(j);
                    if (!(cc != '\"' && cc != '\\' && cc != '\r' && cc != '\n' || cc == '\n' && lastc == 13)) {
                        sb.append('\\');
                    }
                    sb.append(cc);
                    lastc = cc;
                }
                sb.append('\"');
                return sb.toString();
            }
            if (c > ' ' && c < '\u007f') continue;
            needQuoting = true;
        }
        if (needQuoting) {
            StringBuilder sb = new StringBuilder(len + 2);
            sb.append('\"').append(value).append('\"');
            return sb.toString();
        }
        return value;
    }

    protected void processProgramOptions() throws CommandException {
        Collection<CommandModel.ParamModel> model = ProgramOptions.getValidOptions();
        if (this.programOpts.isOptionsSet()) {
            model = ProgramOptions.getHelpOption();
        }
        Parser rcp = new Parser(this.argv, 0, model, true);
        ParameterMap params = rcp.getOptions();
        List<String> oprds = rcp.getOperands();
        this.argv = oprds.toArray(new String[oprds.size()]);
        if (params.size() > 0) {
            logger.finer("Update program options");
            this.programOpts.updateOptions(params);
            this.initializeLogger();
            this.initializePasswords();
            if (!(this.programOpts.isTerse() || params.size() == 1 && params.get((Object)"help") != null)) {
                Collection<CommandModel.ParamModel> programOptions = ProgramOptions.getValidOptions();
                StringBuilder sb = new StringBuilder();
                sb.append(this.programOpts.getCommandName());
                for (Map.Entry p : params.entrySet()) {
                    CommandModel.ParamModel opt = null;
                    for (CommandModel.ParamModel vo : programOptions) {
                        if (!vo.getName().equalsIgnoreCase((String)p.getKey())) continue;
                        opt = vo;
                        break;
                    }
                    if (opt == null) continue;
                    sb.append(" --").append((String)p.getKey());
                    List pl = (List)p.getValue();
                    if (opt.getType() == Boolean.class || opt.getType() == Boolean.TYPE) {
                        if (((String)pl.get(0)).equalsIgnoreCase("true")) continue;
                        sb.append("=false");
                        continue;
                    }
                    if (pl == null || pl.size() <= 0) continue;
                    sb.append(" ").append((String)pl.get(0));
                }
                sb.append(" ").append(this.name).append(" [options] ...");
                logger.info(strings.get("DeprecatedSyntax"));
                logger.info(sb.toString());
            }
        }
    }

    protected void initializeLogger() {
        if (!logger.isLoggable(Level.FINER)) {
            if (this.programOpts.isTerse()) {
                logger.setLevel(Level.INFO);
            } else {
                logger.setLevel(Level.FINE);
            }
        }
    }

    protected void initializePasswords() throws CommandException {
        this.passwords = new HashMap<String, String>();
        String pwfile = this.programOpts.getPasswordFile();
        if (CLICommand.ok(pwfile)) {
            char[] password;
            this.passwords = CLIUtil.readPasswordFileOptions(pwfile, true);
            logger.finer("Passwords were read from password file: " + pwfile);
            char[] cArray = password = this.passwords.get(Environment.getPrefix() + "PASSWORD") != null ? this.passwords.get(Environment.getPrefix() + "PASSWORD").toCharArray() : null;
            if (password != null && this.programOpts.getPassword() == null) {
                this.programOpts.setPassword(password, ProgramOptions.PasswordLocation.PASSWORD_FILE);
            }
        }
    }

    protected void prepare() throws CommandException {
        this.commandModel = new CommandModelImpl(this.getClass());
    }

    protected void parse() throws CommandException {
        if (this.programOpts.isHelp()) {
            this.options = new ParameterMap();
            this.options.set((Object)"help", (Object)"true");
            this.operands = Collections.emptyList();
        } else {
            Parser rcp = new Parser(this.argv, 1, this.commandModel.getParameters(), this.commandModel.unknownOptionsAreOperands());
            this.options = rcp.getOptions();
            this.operands = rcp.getOperands();
            if (this.commandModel.unknownOptionsAreOperands() && this.operands.size() > 0 && this.operands.get(0).equals("--")) {
                this.operands.remove(0);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("params: " + String.valueOf(this.options));
            logger.finer("operands: " + String.valueOf(this.operands));
        }
    }

    protected void checkSanity() {
        try {
            InetAddress.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            logger.log(Level.WARNING, "Bad OS network configuration. DNS can not resolve the hostname: \n{0}", uhe.toString());
        }
    }

    protected boolean checkHelp() throws CommandException {
        if (this.programOpts.isHelp()) {
            BufferedReader br = this.getManPage();
            if (br == null) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}));
            }
            br = this.expandManPage(br);
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
            }
            catch (IOException ioex) {
                throw new CommandException(strings.get("ManpageMissing", new Object[]{this.name}), (Throwable)ioex);
            }
            finally {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return false;
    }

    private Class<? extends Annotation> getScope(Class<?> onMe) {
        if (onMe == null) {
            return null;
        }
        for (Annotation anno : onMe.getAnnotations()) {
            if (!anno.annotationType().isAnnotationPresent(Scope.class)) continue;
            return anno.annotationType();
        }
        return null;
    }

    protected void prevalidate() throws CommandException {
        if (!(this instanceof RemoteCommand) && !(this instanceof RemoteCLICommand)) {
            Class<? extends Annotation> myScope = this.getScope(this.getClass());
            if (myScope == null) {
                throw new CommandException(strings.get("NoScope", new Object[]{this.name}));
            }
            if (Singleton.class.equals(myScope) && this.commandModel.getParameters().size() > 0) {
                throw new CommandException(strings.get("HasParams", new Object[]{this.name}));
            }
        }
        Console cons = this.programOpts.isInteractive() ? System.console() : null;
        boolean missingOption = false;
        for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
            if (opt.getParam().password()) continue;
            if (opt.getParam().obsolete() && this.getOption(opt.getName()) != null) {
                logger.log(Level.WARNING, "Warning: Option --{0} is obsolete and will be ignored.", opt.getName());
            }
            if (opt.getParam().optional() || opt.getParam().primary()) continue;
            if (this.getOption(opt.getName()) == null && cons != null && !missingOption) {
                cons.printf("%s", strings.get("optionPrompt", new Object[]{CLICommand.lc(opt.getName())}));
                String val = cons.readLine();
                if (CLICommand.ok(val)) {
                    this.options.set((Object)opt.getName(), (Object)val);
                }
            }
            if (this.getOption(opt.getName()) == null) {
                missingOption = true;
                logger.log(Level.INFO, "Option --{0} is required but was not specified", opt.getName());
            }
            if (!opt.getParam().obsolete()) continue;
            logger.log(Level.WARNING, "Warning: Option --{0} is obsolete and will be ignored.", opt.getName());
        }
        if (missingOption) {
            throw new CommandValidationException("Command " + this.name + " is missing required options");
        }
        int operandMin = 0;
        int operandMax = 0;
        CommandModel.ParamModel operandParam = this.getOperandModel();
        if (operandParam != null) {
            operandMin = operandParam.getParam().optional() ? 0 : 1;
            int n = operandMax = operandParam.getParam().multiple() ? Integer.MAX_VALUE : 1;
        }
        if (this.operands.size() < operandMin && cons != null) {
            cons.printf("%s", strings.get("operandPrompt", new Object[]{operandParam.getName()}));
            String val = cons.readLine();
            if (CLICommand.ok(val)) {
                this.operands = new ArrayList<String>();
                this.operands.add(val);
            }
        }
        if (this.operands.size() < operandMin) {
            throw new CommandValidationException("Command " + this.name + " requires an operand of type " + String.valueOf(operandParam.getType()));
        }
        if (this.operands.size() > operandMax) {
            if (operandMax == 0) {
                throw new CommandValidationException("Command " + this.name + " does not accept any operands, but received: " + String.valueOf(this.operands));
            }
            if (operandMax == 1) {
                throw new CommandValidationException("Command " + this.name + " only accepts one operand, but received: " + String.valueOf(this.operands));
            }
            throw new CommandValidationException("Command " + this.name + " only accepts " + operandMax + " operands, but received: " + String.valueOf(this.operands));
        }
        this.initializeCommandPassword();
    }

    protected void inject() throws CommandException {
        this.options.set((Object)"DEFAULT", this.operands);
        if (this.commandModel.getModelFor("terse") != null) {
            this.options.set((Object)"terse", (Object)Boolean.toString(this.programOpts.isTerse()));
        }
        MapInjectionResolver injector = new MapInjectionResolver(this.commandModel, this.options);
        try {
            injectionMgr.inject((Object)this, new InjectionResolver[]{injector});
        }
        catch (UnsatisfiedDependencyException e) {
            throw new CommandValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected void validate() throws CommandException {
    }

    protected abstract int executeCommand() throws CommandException;

    private void initializeCommandPassword() throws CommandException {
        for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
            if (!opt.getParam().password()) continue;
            String pwdname = opt.getName();
            char[] pwd = this.getPassword(opt, null, true);
            if (pwd == null) {
                if (opt.getParam().optional()) continue;
                String msg = this.programOpts.isTerse() ? strings.get("missingPassword", new Object[]{this.name, this.passwordName(opt)}) : strings.get("missingPasswordAdvice", new Object[]{this.name, this.passwordName(opt)});
                throw new CommandValidationException(msg);
            }
            this.options.set((Object)pwdname, (Object)new String(pwd));
        }
    }

    protected char[] getPassword(String paramname, String localizedPrompt, String localizedPromptConfirm, boolean create) throws CommandValidationException {
        CommandModelData.ParamModelData po = new CommandModelData.ParamModelData(paramname, String.class, false, null);
        po.prompt = localizedPrompt;
        po.promptAgain = localizedPromptConfirm;
        po.param._password = true;
        return this.getPassword((CommandModel.ParamModel)po, null, create);
    }

    protected char[] getPassword(CommandModel.ParamModel opt, String defaultPassword, boolean create) throws CommandValidationException {
        char[] password;
        String passwordName = this.passwordName(opt);
        char[] cArray = password = this.passwords.get(passwordName) != null ? this.passwords.get(passwordName).toCharArray() : null;
        if (password != null) {
            return password;
        }
        if (opt.getParam().optional()) {
            return null;
        }
        if (!this.programOpts.isInteractive()) {
            return null;
        }
        String prompt = null;
        String promptAgain = null;
        if (opt instanceof CommandModelData.ParamModelData) {
            prompt = ((CommandModelData.ParamModelData)opt).getPrompt();
            promptAgain = ((CommandModelData.ParamModelData)opt).getPromptAgain();
        }
        String newprompt = CLICommand.ok(prompt) ? (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDescriptionDefaultEmptyPrompt", new Object[]{prompt}) : strings.get("NewPasswordDescriptionDefaultPrompt", new Object[]{prompt, defaultPassword})) : strings.get("NewPasswordDescriptionPrompt", new Object[]{prompt})) : (defaultPassword != null ? (defaultPassword.length() == 0 ? strings.get("NewPasswordDefaultEmptyPrompt", new Object[]{passwordName}) : strings.get("NewPasswordDefaultPrompt", new Object[]{passwordName, defaultPassword})) : strings.get("NewPasswordPrompt", new Object[]{passwordName}));
        char[] newpassword = this.readPassword(newprompt);
        if (defaultPassword != null) {
            if (newpassword == null) {
                newpassword = "".toCharArray();
            }
            if (newpassword.length == 0) {
                newpassword = defaultPassword.toCharArray();
                this.passwords.put(passwordName, new String(newpassword));
                return newpassword;
            }
        }
        if (!create) {
            this.passwords.put(passwordName, newpassword != null ? new String(newpassword) : null);
            return newpassword;
        }
        String confirmationPrompt = CLICommand.ok(promptAgain) ? strings.get("NewPasswordDescriptionPrompt", new Object[]{promptAgain}) : strings.get("NewPasswordConfirmationPrompt", new Object[]{passwordName});
        char[] newpasswordAgain = this.readPassword(confirmationPrompt);
        if (!Arrays.equals(newpassword, newpasswordAgain)) {
            throw new CommandValidationException(strings.get("OptionsDoNotMatch", new Object[]{CLICommand.ok(prompt) ? prompt : passwordName}));
        }
        this.passwords.put(passwordName, newpassword != null ? new String(newpassword) : null);
        return newpassword;
    }

    private String passwordName(CommandModel.ParamModel opt) {
        return Environment.getPrefix() + opt.getName().toUpperCase(Locale.ENGLISH);
    }

    protected char[] readPassword(String prompt) {
        char[] password = null;
        Console cons = System.console();
        if (cons != null) {
            password = cons.readPassword("%s", prompt);
        }
        return password;
    }

    protected CommandModel.ParamModel getOperandModel() {
        for (CommandModel.ParamModel pm : this.commandModel.getParameters()) {
            if (!pm.getParam().primary()) continue;
            return pm;
        }
        return null;
    }

    protected String getOption(String name) {
        String def;
        CommandModel.ParamModel opt;
        String val = (String)this.options.getOne((Object)name);
        if (val == null) {
            val = this.env.getStringOption(name);
        }
        if (val == null && (opt = this.commandModel.getModelFor(name)) != null && CLICommand.ok(def = opt.getParam().defaultValue())) {
            val = def;
        }
        return val;
    }

    protected List<String> getOptions(String name) {
        String def;
        CommandModel.ParamModel opt;
        String v;
        List val = this.options.get((Object)name);
        if (val.isEmpty() && (v = this.env.getStringOption(name)) != null) {
            val.add(v);
        }
        if (val.isEmpty() && (opt = this.commandModel.getModelFor(name)) != null && CLICommand.ok(def = opt.getParam().defaultValue())) {
            val.add(def);
        }
        return val;
    }

    protected boolean getBooleanOption(String name) {
        String val = this.getOption(name);
        return val != null && Boolean.parseBoolean(val);
    }

    protected String getSystemProperty(String name) {
        return systemProps.get(name);
    }

    protected Map<String, String> getSystemProperties() {
        return systemProps;
    }

    private static void checkUnsupportedLegacyCommand(String cmd) throws CommandException {
        for (String c : unsupported) {
            if (!c.equals(cmd)) continue;
            throw new CommandException(strings.get("UnsupportedLegacyCommand", new Object[]{cmd}));
        }
    }

    protected static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }

    private static String lc(String s) {
        return s.toLowerCase(Locale.ENGLISH);
    }

    private static void file2Set(String file, Set<String> set) {
        try (InputStream is = CLICommand.class.getClassLoader().getResourceAsStream(file);
             BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                StringTokenizer tok = new StringTokenizer(line, " ");
                String cmd = tok.nextToken();
                set.add(cmd);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not parse resource file " + file, e);
        }
    }

    static {
        strings = new LocalStringsImpl(CLICommand.class);
        systemProps = Collections.unmodifiableMap(new ASenvPropertyReader().getProps());
        logger = Logger.getLogger(CLICommand.class.getPackage().getName());
        injectionMgr = new InjectionManager();
        manpageTokens = new String[]{"cname", "cprefix", "product---name"};
        HashSet<String> unsup = new HashSet<String>();
        CLICommand.file2Set(UNSUPPORTED_CMD_FILE_NAME, unsup);
        unsupported = Collections.unmodifiableSet(unsup);
    }

    private static class NoValueModel
    extends CommandModel.ParamModel {
        private final Param param;

        NoValueModel(final String name, final String shortName, final boolean optional) {
            this.param = new Param(){

                public Class<? extends Annotation> annotationType() {
                    return null;
                }

                public String shortName() {
                    return shortName;
                }

                public char separator() {
                    return '\u0000';
                }

                public boolean primary() {
                    return false;
                }

                public boolean password() {
                    return false;
                }

                public boolean optional() {
                    return optional;
                }

                public boolean obsolete() {
                    return false;
                }

                public String name() {
                    return name;
                }

                public boolean multiple() {
                    return false;
                }

                public String defaultValue() {
                    return null;
                }

                public Class<? extends ParamDefaultCalculator> defaultCalculator() {
                    return null;
                }

                public String alias() {
                    return null;
                }

                public String acceptableValues() {
                    return null;
                }
            };
        }

        public String getName() {
            return this.param.name();
        }

        public Param getParam() {
            return this.param;
        }

        public String getLocalizedDescription() {
            return null;
        }

        public String getLocalizedPrompt() {
            return null;
        }

        public String getLocalizedPromptAgain() {
            return null;
        }

        public Class<Void> getType() {
            return Void.class;
        }
    }

    private static class OptionComparator
    implements Comparator<CommandModel.ParamModel> {
        private OptionComparator() {
        }

        @Override
        public int compare(CommandModel.ParamModel o1, CommandModel.ParamModel o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

