/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class MetaTypeProviderImpl
implements MetaTypeProvider,
ManagedService {
    private final int m_threadPoolSize;
    private final int m_timeout;
    private final boolean m_requireTopic;
    private final String[] m_ignoreTimeout;
    private final String[] m_ignoreTopic;
    private final double m_asyncThreadPoolRatio;
    private final ManagedService m_delegatee;
    private ObjectClassDefinition ocd;

    public MetaTypeProviderImpl(ManagedService delegatee, int threadPoolSize, int timeout, boolean requireTopic, String[] ignoreTimeout, String[] ignoreTopic, double asyncThreadPoolRatio) {
        this.m_threadPoolSize = threadPoolSize;
        this.m_timeout = timeout;
        this.m_requireTopic = requireTopic;
        this.m_delegatee = delegatee;
        this.m_ignoreTimeout = ignoreTimeout;
        this.m_ignoreTopic = ignoreTopic;
        this.m_asyncThreadPoolRatio = asyncThreadPoolRatio;
    }

    public void updated(Dictionary<String, ?> properties) throws ConfigurationException {
        this.m_delegatee.updated(properties);
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.eventadmin.impl.EventAdmin".equals(id)) {
            return null;
        }
        if (this.ocd == null) {
            final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.ThreadPoolSize", "Thread Pool Size", "The size of the thread pool used for event delivery. The default value is 20. Increase in case of a large amount of events. A value of less then 2 triggers the default value. If the pool is exhausted, event delivery is blocked until a thread becomes available from the pool. Each event is delivered in a thread from the pool unless the ignore timeouts is configured for the receiving event handler.", this.m_threadPoolSize));
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.AsyncToSyncThreadRatio", "Async/sync Thread Pool Ratio", "The ratio of asynchronous to synchronous threads in the internal thread pool. Ratio must be positive and may be adjusted to represent the distribution of post to send operations.  Applications with higher number of post operations should have a higher ratio.", this.m_asyncThreadPoolRatio));
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.Timeout", "Timeout", "The deny-list timeout in milliseconds. The default value is 5000. Increase or decrease at own discretion. A value of less then 100 turns timeouts off. Any other value is the time in milliseconds granted to each event handler before it gets denied", this.m_timeout));
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.RequireTopic", "Require Topic", "Are event handlers required to be registered with a topic? This is enabled by default. The specification says that event handlers must register with a list of topics they are interested in. Disabling this setting will enable that handlers without a topic are receiving all events (i.e., they are treated the same as with a topic=*).", this.m_requireTopic));
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.IgnoreTimeout", "Ignore Timeouts", "Configure event handlers to be called without a timeout. If a timeout is configured by default all event handlers are called using the timeout. For performance optimization it is possible to configure event handlers where the timeout handling is not used - this reduces the thread usage from the thread pools as the timout handling requires an additional thread to call the event handler. However, the application should work without this configuration property. It is a pure optimization! The value is a list of strings. If a string ends with a dot, all handlers in exactly this package are ignored. If the string ends with a star, all handlers in this package and all subpackages are ignored. If the string neither ends with a dot nor with a star, this is assumed to define an exact class name.", 1, this.m_ignoreTimeout, Integer.MAX_VALUE, null, null));
            adList.add(new AttributeDefinitionImpl("org.apache.felix.eventadmin.IgnoreTopic", "Ignore Topics", "For performance optimization it is possible to configure topics which are ignored by the event admin implementation. In this case, a event is not delivered to registered event handlers. The value is a list of strings (separated by comma). If a single value ends with a dot, all topics in exactly this package are ignored. If a single value ends with a star, all topics in this package and all sub packages are ignored. If a single value neither ends with a dot nor with a start, this is assumed to define an exact topic. A single star can be used to disable delivery completely.", 1, this.m_ignoreTopic, Integer.MAX_VALUE, null, null));
            this.ocd = new ObjectClassDefinition(){
                private final AttributeDefinition[] attrs;
                {
                    this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
                }

                public String getName() {
                    return "Apache Felix Event Admin Implementation";
                }

                public InputStream getIcon(int arg0) {
                    return null;
                }

                public String getID() {
                    return "org.apache.felix.eventadmin.impl.EventAdmin";
                }

                public String getDescription() {
                    return "Configuration for the Apache Felix Event Admin Implementation. This configuration overwrites configuration defined in framework properties of the same names.";
                }

                public AttributeDefinition[] getAttributeDefinitions(int filter) {
                    return filter == 2 ? null : this.attrs;
                }
            };
        }
        return this.ocd;
    }

    class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;

        AttributeDefinitionImpl(String id, String name, String description, boolean defaultValue) {
            this(id, name, description, 11, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int defaultValue) {
            this(id, name, description, 3, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, double defaultValue) {
            this(id, name, description, 7, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(String id, String name, String description, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

