/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.fscontext;

import com.sun.jndi.fscontext.FSNameParser;
import com.sun.jndi.fscontext.FileNameClassEnumeration;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Array;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.NamingManager;

public class FSContext
implements Context,
Referenceable {
    public static final String URL_ADDR_TYPE = "URL";
    private static final boolean debug = false;
    FSFile backingDirectory;
    CompositeName myName;
    protected Hashtable environment;
    public static final NameParser parser = new FSNameParser();
    static /* synthetic */ Class class$javax$naming$Context;
    static /* synthetic */ Class class$com$sun$jndi$fscontext$FSContextFactory;

    public FSContext(File file, Hashtable hashtable) throws NamingException {
        this.environment = hashtable != null ? (Hashtable)hashtable.clone() : new Hashtable(11, 0.75f);
        this.backingDirectory = new FSFile(file.toString());
        this.checkIsDirectory(this.backingDirectory);
        this.myName = new CompositeName();
        if (!file.toString().equals("")) {
            this.myName.add(file.toString());
        }
    }

    public FSContext(String string, Hashtable hashtable) throws NamingException {
        this(new File(string), hashtable);
        this.myName = new CompositeName();
        if (!string.equals("")) {
            this.myName.add(string);
        }
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        this.environment = this.environment == null ? new Hashtable(11, 0.75f) : (Hashtable)this.environment.clone();
        return this.environment.put(string, object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.bind(parser.parse(string), object);
    }

    public void bind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("can't bind arbitrary objects in an FSContext");
    }

    protected void checkCanRead(FSFile fSFile) throws NamingException {
        try {
            if (!fSFile.canRead()) {
                NoPermissionException noPermissionException = new NoPermissionException();
                CompositeName compositeName = new CompositeName();
                compositeName.add(fSFile.getRemaining());
                noPermissionException.setRemainingName(compositeName);
                noPermissionException.setResolvedObj(this);
                noPermissionException.setResolvedName(this.myName);
                throw noPermissionException;
            }
        }
        catch (SecurityException securityException) {
            NoPermissionException noPermissionException = new NoPermissionException();
            CompositeName compositeName = new CompositeName();
            compositeName.add(fSFile.getRemaining());
            noPermissionException.setRemainingName(compositeName);
            noPermissionException.setResolvedObj(this);
            noPermissionException.setResolvedName(this.myName);
            throw noPermissionException;
        }
    }

    protected void checkCanWrite(File file) throws NamingException {
        try {
            if (file.isDirectory() || file.exists()) {
                if (!file.canWrite()) {
                    NoPermissionException noPermissionException = new NoPermissionException();
                    CompositeName compositeName = new CompositeName();
                    if (file instanceof FSFile) {
                        compositeName.add(((FSFile)file).getRemaining());
                    } else {
                        compositeName.add(file.getPath());
                    }
                    noPermissionException.setRemainingName(compositeName);
                    noPermissionException.setResolvedObj(this);
                    noPermissionException.setResolvedName(this.myName);
                    throw noPermissionException;
                }
            } else {
                File file2 = new File(file.getParent());
                if (!file2.canWrite()) {
                    NoPermissionException noPermissionException = new NoPermissionException();
                    CompositeName compositeName = new CompositeName();
                    compositeName.add(file2.getPath());
                    noPermissionException.setRemainingName(compositeName);
                    noPermissionException.setResolvedObj(this);
                    noPermissionException.setResolvedName(this.myName);
                    throw noPermissionException;
                }
            }
        }
        catch (SecurityException securityException) {
            NoPermissionException noPermissionException = new NoPermissionException();
            CompositeName compositeName = new CompositeName();
            if (file instanceof FSFile) {
                compositeName.add(((FSFile)file).getRemaining());
            } else {
                compositeName.add(file.getPath());
            }
            noPermissionException.setRemainingName(compositeName);
            noPermissionException.setResolvedObj(this);
            noPermissionException.setResolvedName(this.myName);
            throw noPermissionException;
        }
    }

    protected void checkContextEmpty(FSFile fSFile) throws NamingException {
        if (Array.getLength(fSFile.list()) != 0) {
            ContextNotEmptyException contextNotEmptyException = new ContextNotEmptyException();
            CompositeName compositeName = new CompositeName();
            compositeName.add(fSFile.getRemaining());
            contextNotEmptyException.setRemainingName(compositeName);
            contextNotEmptyException.setResolvedObj(this);
            contextNotEmptyException.setResolvedName(this.myName);
            throw contextNotEmptyException;
        }
    }

    protected void checkDoesntExist(File file) throws NamingException {
        if (file.exists()) {
            NameAlreadyBoundException nameAlreadyBoundException = new NameAlreadyBoundException();
            CompositeName compositeName = new CompositeName();
            if (file instanceof FSFile) {
                compositeName.add(((FSFile)file).getRemaining());
            } else {
                compositeName.add(file.getPath());
            }
            nameAlreadyBoundException.setRemainingName(compositeName);
            nameAlreadyBoundException.setResolvedObj(this);
            nameAlreadyBoundException.setResolvedName(this.myName);
            throw nameAlreadyBoundException;
        }
    }

    protected void checkExists(FSFile fSFile) throws NamingException {
        if (!fSFile.exists()) {
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            CompositeName compositeName = new CompositeName();
            compositeName.add(fSFile.getRemaining());
            nameNotFoundException.setRemainingName(compositeName);
            nameNotFoundException.setResolvedObj(this);
            nameNotFoundException.setResolvedName(this.myName);
            throw nameNotFoundException;
        }
    }

    protected void checkIsDirectory(FSFile fSFile) throws NamingException {
        this.checkExists(fSFile);
        if (!fSFile.isDirectory()) {
            NotContextException notContextException = new NotContextException();
            CompositeName compositeName = new CompositeName();
            compositeName.add(fSFile.getRemaining());
            notContextException.setRemainingName(compositeName);
            notContextException.setResolvedObj(this);
            notContextException.setResolvedName(this.myName);
            throw notContextException;
        }
    }

    protected void checkIsNotDirectory(FSFile fSFile) throws NamingException {
        this.checkExists(fSFile);
        if (fSFile.isDirectory()) {
            NamingException namingException = new NamingException("cannot operate on directory");
            CompositeName compositeName = new CompositeName();
            compositeName.add(fSFile.getRemaining());
            namingException.setRemainingName(compositeName);
            namingException.setResolvedObj(this);
            namingException.setResolvedName(this.myName);
            throw namingException;
        }
    }

    protected void checkNameNotEmpty(Name name) throws NamingException {
        if (name == null || name.isEmpty()) {
            InvalidNameException invalidNameException = new InvalidNameException("Name must be non-empty");
            invalidNameException.setRemainingName(name);
            invalidNameException.setResolvedObj(this);
            invalidNameException.setResolvedName(this.myName);
            throw invalidNameException;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void close() throws NamingException {
        this.backingDirectory = null;
        this.environment = null;
    }

    public String composeName(String string, String string2) throws NamingException {
        Name name = this.composeName(new CompositeName(string), new CompositeName(string2));
        return name.toString();
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        name3.addAll(name);
        return name3;
    }

    Context createContext(File file) throws NamingException {
        return new FSContext(file, this.environment);
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(parser.parse(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        FSFile fSFile = this.getFile(name);
        boolean bl = false;
        this.checkDoesntExist(fSFile);
        this.checkCanWrite(new FSFile(fSFile.getParent()));
        try {
            bl = fSFile.mkdir();
        }
        catch (Exception exception) {
            throw this.generateNamingException(exception, name.toString());
        }
        if (!bl && !bl) {
            NamingException namingException = new NamingException("couldn't create the subcontext for an unknown reason");
            namingException.setRemainingName(name);
            namingException.setResolvedObj(this);
            namingException.setResolvedName(this.myName);
            throw namingException;
        }
        return this.createContext(fSFile);
    }

    public void destroySubcontext(String string) throws NamingException {
        this.destroySubcontext(parser.parse(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        boolean bl = false;
        this.checkNameNotEmpty(name);
        FSFile fSFile = this.getFile(name);
        try {
            this.checkIsDirectory(fSFile);
        }
        catch (NameNotFoundException nameNotFoundException) {
            File file = new File(fSFile.getParent());
            if (file.exists()) {
                return;
            }
            throw nameNotFoundException;
        }
        this.checkContextEmpty(fSFile);
        this.checkCanWrite(fSFile);
        try {
            bl = fSFile.delete();
        }
        catch (Exception exception) {
            throw this.generateNamingException(exception, name.toString());
        }
        if (!bl) {
            NamingException namingException = new NamingException("couldn't destroy the subcontext for an unknown reason");
            namingException.setRemainingName(name);
            namingException.setResolvedObj(this);
            namingException.setResolvedName(this.myName);
            throw namingException;
        }
    }

    protected NamingException generateNamingException(Exception exception) {
        return this.generateNamingException(exception, null);
    }

    protected NamingException generateNamingException(Exception exception, String string) {
        if (exception instanceof NamingException) {
            return (NamingException)exception;
        }
        NamingException namingException = exception instanceof SecurityException ? new NoPermissionException() : (exception instanceof FileNotFoundException ? new NameNotFoundException() : new NamingException("unexpected exception"));
        if (!string.equals("")) {
            CompositeName compositeName = new CompositeName();
            try {
                compositeName.add(string);
                namingException.setRemainingName(compositeName);
            }
            catch (NamingException namingException2) {}
        }
        namingException.setRootCause(exception);
        namingException.setResolvedObj(this);
        namingException.setResolvedName(this.myName);
        return namingException;
    }

    String getClassName() {
        return (class$javax$naming$Context != null ? class$javax$naming$Context : (class$javax$naming$Context = FSContext.class$("javax.naming.Context"))).getName();
    }

    public Hashtable getEnvironment() throws NamingException {
        if (this.environment == null) {
            return new Hashtable(5, 0.75f);
        }
        return (Hashtable)this.environment.clone();
    }

    String getFactoryName() {
        return (class$com$sun$jndi$fscontext$FSContextFactory != null ? class$com$sun$jndi$fscontext$FSContextFactory : (class$com$sun$jndi$fscontext$FSContextFactory = FSContext.class$("com.sun.jndi.fscontext.FSContextFactory"))).getName();
    }

    protected FSFile getFile(Name name) {
        String string = name.toString();
        if (File.separatorChar == '\\' && string.length() >= 2 && string.charAt(1) == ':') {
            return new FSFile(string);
        }
        return new FSFile(this.backingDirectory, string);
    }

    public String getNameInNamespace() throws NamingException {
        return this.backingDirectory.getAbsolutePath();
    }

    public NameParser getNameParser(String string) throws NamingException {
        return parser;
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return parser;
    }

    public Reference getReference() {
        StringRefAddr stringRefAddr = new StringRefAddr(URL_ADDR_TYPE, this.getURLString());
        return new Reference(this.getClassName(), stringRefAddr, this.getFactoryName(), null);
    }

    protected String getURLString() {
        String string = this.backingDirectory.getAbsolutePath();
        String string2 = string.startsWith(File.separator) ? ":" : ":/";
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        return "file" + string2 + string;
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.list(parser.parse(string));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            FSFile fSFile = this.getFile(name);
            this.checkIsDirectory(fSFile);
            this.checkCanRead(fSFile);
            return new FileNameClassEnumeration(this, fSFile);
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            return ((Context)object).list(FSNameParser.EMPTY_NAME);
        }
        throw new NotContextException(name.toString());
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.listBindings(parser.parse(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            FSFile fSFile = this.getFile(name);
            this.checkIsDirectory(fSFile);
            this.checkCanRead(fSFile);
            return new FileBindingEnumeration(this, fSFile);
        }
        Object object = this.lookup(name);
        if (object instanceof Context) {
            return ((Context)object).list(FSNameParser.EMPTY_NAME);
        }
        throw new NotContextException(name.toString());
    }

    public Object lookup(String string) throws NamingException {
        return this.lookup(parser.parse(string));
    }

    public Object lookup(Name name) throws NamingException {
        FSFile fSFile = this.getFile(name);
        this.checkExists(fSFile);
        if (fSFile.isDirectory()) {
            return this.createContext(fSFile);
        }
        try {
            return NamingManager.getObjectInstance(fSFile, name, this, this.environment);
        }
        catch (Exception exception) {
            throw this.generateNamingException(exception, name.toString());
        }
    }

    public Object lookupLink(String string) throws NamingException {
        return this.lookupLink(parser.parse(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookup(name);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.rebind(parser.parse(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        throw new OperationNotSupportedException("can't bind arbitrary objects in an FSContext");
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.environment == null) {
            return null;
        }
        this.environment = (Hashtable)this.environment.clone();
        return this.environment.remove(string);
    }

    public void rename(String string, String string2) throws NamingException {
        this.rename(parser.parse(string), parser.parse(string2));
    }

    public void rename(Name name, Name name2) throws NamingException {
        boolean bl = false;
        this.checkNameNotEmpty(name);
        this.checkNameNotEmpty(name2);
        FSFile fSFile = this.getFile(name);
        this.checkExists(fSFile);
        try {
            bl = fSFile.renameTo(this.getFile(name2));
        }
        catch (Exception exception) {
            throw this.generateNamingException(exception);
        }
        if (!bl) {
            NamingException namingException = new NamingException("couldn't rename the subcontext for an unkown reason");
            namingException.setRemainingName(name);
            namingException.setResolvedObj(this);
            namingException.setResolvedName(this.myName);
            throw namingException;
        }
    }

    public void unbind(String string) throws NamingException {
        this.unbind(parser.parse(string));
    }

    public void unbind(Name name) throws NamingException {
        boolean bl = false;
        this.checkNameNotEmpty(name);
        FSFile fSFile = this.getFile(name);
        try {
            this.checkIsNotDirectory(fSFile);
        }
        catch (NameNotFoundException nameNotFoundException) {
            File file = new File(fSFile.getParent());
            if (file.exists()) {
                return;
            }
            throw nameNotFoundException;
        }
        this.checkCanWrite(fSFile);
        try {
            bl = fSFile.delete();
        }
        catch (Exception exception) {
            throw this.generateNamingException(exception, name.toString());
        }
        if (!bl) {
            NamingException namingException = new NamingException("couldn't unbind for an unknown reason");
            namingException.setRemainingName(name);
            namingException.setResolvedObj(this);
            namingException.setResolvedName(this.myName);
            throw namingException;
        }
    }

    static class FSFile
    extends File {
        private String remaining;

        FSFile(File file, String string) {
            super(file, string);
            this.remaining = string;
        }

        FSFile(String string) {
            super(string);
            this.remaining = string;
        }

        String getRemaining() {
            return this.remaining;
        }
    }

    class FileBindingEnumeration
    extends FileNameClassEnumeration {
        FileBindingEnumeration(FSContext fSContext2, File file) {
            super(fSContext2, file);
        }

        protected Object fileToEnumerationObj(File file) throws NamingException {
            Object object = file.isFile() ? file : this.parentCtx.createContext(file);
            try {
                Name name = new CompositeName().add(file.getName());
                if (!(object instanceof FSContext)) {
                    object = NamingManager.getObjectInstance(object, name, this.parentCtx, FSContext.this.environment);
                }
                return new Binding(name.toString(), object);
            }
            catch (Exception exception) {
                throw FSContext.this.generateNamingException(exception, file.getName());
            }
        }
    }
}

