/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.io.Serializable;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.catalina.LogFacade;
import org.apache.catalina.filters.FilterBase;

public class CsrfPreventionFilter
extends FilterBase {
    protected static final Logger log = LogFacade.getLogger();
    private String randomClass = SecureRandom.class.getName();
    private Random randomSource;
    private final Set<String> entryPoints = new HashSet<String>();
    private int nonceCacheSize = 5;

    @Override
    protected Logger getLogger() {
        return log;
    }

    public void setEntryPoints(String entryPoints) {
        String[] values;
        for (String value : values = entryPoints.split(",")) {
            this.entryPoints.add(value.trim());
        }
    }

    public void setNonceCacheSize(int nonceCacheSize) {
        this.nonceCacheSize = nonceCacheSize;
    }

    public void setRandomClass(String randomClass) {
        this.randomClass = randomClass;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        String msg = MessageFormat.format(rb.getString("AS-WEB-CORE-00286"), this.randomClass);
        try {
            Class<?> clazz = Class.forName(this.randomClass);
            this.randomSource = (Random)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            ServletException se = new ServletException(msg, (Throwable)e);
            throw se;
        }
        catch (InstantiationException e) {
            ServletException se = new ServletException(msg, (Throwable)e);
            throw se;
        }
        catch (IllegalAccessException e) {
            ServletException se = new ServletException(msg, (Throwable)e);
            throw se;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Object wResponse = null;
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            HttpSession session;
            LruCache<String> nonceCache;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            boolean skipNonceCheck = false;
            if ("GET".equals(req.getMethod())) {
                Object path = req.getServletPath();
                if (req.getPathInfo() != null) {
                    path = (String)path + req.getPathInfo();
                }
                if (this.entryPoints.contains(path)) {
                    skipNonceCheck = true;
                }
            }
            LruCache<String> lruCache = nonceCache = (session = req.getSession(false)) == null ? null : (LruCache<String>)session.getAttribute("org.apache.catalina.filters.CSRF_NONCE");
            if (!skipNonceCheck) {
                String previousNonce = req.getParameter("org.apache.catalina.filters.CSRF_NONCE");
                if (nonceCache == null || previousNonce == null || !nonceCache.contains(previousNonce)) {
                    res.sendError(403);
                    return;
                }
            }
            if (nonceCache == null) {
                nonceCache = new LruCache<String>(this.nonceCacheSize);
                if (session == null) {
                    session = req.getSession(true);
                }
                session.setAttribute("org.apache.catalina.filters.CSRF_NONCE", nonceCache);
            }
            String newNonce = this.generateNonce();
            nonceCache.add(newNonce);
            wResponse = new CsrfResponseWrapper(res, newNonce);
        } else {
            wResponse = response;
        }
        chain.doFilter(request, wResponse);
    }

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    protected String generateNonce() {
        byte[] random = new byte[16];
        StringBuilder buffer = new StringBuilder();
        this.randomSource.nextBytes(random);
        for (int j = 0; j < random.length; ++j) {
            byte b1 = (byte)((random[j] & 0xF0) >> 4);
            byte b2 = (byte)(random[j] & 0xF);
            if (b1 < 10) {
                buffer.append((char)(48 + b1));
            } else {
                buffer.append((char)(65 + (b1 - 10)));
            }
            if (b2 < 10) {
                buffer.append((char)(48 + b2));
                continue;
            }
            buffer.append((char)(65 + (b2 - 10)));
        }
        return buffer.toString();
    }

    protected static class LruCache<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<T, T> cache;

        public LruCache(int cacheSize) {
            this.cache = new FixSizeLinkedHashMap<T, T>(cacheSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T key) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                this.cache.put(key, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean contains(T key) {
            Map<T, T> map = this.cache;
            synchronized (map) {
                return this.cache.containsKey(key);
            }
        }
    }

    protected static class CsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final String nonce;

        public CsrfResponseWrapper(HttpServletResponse response, String nonce) {
            super(response);
            this.nonce = nonce;
        }

        public String encodeRedirectURL(String url) {
            return this.addNonce(super.encodeRedirectURL(url));
        }

        public String encodeURL(String url) {
            return this.addNonce(super.encodeURL(url));
        }

        private String addNonce(String url) {
            int question;
            if (url == null || this.nonce == null) {
                return url;
            }
            String path = url;
            String query = "";
            String anchor = "";
            int pound = path.indexOf(35);
            if (pound >= 0) {
                anchor = path.substring(pound);
                path = path.substring(0, pound);
            }
            if ((question = path.indexOf(63)) >= 0) {
                query = path.substring(question);
                path = path.substring(0, question);
            }
            StringBuilder sb = new StringBuilder(path);
            if (query.length() > 0) {
                sb.append(query);
                sb.append('&');
            } else {
                sb.append('?');
            }
            sb.append("org.apache.catalina.filters.CSRF_NONCE");
            sb.append('=');
            sb.append(this.nonce);
            sb.append(anchor);
            return sb.toString();
        }
    }

    private static class FixSizeLinkedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private int cacheSize;

        private FixSizeLinkedHashMap(int cs) {
            this.cacheSize = cs;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.cacheSize;
        }
    }
}

