/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.impl.servicecontext;

import com.sun.corba.ee.impl.encoding.CDRInputObject;
import com.sun.corba.ee.impl.encoding.EncapsInputStream;
import com.sun.corba.ee.impl.encoding.EncapsInputStreamFactory;
import com.sun.corba.ee.spi.ior.iiop.GIOPVersion;
import com.sun.corba.ee.spi.logging.ORBUtilSystemException;
import com.sun.corba.ee.spi.servicecontext.ServiceContext;
import com.sun.corba.ee.spi.servicecontext.ServiceContextDefaults;
import com.sun.corba.ee.spi.servicecontext.ServiceContextFactoryRegistry;
import com.sun.corba.ee.spi.servicecontext.ServiceContexts;
import com.sun.corba.ee.spi.trace.TraceServiceContext;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.glassfish.pfl.tf.spi.annotation.InfoMethod;
import org.omg.CORBA.ORB;
import org.omg.CORBA.OctetSeqHelper;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

@TraceServiceContext
public class ServiceContextsImpl
implements ServiceContexts {
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.self;
    private static final AtomicInteger creationCount = new AtomicInteger(0);
    private final com.sun.corba.ee.spi.orb.ORB orb;
    private final Map<Integer, Object> scMap;
    private CodeBase codeBase;
    private GIOPVersion giopVersion;

    private String getValidSCIds() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        boolean first = true;
        for (int id : this.scMap.keySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(id);
        }
        sb.append(")");
        return sb.toString();
    }

    @InfoMethod
    private void numberValid(int num) {
    }

    @InfoMethod
    private void readingServiceContextId(int id) {
    }

    @InfoMethod
    private void serviceContextLength(int len) {
    }

    @TraceServiceContext
    private void createMapFromInputStream(InputStream is) {
        int numValid = is.read_long();
        this.numberValid(numValid);
        for (int ctr = 0; ctr < numValid; ++ctr) {
            int scId = is.read_long();
            this.readingServiceContextId(scId);
            byte[] data = OctetSeqHelper.read((org.omg.CORBA.portable.InputStream)is);
            this.serviceContextLength(data.length);
            this.scMap.put(scId, data);
        }
    }

    public ServiceContextsImpl(com.sun.corba.ee.spi.orb.ORB orb) {
        this.orb = orb;
        this.scMap = new HashMap<Integer, Object>();
        this.giopVersion = orb.getORBData().getGIOPVersion();
        this.codeBase = null;
    }

    public ServiceContextsImpl(InputStream s) {
        this((com.sun.corba.ee.spi.orb.ORB)s.orb());
        this.codeBase = ((CDRInputObject)s).getCodeBase();
        this.createMapFromInputStream(s);
        this.giopVersion = ((CDRInputObject)s).getGIOPVersion();
    }

    @InfoMethod
    private void couldNotFindServiceContextFactory(int scid) {
    }

    @InfoMethod
    private void foundServiceContextFactory(int scid) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TraceServiceContext
    private ServiceContext unmarshal(int scId, byte[] data) {
        ServiceContextFactoryRegistry scr = this.orb.getServiceContextFactoryRegistry();
        ServiceContext.Factory factory = scr.find(scId);
        ServiceContext sc = null;
        if (factory == null) {
            this.couldNotFindServiceContextFactory(scId);
            sc = ServiceContextDefaults.makeUnknownServiceContext(scId, data);
        } else {
            this.foundServiceContextFactory(scId);
            EncapsInputStream eis = EncapsInputStreamFactory.newEncapsInputStream((ORB)this.orb, data, data.length, this.giopVersion, this.codeBase);
            try {
                eis.consumeEndian();
                sc = factory.create(eis, this.giopVersion);
            }
            finally {
                try {
                    eis.close();
                }
                catch (IOException e) {
                    wrapper.ioexceptionDuringStreamClose(e);
                }
            }
            if (sc == null) {
                throw wrapper.svcctxUnmarshalError();
            }
        }
        return sc;
    }

    @Override
    @TraceServiceContext
    public void write(OutputStream os, GIOPVersion gv) {
        int numsc = this.scMap.size();
        os.write_long(numsc);
        this.writeServiceContextsInOrder(os, gv);
    }

    @TraceServiceContext
    private void writeServiceContextsInOrder(OutputStream os, GIOPVersion gv) {
        int ueid = 9;
        for (int i : this.scMap.keySet()) {
            if (i == ueid) continue;
            this.writeMapEntry(os, i, this.scMap.get(i), gv);
        }
        Object uesc = this.scMap.get(ueid);
        if (uesc != null) {
            this.writeMapEntry(os, ueid, uesc, gv);
        }
    }

    @InfoMethod
    private void writingServiceContextBytesFor(int id) {
    }

    @InfoMethod
    private void writingServiceContext(ServiceContext sc) {
    }

    @TraceServiceContext
    private void writeMapEntry(OutputStream os, int id, Object scObj, GIOPVersion gv) {
        if (scObj instanceof byte[]) {
            byte[] sc = (byte[])scObj;
            this.writingServiceContextBytesFor(id);
            OctetSeqHelper.write((org.omg.CORBA.portable.OutputStream)os, (byte[])sc);
        } else if (scObj instanceof ServiceContext) {
            ServiceContext sc = (ServiceContext)scObj;
            this.writingServiceContext(sc);
            sc.write(os, gv);
        } else {
            wrapper.errorInServiceContextMap();
        }
    }

    @Override
    @TraceServiceContext
    public void put(ServiceContext sc) {
        this.scMap.put(sc.getId(), sc);
    }

    @Override
    @TraceServiceContext
    public void delete(int scId) {
        this.scMap.remove(scId);
    }

    @InfoMethod
    private void serviceContextIdFound(int id) {
    }

    @InfoMethod
    private void serviceContextIdNotFound(int id) {
    }

    @InfoMethod
    private void unmarshallingServiceContext(int id) {
    }

    @Override
    @TraceServiceContext
    public ServiceContext get(int id) {
        Object result = this.scMap.get(id);
        if (result == null) {
            this.serviceContextIdNotFound(id);
            return null;
        }
        this.serviceContextIdFound(id);
        if (result instanceof byte[]) {
            this.unmarshallingServiceContext(id);
            ServiceContext sc = this.unmarshal(id, (byte[])result);
            this.scMap.put(id, sc);
            return sc;
        }
        return (ServiceContext)result;
    }

    private ServiceContextsImpl(ServiceContextsImpl scimpl) {
        this(scimpl.orb);
        this.codeBase = scimpl.codeBase;
        this.giopVersion = scimpl.giopVersion;
        for (Map.Entry<Integer, Object> entry : scimpl.scMap.entrySet()) {
            this.scMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @TraceServiceContext
    public ServiceContexts copy() {
        ServiceContextsImpl result = new ServiceContextsImpl(this);
        return result;
    }
}

