/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.wscompile;

import com.sun.istack.tools.ParallelWorldClassLoader;
import com.sun.tools.ws.resources.JavacompilerMessages;
import com.sun.tools.ws.wscompile.ErrorReceiver;
import java.io.File;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;

class JavaCompilerHelper {
    JavaCompilerHelper() {
    }

    static File getJarFile(Class<?> clazz) {
        URL url = null;
        try {
            url = ParallelWorldClassLoader.toJarUrl((URL)clazz.getResource("/" + clazz.getName().replace('.', '/') + ".class"));
            return new File(url.toURI());
        }
        catch (ClassNotFoundException | MalformedURLException e) {
            throw new Error(e);
        }
        catch (URISyntaxException e) {
            return new File(url.getPath());
        }
    }

    static boolean compile(String[] args, OutputStream out, ErrorReceiver receiver) {
        try {
            JavaCompiler comp = ToolProvider.getSystemJavaCompiler();
            if (comp == null) {
                receiver.error(JavacompilerMessages.NO_JAVACOMPILER_ERROR(), null);
                return false;
            }
            return 0 == comp.run(null, out, out, args);
        }
        catch (SecurityException e) {
            receiver.error(e);
            return false;
        }
    }
}

