/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.server;

import jakarta.persistence.spi.PersistenceUnitInfo;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Accessor;
import org.eclipse.persistence.internal.helper.JPAClassLoaderHolder;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.platform.server.ServerLog;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.ExternalTransactionController;
import org.eclipse.persistence.sessions.Session;

public abstract class ServerPlatformBase
implements ServerPlatform {
    public static final String JMX_REGISTER_DEV_MBEAN_PROPERTY = "eclipselink.register.dev.mbean";
    public static final String JMX_REGISTER_RUN_MBEAN_PROPERTY = "eclipselink.register.run.mbean";
    public static final String DEFAULT_SERVER_NAME_AND_VERSION = ToStringLocalization.buildMessage("unknown");
    private boolean isRuntimeServicesEnabled = this.isRuntimeServicesEnabledDefault();
    protected boolean shouldRegisterDevelopmentBean = true;
    protected boolean shouldRegisterRuntimeBean = true;
    protected Class<? extends ExternalTransactionController> externalTransactionControllerClass;
    private boolean isJTAEnabled = true;
    private boolean isCMP;
    private DatabaseSession databaseSession;
    protected String serverNameAndVersion;
    protected int threadPoolSize = 32;
    protected volatile ExecutorService threadPool;

    protected ServerPlatformBase(DatabaseSession newDatabaseSession) {
        String shouldRegisterDevelopmentBeanProperty;
        this.databaseSession = newDatabaseSession;
        this.setIsCMP(false);
        String shouldRegisterRuntimeBeanProperty = PrivilegedAccessHelper.getSystemProperty(JMX_REGISTER_RUN_MBEAN_PROPERTY);
        if (null != shouldRegisterRuntimeBeanProperty) {
            if (shouldRegisterRuntimeBeanProperty.toLowerCase().indexOf("false") > -1) {
                this.shouldRegisterRuntimeBean = false;
            }
            if (shouldRegisterRuntimeBeanProperty.toLowerCase().indexOf("true") > -1) {
                this.shouldRegisterRuntimeBean = true;
            }
        }
        if (null != (shouldRegisterDevelopmentBeanProperty = PrivilegedAccessHelper.getSystemProperty(JMX_REGISTER_DEV_MBEAN_PROPERTY))) {
            if (shouldRegisterDevelopmentBeanProperty.toLowerCase().indexOf("false") > -1) {
                this.shouldRegisterDevelopmentBean = false;
            }
            if (shouldRegisterDevelopmentBeanProperty.toLowerCase().indexOf("true") > -1) {
                this.shouldRegisterDevelopmentBean = true;
            }
        }
    }

    public void configureProfiler(Session session) {
    }

    @Override
    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    @Override
    public String getServerNameAndVersion() {
        if (this.serverNameAndVersion == null) {
            this.initializeServerNameAndVersion();
        }
        return this.serverNameAndVersion;
    }

    protected void initializeServerNameAndVersion() {
        this.serverNameAndVersion = DEFAULT_SERVER_NAME_AND_VERSION;
    }

    @Override
    public String getModuleName() {
        return DEFAULT_SERVER_NAME_AND_VERSION;
    }

    @Override
    public abstract Class<? extends ExternalTransactionController> getExternalTransactionControllerClass();

    @Override
    public void setExternalTransactionControllerClass(Class<? extends ExternalTransactionController> newClass) {
        this.externalTransactionControllerClass = newClass;
    }

    @Override
    public void initializeExternalTransactionController() {
        this.ensureNotLoggedIn();
        if (!this.isJTAEnabled() && !this.isCMP()) {
            return;
        }
        if (!this.isJTAEnabled() && this.isCMP()) {
            this.getDatabaseSession().getSessionLog().log(6, "ejb", "jta_cannot_be_disabled_in_cmp", null, true);
        }
        try {
            if (this.getDatabaseSession().getExternalTransactionController() != null) {
                this.externalTransactionControllerNotNullWarning();
                return;
            }
            ExternalTransactionController controller = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    controller = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass<ExternalTransactionController>(this.getExternalTransactionControllerClass()));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof InstantiationException) {
                        throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
                    }
                    throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
                }
            } else {
                controller = PrivilegedAccessHelper.newInstanceFromClass(this.getExternalTransactionControllerClass());
            }
            this.getDatabaseSession().setExternalTransactionController(controller);
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
    }

    protected void externalTransactionControllerNotNullWarning() {
        ((DatabaseSessionImpl)this.getDatabaseSession()).warning("External_transaction_controller_not_defined_by_server_platform", "ejb");
    }

    @Override
    public boolean isJTAEnabled() {
        return this.isJTAEnabled;
    }

    protected void setJTAEnabled(boolean isJTAEnabled) {
        this.isJTAEnabled = isJTAEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isJTA11() {
        InitialContext context = null;
        try {
            context = new InitialContext();
            if (context.lookup("java:comp/TransactionSynchronizationRegistry") != null) {
                boolean bl = true;
                return bl;
            }
        }
        catch (NamingException namingException) {
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    @Override
    public boolean isRuntimeServicesEnabledDefault() {
        return false;
    }

    @Override
    public boolean isRuntimeServicesEnabled() {
        return this.isRuntimeServicesEnabled;
    }

    @Override
    public void disableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = false;
    }

    public void enableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = true;
    }

    @Override
    public void disableJTA() {
        this.ensureNotLoggedIn();
        this.isJTAEnabled = false;
    }

    public void enableJTA() {
    }

    @Override
    public Connection unwrapConnection(Connection connection) {
        try {
            return connection.getMetaData().getConnection();
        }
        catch (SQLException e) {
            ((DatabaseSessionImpl)this.getDatabaseSession()).log(6, "connection", "cannot_unwrap_connection", e);
            return connection;
        }
    }

    @Override
    public void launchContainerRunnable(Runnable runnable) {
        if (this.getThreadPool() == null) {
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            this.getThreadPool().execute(runnable);
        }
    }

    protected void ensureNotLoggedIn() {
        if (this.getDatabaseSession() == null) {
            return;
        }
    }

    @Override
    public SessionLog getServerLog() {
        return new ServerLog();
    }

    @Override
    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    @Override
    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPool() {
        if (this.threadPool == null && this.threadPoolSize > 0) {
            ServerPlatformBase serverPlatformBase = this;
            synchronized (serverPlatformBase) {
                if (this.threadPool == null) {
                    this.threadPool = Executors.newFixedThreadPool(this.getThreadPoolSize());
                }
            }
        }
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public boolean isCMP() {
        return this.isCMP;
    }

    public void setIsCMP(boolean isThisCMP) {
        this.isCMP = isThisCMP;
    }

    @Override
    public boolean shouldUseDriverManager() {
        return true;
    }

    @Override
    public boolean wasFailureCommunicationBased(SQLException exception, Accessor connection, AbstractSession sessionForProfile) {
        return this.getDatabaseSession().getPlatform().wasFailureCommunicationBased(exception, connection.getConnection(), sessionForProfile);
    }

    @Override
    public JPAClassLoaderHolder getNewTempClassLoader(PersistenceUnitInfo puInfo) {
        return new JPAClassLoaderHolder(puInfo.getNewTempClassLoader(), true);
    }

    @Override
    public void clearStatementCache(Connection connection) {
    }

    @Override
    public void registerMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificRegisterMBean();
    }

    @Override
    public void unregisterMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificUnregisterMBean();
    }

    @Override
    public void shutdown() {
        this.unregisterMBean();
        if (this.threadPool != null) {
            this.threadPool.shutdownNow();
            this.threadPool = null;
        }
    }

    public void serverSpecificUnregisterMBean() {
    }

    public void serverSpecificRegisterMBean() {
    }

    @Override
    public int getJNDIConnectorLookupType() {
        return 2;
    }

    @Override
    public String getPartitionID() {
        return "GLOBAL";
    }

    @Override
    public boolean usesPartitions() {
        return false;
    }
}

