/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.component.Selector;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.ValueType;
import jakarta.el.ValueExpression;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.convert.ConverterException;
import java.util.List;

public class ValueTypeEvaluator {
    private static final boolean DEBUG = false;
    private ValueType valueType = null;
    private UIComponent component = null;

    public ValueTypeEvaluator(UIComponent newComponent) {
        this.component = newComponent;
        if (!(newComponent instanceof ValueHolder)) {
            this.valueType = ValueType.NONE;
        }
    }

    public ValueType getValueType() {
        if (this.valueType == null) {
            this.valueType = this.getValueType(FacesContext.getCurrentInstance());
        }
        return this.valueType;
    }

    public ValueType getValueType(FacesContext context) {
        if (this.valueType == null) {
            this.valueType = this.evaluateValueType(context);
        }
        return this.valueType;
    }

    public void reset() {
        this.valueType = null;
    }

    private ValueType evaluateValueType(FacesContext context) {
        ValueExpression valueExpr = this.component.getValueExpression("value");
        if (valueExpr != null) {
            return ValueTypeEvaluator.evaluateValueBinding(valueExpr, context);
        }
        Object valueObject = ((ValueHolder)this.component).getValue();
        if (valueObject == null) {
            if (this.component instanceof Selector) {
                boolean isMultiple = ((Selector)this.component).isMultiple();
                if (isMultiple) {
                    return ValueType.ARRAY;
                }
                return ValueType.OBJECT;
            }
            return ValueType.OBJECT;
        }
        return ValueTypeEvaluator.evaluateClass(valueObject.getClass());
    }

    private static ValueType evaluateValueBinding(ValueExpression valueExpression, FacesContext context) {
        Object value;
        Class<?> clazz = valueExpression.getType(context.getELContext());
        if (clazz == null) {
            String msg = "\tComponent has invalid value binding for \"value\".";
            throw new ConverterException(msg);
        }
        if (Object.class.equals((Object)clazz) && (value = valueExpression.getValue(context.getELContext())) != null) {
            clazz = value.getClass();
        }
        return ValueTypeEvaluator.evaluateClass(clazz);
    }

    private static ValueType evaluateClass(Class clazz) {
        if (clazz.isArray()) {
            return ValueType.ARRAY;
        }
        if (List.class.isAssignableFrom(clazz)) {
            return ValueType.LIST;
        }
        return ValueType.OBJECT;
    }

    private static void log(String msg) {
        LogUtil.finest(ValueTypeEvaluator.class.getName() + "::" + msg);
    }
}

