/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices.server;

import com.sun.enterprise.security.webservices.server.ServerSecurityPipe;
import com.sun.enterprise.util.Utility;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.pipe.Pipe;
import com.sun.xml.ws.api.server.WSEndpoint;
import com.sun.xml.ws.policy.Policy;
import com.sun.xml.ws.policy.PolicyException;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.PolicyMapKey;
import jakarta.inject.Singleton;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.glassfish.webservices.ServerPipeCreator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ServerSecurityPipeCreator
extends ServerPipeCreator {
    private static final String SECURITY_POLICY_NAMESPACE_URI_SUBMISSION = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy";
    private static final String SECURITY_POLICY_NAMESPACE_URI_SPECVERSION = "http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702";

    public Pipe createSecurityPipe(PolicyMap policyMap, SEIModel seiModel, WSDLPort port, WSEndpoint ownerEndpoint, Pipe tail) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("POLICY", policyMap);
        properties.put("SEI_MODEL", seiModel);
        properties.put("WSDL_MODEL", port);
        properties.put("ENDPOINT", ownerEndpoint);
        properties.put("SERVICE_ENDPOINT", this.endpoint);
        properties.put("NEXT_PIPE", tail);
        properties.put("CONTAINER", ownerEndpoint.getContainer());
        if (ServerSecurityPipeCreator.isSecurityEnabled(policyMap, port)) {
            this.endpoint.setSecurePipeline();
        }
        return new ServerSecurityPipe(properties, tail, this.isHttpBinding);
    }

    public static boolean isSecurityEnabled(PolicyMap policyMap, WSDLPort wsdlPort) {
        if (Utility.isAnyNull((Object[])new Object[]{policyMap, wsdlPort})) {
            return false;
        }
        try {
            Policy policy = policyMap.getEndpointEffectivePolicy(PolicyMap.createWsdlEndpointScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName()));
            if (ServerSecurityPipeCreator.isSecured(policy)) {
                return true;
            }
            for (WSDLBoundOperation operation : wsdlPort.getBinding().getBindingOperations()) {
                PolicyMapKey operationKey = PolicyMap.createWsdlOperationScopeKey((QName)wsdlPort.getOwner().getName(), (QName)wsdlPort.getName(), (QName)operation.getName());
                policy = policyMap.getOperationEffectivePolicy(operationKey);
                if (ServerSecurityPipeCreator.isSecured(policy)) {
                    return true;
                }
                policy = policyMap.getInputMessageEffectivePolicy(operationKey);
                if (ServerSecurityPipeCreator.isSecured(policy)) {
                    return true;
                }
                policy = policyMap.getOutputMessageEffectivePolicy(operationKey);
                if (ServerSecurityPipeCreator.isSecured(policy)) {
                    return true;
                }
                policy = policyMap.getFaultMessageEffectivePolicy(operationKey);
                if (!ServerSecurityPipeCreator.isSecured(policy)) continue;
                return true;
            }
        }
        catch (PolicyException e) {
            return false;
        }
        return false;
    }

    private static boolean isSecured(Policy policy) {
        if (policy == null) {
            return false;
        }
        return policy.contains(SECURITY_POLICY_NAMESPACE_URI_SPECVERSION) || policy.contains(SECURITY_POLICY_NAMESPACE_URI_SUBMISSION);
    }
}

