/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NamespaceTranslator {
    private static final Map<String, String> osgiToFelixMap = NamespaceTranslator.fillOSGiToFelixMap();
    private static final Map<String, String> felixToOSGiMap = NamespaceTranslator.fillFelixToOSGiMap();

    NamespaceTranslator() {
    }

    private static Map<String, String> fillOSGiToFelixMap() {
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("osgi.wiring.package", "package");
        result.put("osgi.service", "service");
        result.put("osgi.wiring.bundle", "bundle");
        result.put("osgi.wiring.host", "fragment");
        return Collections.unmodifiableMap(result);
    }

    private static Map<String, String> fillFelixToOSGiMap() {
        HashMap<String, String> result = new HashMap<String, String>(4);
        result.put("package", "osgi.wiring.package");
        result.put("service", "osgi.service");
        result.put("bundle", "osgi.wiring.bundle");
        result.put("fragment", "osgi.wiring.host");
        return Collections.unmodifiableMap(result);
    }

    public static String getFelixNamespace(String osgiNamespace) {
        String result = osgiToFelixMap.get(osgiNamespace);
        if (result == null) {
            return osgiNamespace;
        }
        return result;
    }

    public static Collection<String> getTranslatedFelixNamespaces() {
        return felixToOSGiMap.keySet();
    }

    public static String getOSGiNamespace(String felixNamespace) {
        String result = felixToOSGiMap.get(felixNamespace);
        if (result == null) {
            return felixNamespace;
        }
        return result;
    }

    public static Collection<String> getTranslatedOSGiNamespaces() {
        return osgiToFelixMap.keySet();
    }
}

