/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.jms.spi.xa.JMSXAConnectionFactory;
import com.sun.jms.spi.xa.JMSXATopicConnection;
import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedConnectionFactoryImpl;
import com.sun.messaging.jmq.jmsclient.JMSXAWrappedTopicSessionImpl;
import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.JMSException;
import jakarta.jms.TopicConnection;
import java.util.Vector;

public class JMSXAWrappedTopicConnectionImpl
implements JMSXATopicConnection {
    private static final boolean debug = JMSXAWrappedConnectionFactoryImpl.debug;
    private static System.Logger logger = System.getLogger(JMSXAWrappedTopicConnectionImpl.class.getName());
    private Connection wrapped_connection;
    private JMSXAWrappedConnectionFactoryImpl wcf_ = null;
    private String username_ = null;
    private String password_ = null;
    private Vector sessions_ = new Vector();
    private boolean markClosed_ = false;
    private boolean closed_ = false;

    public JMSXAWrappedTopicConnectionImpl(TopicConnection tconn, JMSXAWrappedConnectionFactoryImpl wcf, String username, String password) {
        this.wrapped_connection = tconn;
        this.wcf_ = wcf;
        this.username_ = username;
        this.password_ = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JMSXATopicSession createXATopicSession(boolean transacted, int acknowledgeMode) throws JMSException {
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.closed_) {
                throw new IllegalStateException("JMSXWrapped Connection has been closed");
            }
            if (this.markClosed_) {
                throw new IllegalStateException("JMSXAWrapped Connection is closed");
            }
            JMSXAWrappedTopicSessionImpl s = new JMSXAWrappedTopicSessionImpl((TopicConnection)this.wrapped_connection, transacted, acknowledgeMode, this);
            if (s.delaySessionClose()) {
                this.sessions_.add(s);
            }
            return s;
        }
    }

    @Override
    public TopicConnection getTopicConnection() {
        return (TopicConnection)this.wrapped_connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws JMSException {
        JMSXAWrappedTopicConnectionImpl.dlog("closing " + String.valueOf(this.wrapped_connection) + " " + this.wrapped_connection.getClass().getName());
        Vector vector = this.sessions_;
        synchronized (vector) {
            if (this.sessions_.isEmpty()) {
                this.closed_ = true;
            } else {
                this.markClosed_ = true;
            }
        }
        if (this.closed_) {
            this.hardClose();
        }
    }

    private void hardClose() throws JMSException {
        JMSXAWrappedTopicConnectionImpl.dlog("hard closing " + String.valueOf(this.wrapped_connection) + " " + this.wrapped_connection.getClass().getName());
        this.wrapped_connection.close();
        this.closed_ = true;
        JMSXAWrappedTopicConnectionImpl.dlog("hard closed " + String.valueOf(this.wrapped_connection) + " " + this.wrapped_connection.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(JMSXAWrappedTopicSessionImpl s) {
        Vector vector = this.sessions_;
        synchronized (vector) {
            this.sessions_.remove(s);
            if (this.sessions_.isEmpty() && this.markClosed_) {
                JMSXAWrappedTopicConnectionImpl.dlog("All sessions closed, hard close connection " + String.valueOf(this.wrapped_connection) + " " + this.wrapped_connection.getClass().getName());
                this.closed_ = true;
            }
        }
        if (this.closed_) {
            try {
                this.hardClose();
            }
            catch (JMSException e) {
                JMSXAWrappedTopicConnectionImpl.logWarning(e);
            }
        }
    }

    protected JMSXAConnectionFactory getJMSXAWrappedConnectionFactory() {
        return this.wcf_;
    }

    protected String getUsername() {
        return this.username_;
    }

    protected String getPassword() {
        return this.password_;
    }

    private static void dlog(String msg) {
        if (debug) {
            logger.log(System.Logger.Level.DEBUG, msg);
        }
    }

    private static void logWarning(Exception e) {
        logger.log(System.Logger.Level.WARNING, e.getMessage(), (Throwable)e);
    }
}

