/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.main.jdke.i18n.LocalStringsImpl;

public class ProgramOptions {
    private static final Set<CommandModel.ParamModel> programOptions;
    private static final Set<CommandModel.ParamModel> helpOption;
    public static final String HOST = "host";
    public static final String PORT = "port";
    public static final String USER = "user";
    public static final String PASSWORDFILE = "passwordfile";
    public static final String TERSE = "terse";
    public static final String ECHO = "echo";
    public static final String INTERACTIVE = "interactive";
    public static final String SECURE = "secure";
    public static final String HELP = "help";
    public static final String DETACH = "detach";
    public static final String NOTIFY = "notify";
    public static final String AUTHTOKEN = "_authtoken";
    public static final String AUXINPUT = "_auxinput";
    private static final Logger logger;
    private static final LocalStringsImpl strings;
    private ParameterMap options;
    private final Environment env;
    private boolean optionsSet;
    private char[] password;
    private PasswordLocation location;
    private String commandName;
    private String modulePath;
    private String classPath;
    private String className;

    private static void addMetaOption(Set<CommandModel.ParamModel> opts, String name, char sname, Class type, boolean req, String def) {
        CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(name, type, !req, def, Character.toString(sname));
        opts.add((CommandModel.ParamModel)opt);
    }

    public ProgramOptions(Environment env) throws CommandException {
        this(new ParameterMap(), env);
        this.optionsSet = false;
    }

    public ProgramOptions(ParameterMap options, Environment env) throws CommandException {
        this.env = env;
        this.updateOptions(options);
    }

    public ProgramOptions(ProgramOptions other) {
        this.options = new ParameterMap(other.options);
        this.env = other.env;
        this.password = other.password;
        this.modulePath = other.modulePath;
        this.classPath = other.classPath;
        this.className = other.className;
    }

    public final void updateOptions(ParameterMap newOptions) throws CommandException {
        String sport;
        if (this.options == null) {
            this.options = newOptions;
        } else {
            for (Map.Entry e : newOptions.entrySet()) {
                this.options.set((Object)((String)e.getKey()), (Collection)e.getValue());
            }
        }
        this.optionsSet = true;
        String host = (String)this.options.getOne((Object)HOST);
        if (ProgramOptions.ok(host)) {
            AtomicBoolean resolvable = new AtomicBoolean();
            Runnable hostResolution = () -> {
                try {
                    InetAddress.getByName(host);
                    resolvable.set(true);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Host could not be resolved: " + host, e);
                }
            };
            Thread thread = new Thread(hostResolution, "host-resolution");
            thread.setDaemon(true);
            thread.start();
            long timeout = 5000L;
            try {
                thread.join(timeout);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Host " + host + " could not be resolved in " + timeout + " ms", e);
            }
            if (!resolvable.get()) {
                throw new CommandException("Provided hostname could not be resolved to an IP address: " + host);
            }
        }
        if (ProgramOptions.ok(sport = (String)this.options.getOne((Object)PORT))) {
            String badPortMsg = strings.get("InvalidPortNumber", new Object[]{sport});
            try {
                int port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    throw new CommandException(badPortMsg);
                }
            }
            catch (NumberFormatException e) {
                throw new CommandException(badPortMsg);
            }
        }
    }

    private static boolean ok(String s) {
        return s != null && !s.isEmpty();
    }

    public static Collection<CommandModel.ParamModel> getValidOptions() {
        return programOptions;
    }

    public static Collection<CommandModel.ParamModel> getHelpOption() {
        return helpOption;
    }

    public void toEnvironment(Environment env) {
        this.putEnv(env, ECHO);
        this.putEnv(env, TERSE);
        this.putEnv(env, INTERACTIVE);
        this.putEnv(env, HOST);
        this.putEnv(env, PORT);
        this.putEnv(env, SECURE);
        this.putEnv(env, USER);
        this.putEnv(env, PASSWORDFILE);
        this.putEnv(env, AUTHTOKEN);
        this.putEnv(env, AUXINPUT);
        this.putEnv(env, DETACH);
    }

    private void putEnv(Environment env, String name) {
        String value = (String)this.options.getOne((Object)name);
        if (value != null) {
            env.putOption(name, value);
        }
    }

    public String getHost() {
        String host = (String)this.options.getOne((Object)HOST);
        if (!ProgramOptions.ok(host)) {
            host = this.env.getStringOption(HOST);
        }
        if (!ProgramOptions.ok(host)) {
            host = "localhost";
        }
        return host;
    }

    public void setHost(String host) {
        this.options.set((Object)HOST, (Object)host);
    }

    public int getPort() {
        int port;
        String sport = (String)this.options.getOne((Object)PORT);
        if (!ProgramOptions.ok(sport)) {
            sport = this.env.getStringOption(PORT);
        }
        if (ProgramOptions.ok(sport)) {
            try {
                port = Integer.parseInt(sport);
                if (port < 1 || port > 65535) {
                    port = -1;
                }
            }
            catch (NumberFormatException e) {
                port = -1;
            }
        } else {
            port = 4848;
        }
        return port;
    }

    public void setPort(int port) {
        this.options.set((Object)PORT, (Object)Integer.toString(port));
    }

    public void setHostAndPort(HostAndPort address) {
        this.setHost(address.getHost());
        this.setPort(address.getPort());
        this.setSecure(address.isSecure());
    }

    public String getUser() {
        String user = (String)this.options.getOne((Object)USER);
        if (!ProgramOptions.ok(user)) {
            user = this.env.getStringOption(USER);
        }
        if (!ProgramOptions.ok(user)) {
            user = null;
        }
        return user;
    }

    public void setUser(String user) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Setting user to: " + user);
        }
        this.options.set((Object)USER, (Object)user);
    }

    public char[] getPassword() {
        return this.password;
    }

    public PasswordLocation getPasswordLocation() {
        return this.location;
    }

    public void setPassword(char[] password, PasswordLocation location) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Setting password to: " + (password != null && password.length > 0 ? "<non-null>" : "<null>"));
        }
        this.password = password;
        this.location = location;
    }

    public String getPasswordFile() {
        String passwordFile = (String)this.options.getOne((Object)PASSWORDFILE);
        if (!ProgramOptions.ok(passwordFile)) {
            passwordFile = this.env.getStringOption(PASSWORDFILE);
        }
        if (!ProgramOptions.ok(passwordFile)) {
            return null;
        }
        if (!passwordFile.equals("-")) {
            passwordFile = SmartFile.sanitize((String)passwordFile);
        }
        return passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.options.set((Object)PASSWORDFILE, (Object)passwordFile);
    }

    public boolean isSecure() {
        String value;
        boolean secure = this.options.containsKey((Object)SECURE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)SECURE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(SECURE);
        return secure;
    }

    public void setSecure(boolean secure) {
        this.options.set((Object)SECURE, (Object)Boolean.toString(secure));
    }

    public void setAuthToken(String token) {
        this.options.set((Object)AUTHTOKEN, (Object)token);
    }

    public String getAuthToken() {
        return this.getString(AUTHTOKEN);
    }

    public void setAuxInput(String authInput) {
        this.options.set((Object)AUXINPUT, (Object)authInput);
    }

    public String getAuxInput() {
        return this.getString(AUXINPUT);
    }

    private String getString(String optionName) {
        String result = (String)this.options.getOne((Object)optionName);
        if (!ProgramOptions.ok(result) && !ProgramOptions.ok(result = this.env.getStringOption(optionName))) {
            result = null;
        }
        return result;
    }

    public boolean isTerse() {
        String value;
        boolean terse = this.options.containsKey((Object)TERSE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)TERSE)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(TERSE);
        return terse;
    }

    public boolean isDetachedCommand() {
        if (this.options.containsKey((Object)DETACH)) {
            String value = (String)this.options.getOne((Object)DETACH);
            return ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        return false;
    }

    public boolean isNotifyCommand() {
        if (this.options.containsKey((Object)NOTIFY)) {
            String value = (String)this.options.getOne((Object)NOTIFY);
            return ProgramOptions.ok(value) ? Boolean.parseBoolean(value) : true;
        }
        return false;
    }

    public void removeDetach() {
        if (this.options.containsKey((Object)DETACH)) {
            this.options.remove((Object)DETACH);
        }
    }

    public void setTerse(boolean terse) {
        this.options.set((Object)TERSE, (Object)Boolean.toString(terse));
    }

    public boolean isEcho() {
        String value;
        boolean echo = this.options.containsKey((Object)ECHO) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)ECHO)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(ECHO);
        return echo;
    }

    public void setEcho(boolean echo) {
        this.options.set((Object)ECHO, (Object)Boolean.toString(echo));
    }

    public boolean isInteractive() {
        String value;
        boolean interactive = this.options.containsKey((Object)INTERACTIVE) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)INTERACTIVE)) ? Boolean.parseBoolean(value) : true) : (this.env.hasOption(INTERACTIVE) ? this.env.getBooleanOption(INTERACTIVE) : System.console() != null);
        return interactive;
    }

    public void setInteractive(boolean interactive) {
        this.options.set((Object)INTERACTIVE, (Object)Boolean.toString(interactive));
    }

    public boolean isHelp() {
        String value;
        boolean help = false;
        help = this.options.containsKey((Object)HELP) ? (ProgramOptions.ok(value = (String)this.options.getOne((Object)HELP)) ? Boolean.parseBoolean(value) : true) : this.env.getBooleanOption(HELP);
        return help;
    }

    public void setHelp(boolean help) {
        this.options.set((Object)HELP, (Object)Boolean.toString(help));
    }

    public boolean isOptionsSet() {
        return this.optionsSet;
    }

    public void setOptionsSet(boolean optionsSet) {
        this.optionsSet = optionsSet;
    }

    public String[] getProgramArguments() {
        ArrayList<Object> args = new ArrayList<Object>(15);
        if (ProgramOptions.ok(this.getHost())) {
            args.add("--host");
            args.add(this.getHost());
        }
        if (this.getPort() > 0) {
            args.add("--port");
            args.add(String.valueOf(this.getPort()));
        }
        if (ProgramOptions.ok(this.getUser())) {
            args.add("--user");
            args.add(this.getUser());
        }
        if (ProgramOptions.ok(this.getPasswordFile())) {
            args.add("--passwordfile");
            args.add(this.getPasswordFile());
        }
        if (ProgramOptions.ok(this.getAuxInput())) {
            args.add("--_auxinput");
            args.add(this.getAuxInput());
        }
        args.add("--secure=" + String.valueOf(this.isSecure()));
        args.add("--terse=" + String.valueOf(this.isTerse()));
        args.add("--echo=" + String.valueOf(this.isEcho()));
        args.add("--interactive=" + String.valueOf(this.isInteractive()));
        String[] a = new String[args.size()];
        args.toArray(a);
        return a;
    }

    public String getPlainOption(String name) {
        return (String)this.options.getOne((Object)name);
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setClassPath(String classPath) {
        this.classPath = classPath;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getCommandName() {
        return this.commandName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (ProgramOptions.ok(this.getHost())) {
            sb.append("--host ").append(this.getHost()).append(' ');
        }
        if (this.getPort() > 0) {
            sb.append("--port ").append(this.getPort()).append(' ');
        }
        if (ProgramOptions.ok(this.getUser())) {
            sb.append("--user ").append(this.getUser()).append(' ');
        }
        if (ProgramOptions.ok(this.getPasswordFile())) {
            sb.append("--passwordfile ").append(this.getPasswordFile()).append(' ');
        }
        if (this.isSecure()) {
            sb.append("--secure ");
        }
        sb.append("--interactive=").append(Boolean.toString(this.isInteractive())).append(' ');
        sb.append("--echo=").append(Boolean.toString(this.isEcho())).append(' ');
        sb.append("--terse=").append(Boolean.toString(this.isTerse())).append(' ');
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    static {
        logger = Logger.getLogger(ProgramOptions.class.getPackage().getName());
        strings = new LocalStringsImpl(ProgramOptions.class);
        HashSet<CommandModel.ParamModel> opts = new HashSet<CommandModel.ParamModel>();
        HashSet<CommandModel.ParamModel> hopts = new HashSet<CommandModel.ParamModel>();
        ProgramOptions.addMetaOption(opts, HOST, 'H', String.class, false, "localhost");
        ProgramOptions.addMetaOption(opts, PORT, 'p', String.class, false, Integer.toString(4848));
        ProgramOptions.addMetaOption(opts, USER, 'u', String.class, false, null);
        ProgramOptions.addMetaOption(opts, PASSWORDFILE, 'W', File.class, false, null);
        ProgramOptions.addMetaOption(opts, SECURE, 's', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, TERSE, 't', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, ECHO, 'e', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, INTERACTIVE, 'I', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, HELP, '?', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, AUXINPUT, '\u0000', String.class, false, null);
        ProgramOptions.addMetaOption(opts, AUTHTOKEN, '\u0000', String.class, false, null);
        ProgramOptions.addMetaOption(opts, DETACH, '\u0000', Boolean.class, false, "false");
        ProgramOptions.addMetaOption(opts, NOTIFY, '\u0000', Boolean.class, false, "false");
        programOptions = Collections.unmodifiableSet(opts);
        ProgramOptions.addMetaOption(hopts, HELP, '?', Boolean.class, false, "false");
        helpOption = Collections.unmodifiableSet(hopts);
    }

    public static enum PasswordLocation {
        DEFAULT,
        USER,
        PASSWORD_FILE,
        LOGIN_FILE,
        LOCAL_PASSWORD;

    }
}

