/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.codegen.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.pfl.basic.func.NullaryFunction;
import org.glassfish.pfl.dynamic.codegen.impl.AttributedObject;

public class Attribute<T> {
    private static List<Attribute<?>> attributes = new ArrayList();
    private String name;
    private NullaryFunction<T> initializer;
    private T defaultValue;
    private Class<T> cls;
    private int attributeIndex;

    private static synchronized int next(Attribute<?> attr) {
        for (int ctr = 0; ctr < attributes.size(); ++ctr) {
            if (!attr.name().equals(attributes.get(ctr).name())) continue;
            return ctr;
        }
        int result = attributes.size();
        attributes.add(attr);
        return result;
    }

    public static int numberOfAttributes() {
        return attributes.size();
    }

    public static Attribute<?> get(int index) {
        if (index >= 0 && index < attributes.size()) {
            return attributes.get(index);
        }
        throw new IllegalArgumentException();
    }

    public static Set<Attribute<?>> getAttributes(AttributedObject node) {
        List<Object> attrs = node.attributes();
        HashSet result = new HashSet();
        if (attrs == null) {
            return result;
        }
        for (int ctr = 0; ctr < attrs.size(); ++ctr) {
            Object value = attrs.get(ctr);
            if (value == null) continue;
            result.add(attributes.get(ctr));
        }
        return result;
    }

    public String toString() {
        return "Attribute[" + this.name + ":" + this.cls.getName() + ":" + this.attributeIndex + "]";
    }

    public Attribute(Class<T> cls, String name, T defaultValue) {
        this.cls = cls;
        this.name = name;
        this.initializer = null;
        this.defaultValue = defaultValue;
        this.attributeIndex = Attribute.next(this);
    }

    public Attribute(Class<T> cls, String name, NullaryFunction<T> initializer) {
        this.cls = cls;
        this.name = name;
        this.initializer = initializer;
        this.defaultValue = null;
        this.attributeIndex = Attribute.next(this);
    }

    public T get(AttributedObject node) {
        Object result = this.cls.cast(node.get(this.attributeIndex));
        if (result == null) {
            result = this.initializer != null ? this.initializer.evaluate() : this.defaultValue;
            node.set(this.attributeIndex, result);
        }
        return result;
    }

    public void set(AttributedObject node, T arg) {
        node.set(this.attributeIndex, arg);
    }

    public boolean isSet(AttributedObject node) {
        return node.get(this.attributeIndex) != null;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    public Class<?> type() {
        return this.cls;
    }
}

