/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import org.glassfish.admin.amx.util.DebugOut;
import org.glassfish.admin.amx.util.DebugSink;
import org.glassfish.admin.amx.util.DebugSinkImpl;
import org.glassfish.admin.amx.util.StringUtil;

public class DebugOutImpl
implements DebugOut {
    private final String mID;
    private boolean mDebug;
    private DebugSink mSink;

    public DebugOutImpl(String id, boolean debug, DebugSink sink) {
        this.mID = id;
        this.mDebug = debug;
        this.mSink = sink == null ? new DebugSinkImpl(System.out) : sink;
    }

    public DebugOutImpl(String id, boolean debug) {
        this(id, debug, null);
    }

    @Override
    public String getID() {
        return this.mID;
    }

    @Override
    public boolean getDebug() {
        return this.mDebug;
    }

    @Override
    public void print(Object o) {
        this.mSink.print(String.valueOf(o));
    }

    @Override
    public void println(Object o) {
        this.mSink.println(String.valueOf(o));
    }

    public String toString(Object ... args) {
        return StringUtil.toString(", ", args);
    }

    public void setDebug(boolean debug) {
        this.mDebug = debug;
    }

    @Override
    public void debug(Object ... args) {
        if (this.getDebug()) {
            this.mSink.println(this.toString(args));
        }
    }

    @Override
    public void debugMethod(String methodName, Object ... args) {
        if (this.getDebug()) {
            this.debug(DebugOutImpl.methodString(methodName, args));
        }
    }

    @Override
    public void debugMethod(String msg, String methodName, Object ... args) {
        if (this.getDebug()) {
            this.debug(DebugOutImpl.methodString(methodName, args) + ": " + msg);
        }
    }

    public static String methodString(String name, Object ... args) {
        Object result = null;
        if (args == null || args.length == 0) {
            result = name + "()";
        } else {
            String argsString = StringUtil.toString(", ", args);
            result = StringUtil.toString("", name, "(", argsString, ")");
        }
        return result;
    }
}

